/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.awt.Component;
import java.awt.Insets;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.javatools.icons.OracleIcons;

public class QuickAVEditableCellRenderer
extends DefaultTableCellRenderer {
    private JLabel label = null;
    private Set<Integer> comboboxEditRenderedColumns;

    public QuickAVEditableCellRenderer(Set<Integer> set) {
        this.comboboxEditRenderedColumns = set;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (jTable.isCellEditable(n, n2)) {
            if (component instanceof JLabel) {
                this.label = (JLabel)component;
                this.label.setHorizontalTextPosition(2);
                if (this.comboboxEditRenderedColumns != null && this.comboboxEditRenderedColumns.contains(n2)) {
                    this.setCellIcon(OracleIcons.getIcon((String)"extras/dropdown.png"), n2, jTable, (String)object);
                } else {
                    this.setCellIcon(OracleIcons.getIcon((String)"edit.png"), n2, jTable, (String)object);
                }
            }
        } else {
            this.setIcon(null);
        }
        return component;
    }

    private void setCellIcon(Icon icon, int n, JTable jTable, String string) {
        int n2 = this.getFontMetrics(this.getFont()).stringWidth(string);
        Insets insets = this.getInsets();
        int n3 = 0;
        int n4 = jTable.getColumnModel().getColumn(n).getWidth();
        this.label.setIcon(icon);
        n3 = n4 - n2 - this.label.getIcon().getIconWidth() - insets.left - insets.right - 5;
        this.label.setIconTextGap(n3);
    }
}

