/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Table;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.panels.LevelGenerator;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.QuickAVDataPanel;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;

public class QuickAVDimensionGenerator {
    private DBUtil dbUtil;
    private static Queries queries;
    private static final String CONSTRAINTS_MAP = "CONSTRAINTS_MAP";
    private static final String EXISTING_TABLES_AND_VIEWS = "EXISTING_TABLES_AND_VIEWS";
    private static final String COLUMNS_FOR_SRC_TABLE = "COLUMNS_FOR_SRC_TABLE";
    private static final String VIEW_NAME_KEY = "VIEW_NAME";
    private static final String DIM_ATTR_NAME = "DIM_ATTR_NAME";
    private static final String DIM_STD_TYPE = "STANDARD";
    private static final String DATA_TYPE_KEY = "DATA_TYPE_KEY";
    private Map<String, String> views;
    private Map<String, Hierarchy> hierarchies;
    private Database db;
    private List<String> existingTableAndViewNames;
    private HashSet<ConstraintsMap> factConstraints;
    private HCSSchema schema;
    private DatabaseSource factTable;

    public QuickAVDimensionGenerator(DatabaseSource databaseSource, HCSSchema hCSSchema, Database database) {
        this.schema = hCSSchema;
        this.factTable = databaseSource;
        this.db = database;
        this.views = new HashMap<String, String>();
        this.hierarchies = new HashMap<String, Hierarchy>();
        if (queries == null) {
            try {
                String string = "oracle.hcs.table";
                String string2 = "avdimensionqueries.xml";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), string2);
                JavaXMLBind.BindToJavaStr(string3, string, this);
            }
            catch (Exception exception) {
                Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
            }
        }
        this.initializeConstraintsSet(databaseSource);
        this.initializeExistingTableAndViewNames();
    }

    public void clear() {
        this.views.clear();
        this.hierarchies.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeConstraintsSet(DatabaseSource databaseSource) {
        this.clear();
        this.factConstraints = new HashSet();
        this.dbUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", databaseSource.getSchemaName());
        hashMap.put("source", databaseSource.getName());
        String string = queries.getSQL(CONSTRAINTS_MAP);
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.db.getConnection());
            resultSet = this.dbUtil.executeQuery(string, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    ConstraintsMap constraintsMap = new ConstraintsMap(string2, string3, string4);
                    DatabaseSource databaseSource2 = this.createDimensionDBSource(string2);
                    constraintsMap.setDBSource(databaseSource2);
                    this.factConstraints.add(constraintsMap);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
                }
            }
            Connections.getInstance().unlock(this.db.getConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseSource createDimensionDBSource(String string) {
        Table table = new Table(this.schema.getName(), string, null);
        this.dbUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.schema.getName());
        hashMap.put("table_name", string);
        String string2 = queries.getSQL(COLUMNS_FOR_SRC_TABLE);
        ResultSet resultSet = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        try {
            Connections.getInstance().lock(this.db.getConnection());
            resultSet = this.dbUtil.executeQuery(string2, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    arrayList.add(new Column(string3, "N", string4));
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
                }
            }
            Connections.getInstance().unlock(this.db.getConnection());
        }
        table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExistingTableAndViewNames() {
        this.existingTableAndViewNames = new ArrayList<String>();
        this.dbUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.schema.getName());
        String string = queries.getSQL(EXISTING_TABLES_AND_VIEWS);
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.db.getConnection());
            resultSet = this.dbUtil.executeQuery(string, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    this.existingTableAndViewNames.add(string2);
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    Logger.log(QuickAVDimensionGenerator.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
                }
            }
            Connections.getInstance().unlock(this.db.getConnection());
        }
    }

    public AttributeDimension findDimensionFromSchema(String string, String string2, String string3) {
        AttributeDimension attributeDimension = this.schema.findDimension(string);
        if (attributeDimension != null) {
            attributeDimension.setProperty(VIEW_NAME_KEY, string2);
            attributeDimension.setProperty(DATA_TYPE_KEY, string3);
        }
        return attributeDimension;
    }

    public List<AttributeDimension> findDimForMapExpression(String string) {
        List<AttributeDimension> list = this.schema.getDimensions();
        ArrayList<AttributeDimension> arrayList = new ArrayList<AttributeDimension>();
        block0: for (AttributeDimension attributeDimension : list) {
            if (this.columnFoundInConstraintsMap(attributeDimension, string)) {
                arrayList.add(attributeDimension);
                continue;
            }
            for (DimensionAttribute dimensionAttribute : attributeDimension.getAttributes()) {
                if (!dimensionAttribute.getMapExpression().equals(string)) continue;
                arrayList.add(attributeDimension);
                continue block0;
            }
        }
        return arrayList;
    }

    private boolean columnFoundInConstraintsMap(AttributeDimension attributeDimension, String string) {
        if (this.factConstraints.isEmpty()) {
            return false;
        }
        if (attributeDimension.getSources() != null && attributeDimension.getSources().length >= 1) {
            for (ConstraintsMap constraintsMap : this.factConstraints) {
                if (!constraintsMap.getFactSrcColumn().equalsIgnoreCase(string) || !constraintsMap.getDimTable().equalsIgnoreCase(attributeDimension.getSources()[0].getName())) continue;
                attributeDimension.setProperty(DIM_ATTR_NAME, constraintsMap.getDimTablePk());
                return true;
            }
        }
        return false;
    }

    public AttributeDimension createNewDimension(String string, String string2) {
        return this.createNewDimension(string, string2, false);
    }

    public AttributeDimension createNewDimensionDistinct(String string, String string2) {
        String string3 = this.generateNameForDimension(string);
        AttributeDimension attributeDimension = new AttributeDimension(this.schema, string3, "");
        this.buildNewDimDetails(attributeDimension, this.factTable.getName(), string, string2, string);
        return attributeDimension;
    }

    public AttributeDimension createNewDimension(String string, String string2, boolean bl) {
        String string3 = this.generateNameForDimension(string);
        AttributeDimension attributeDimension = new AttributeDimension(this.schema, string3, "");
        ConstraintsMap constraintsMap = this.findConstraintsMapForColumn(string);
        boolean bl2 = bl;
        if (constraintsMap == null) {
            if (bl) {
                String string4 = this.generateViewName(string);
                this.views.put(string, string4);
            } else {
                this.views.put(string, String.format("%s_VIEW", string));
            }
            this.buildNewDimDetails(attributeDimension, this.views.get(string), string, string2, string);
        } else {
            this.buildNewDimDetails(attributeDimension, constraintsMap.getDimTable(), constraintsMap.getDimTablePk(), string2, string, constraintsMap.getDBSource(), bl2);
            attributeDimension.setProperty(DIM_ATTR_NAME, constraintsMap.getDimTablePk());
        }
        return attributeDimension;
    }

    private ConstraintsMap findConstraintsMapForColumn(String string) {
        if (this.factConstraints.isEmpty()) {
            return null;
        }
        for (ConstraintsMap constraintsMap : this.factConstraints) {
            if (!constraintsMap.getFactSrcColumn().equalsIgnoreCase(string)) continue;
            return constraintsMap;
        }
        return null;
    }

    public String findDimensionTableSourceForColumn(String string) {
        ConstraintsMap constraintsMap = this.findConstraintsMapForColumn(string);
        if (constraintsMap != null) {
            return constraintsMap.getDimTable();
        }
        return null;
    }

    public boolean sourceTableHasConstraints() {
        return !this.factConstraints.isEmpty();
    }

    private void buildNewDimDetails(AttributeDimension attributeDimension, String string, String string2, String string3, String string4) {
        this.buildNewDimDetails(attributeDimension, string, string2, string3, string4, null, false);
    }

    private void buildNewDimDetails(final AttributeDimension attributeDimension, String string, final String string2, String string3, final String string4, DatabaseSource databaseSource, boolean bl) {
        if (databaseSource == null) {
            databaseSource = new Table(this.schema.getName(), string, null);
        }
        attributeDimension.addSource(databaseSource);
        attributeDimension.setProperty(VIEW_NAME_KEY, string4);
        attributeDimension.setProperty(DATA_TYPE_KEY, string3);
        attributeDimension.setDimensionType(DIM_STD_TYPE);
        if (databaseSource.getColumns() != null && databaseSource.getColumns().length > 0) {
            Object object;
            boolean bl2 = false;
            for (Column column : databaseSource.getColumns()) {
                DimensionAttribute dimensionAttribute = new DimensionAttribute(column.getName());
                dimensionAttribute.setMapExpression(column.getName());
                attributeDimension.addAttribute(dimensionAttribute);
                this.setDescriptions(dimensionAttribute, column.getName());
                bl2 = bl2 || column.isNumeric();
            }
            if (bl2) {
                object = new Thread(){

                    @Override
                    public void run() {
                        LevelGenerator levelGenerator = new LevelGenerator((DBObjectProvider)QuickAVDimensionGenerator.this.db, attributeDimension);
                        levelGenerator.generate();
                        QuickAVDimensionGenerator.this.addHierarchyToDimension(string4, string2, attributeDimension);
                    }
                };
                ((Thread)object).start();
                if (bl) {
                    try {
                        ((Thread)object).join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.isDimPrimaryKeyIncludedInLevel(attributeDimension)) {
                        attributeDimension.removeAllLevels();
                        DimensionLevel dimensionLevel = this.generateSingleLevel(attributeDimension, string2);
                        attributeDimension.addLevel(dimensionLevel);
                        this.addHierarchyToDimension(string4, string2, attributeDimension);
                    }
                }
            } else {
                object = this.generateSingleLevel(attributeDimension, string2);
                attributeDimension.addLevel((DimensionLevel)object);
                this.addHierarchyToDimension(string4, string2, attributeDimension);
            }
        } else {
            DimensionAttribute dimensionAttribute = new DimensionAttribute(string2);
            dimensionAttribute.setMapExpression(string2);
            attributeDimension.addAttribute(dimensionAttribute);
            this.setDescriptions(dimensionAttribute, string2);
            DimensionLevel dimensionLevel = this.generateSingleLevel(attributeDimension, string2);
            attributeDimension.addLevel(dimensionLevel);
            this.addHierarchyToDimension(string4, string2, attributeDimension);
        }
        this.setDescriptions(attributeDimension, string2);
        attributeDimension.setAllMemberCaption(String.format("'All %s'", string2));
        attributeDimension.setAllMemberName("'1'");
        attributeDimension.setAllMemberDescription(String.format("'All %s'", string2));
    }

    private DimensionLevel generateSingleLevel(AttributeDimension attributeDimension, String string) {
        DimensionLevel dimensionLevel = new DimensionLevel(attributeDimension, string);
        dimensionLevel.setLevelKey(string);
        String string2 = this.db.getExternalName(string);
        dimensionLevel.setLevelMemberCaption(String.format("to_char(%s)", string2));
        dimensionLevel.setLevelMemberDescription(String.format("to_char(%s)", string2));
        dimensionLevel.setLevelMemberName(String.format("to_char(%s)", string2));
        this.setDescriptions(dimensionLevel, string);
        return dimensionLevel;
    }

    private void addHierarchyToDimension(String string, String string2, AttributeDimension attributeDimension) {
        String string3 = QuickAVDimensionGenerator.generateNameForHierarchy(attributeDimension.getName(), this.schema);
        Hierarchy hierarchy = new Hierarchy(this.schema, string3, attributeDimension.getName());
        hierarchy.setDimensionName(attributeDimension.getName());
        hierarchy.setDimension(attributeDimension);
        HierarchyLevel hierarchyLevel = new HierarchyLevel(hierarchy, attributeDimension.getLevels()[0]);
        hierarchy.addHierarchyLevel(hierarchyLevel);
        this.setDescriptions(hierarchy, string2);
        this.hierarchies.put(string, hierarchy);
    }

    private boolean isDimPrimaryKeyIncludedInLevel(AttributeDimension attributeDimension) {
        ConstraintsMap constraintsMap = this.findConstraintsMapForSourceTable(attributeDimension.getSources()[0].getName());
        for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
            if (!dimensionLevel.getLevelKey().equalsIgnoreCase(constraintsMap.getDimTablePk())) continue;
            return true;
        }
        return false;
    }

    private ConstraintsMap findConstraintsMapForSourceTable(String string) {
        ConstraintsMap constraintsMap = null;
        for (ConstraintsMap constraintsMap2 : this.factConstraints) {
            if (!constraintsMap2.getDimTable().equalsIgnoreCase(string)) continue;
            return constraintsMap2;
        }
        return constraintsMap;
    }

    private String generateNameForDimension(String string) {
        String string2 = "_DIM";
        string = QuickAVDataPanel.truncateName(string);
        AttributeDimension attributeDimension = this.schema.findDimension(String.format("%s%s", string, string2));
        if (attributeDimension == null) {
            return String.format("%s%s", string, string2);
        }
        int n = 1;
        while (this.schema.findDimension(String.format("%s%s_%s", string, string2, n)) != null) {
            ++n;
        }
        return String.format("%s%s_%s", string, string2, n);
    }

    private String generateViewName(String string) {
        String string2 = "_VIEW";
        string = QuickAVDataPanel.truncateName(string);
        if (!this.existingTableAndViewNames.contains(String.format("%s%s", string, string2))) {
            return String.format("%s%s", string, string2);
        }
        int n = 1;
        while (this.existingTableAndViewNames.contains(String.format("%s%s_%s", string, string2, n))) {
            ++n;
        }
        return String.format("%s%s_%s", string, string2, n);
    }

    public List<String> getExistingTableAndViewNames() {
        return this.existingTableAndViewNames;
    }

    protected static String generateNameForHierarchy(String string, HCSSchema hCSSchema) {
        String string2 = "_HIER";
        string = QuickAVDataPanel.truncateName(string);
        Hierarchy hierarchy = hCSSchema.findHierarchy(String.format("%s%s", string, string2));
        if (hierarchy == null) {
            return String.format("%s%s", string, string2);
        }
        int n = 1;
        while (hCSSchema.findHierarchy(String.format("%s%s_%s", string, string2, n)) != null) {
            ++n;
        }
        return String.format("%s%s_%s", string, string2, n);
    }

    private void setDescriptions(Descriptions descriptions, String string) {
        descriptions.setDescription(string);
        descriptions.setCaption(string);
    }

    public String getViewName(String string) {
        return this.views.get(string);
    }

    public int getViewsCount() {
        return this.views.size();
    }

    public Hierarchy getHierarchy(String string) {
        return this.hierarchies.get(string);
    }

    public Collection<Hierarchy> getAllHierarchies() {
        return this.hierarchies.values();
    }

    public void addQueries(Queries queries) {
        QuickAVDimensionGenerator.queries = queries;
    }

    private class ConstraintsMap {
        private String dimTable;
        private String dimTablePk;
        private String factSrcColumn;
        private DatabaseSource dbSource;

        public ConstraintsMap(String string, String string2, String string3) {
            this.dimTable = string;
            this.dimTablePk = string2;
            this.factSrcColumn = string3;
        }

        public String getDimTable() {
            return this.dimTable;
        }

        public String getDimTablePk() {
            return this.dimTablePk;
        }

        public String getFactSrcColumn() {
            return this.factSrcColumn;
        }

        public void setDBSource(DatabaseSource databaseSource) {
            this.dbSource = databaseSource;
        }

        public DatabaseSource getDBSource() {
            return this.dbSource;
        }
    }
}

