/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.navigator;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.hcs.av.calcs.CalculatedMeasurePinningTracker;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

public class CalculatedMeasureBufferPinning
extends NodeListener {
    public static final String anonBlock = "anon_block";
    private Map<Node, ReadTextBuffer> pinnedBuffers = new TreeMap<Node, ReadTextBuffer>();

    public void nodeOpened(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        TextBuffer textBuffer = ((CalculatedMeasureNode)node).acquireTextBuffer();
        this.pinnedBuffers.put(node, (ReadTextBuffer)textBuffer);
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("AUTOPINPLSQLEDITORS").booleanValue() && !node.getURL().getFile().contains(anonBlock)) {
            CalculatedMeasurePinningTracker.pinNode(node);
        }
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        ((CalculatedMeasureNode)node).releaseTextBuffer();
        this.pinnedBuffers.remove(node);
        CalculatedMeasurePinningTracker.unpinNode(node);
    }
}

