/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.metadata;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Schema;

public class HCSSchema
extends Schema {
    private List<AttributeDimension> attributeDimensions = new ArrayList<AttributeDimension>();
    private List<AnalyticView> analyticViews = new ArrayList<AnalyticView>();
    private List<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
    private boolean loaded;

    public HCSSchema(String string) {
        super(string);
    }

    public void clear() {
        this.attributeDimensions.clear();
        this.analyticViews.clear();
        this.hierarchies.clear();
    }

    public void addDimension(AttributeDimension attributeDimension) {
        this.attributeDimensions.add(attributeDimension);
    }

    public void addAV(AnalyticView analyticView) {
        this.analyticViews.add(analyticView);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractDBObject getNamedObject(String string) {
        void var2_6;
        Object var2_2 = null;
        IdentifierElement identifierElement = new IdentifierElement(string);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (identifierElement.getCount() > 0) {
            string2 = identifierElement.get(0);
        }
        if (identifierElement.getCount() > 1) {
            string3 = identifierElement.get(1);
        }
        if (identifierElement.getCount() > 2) {
            string4 = identifierElement.get(2);
        }
        if (string2 == null) return var2_6;
        AttributeDimension attributeDimension = this.findDimension(string2);
        if (attributeDimension == null) {
            AnalyticView analyticView = this.findAV(string2);
            if (string3 != null) {
                if (analyticView == null) return var2_6;
                return var2_6;
            } else {
                AnalyticView analyticView2 = analyticView;
            }
            return var2_6;
        } else {
            if (string3 != null) {
                DimensionLevel dimensionLevel = attributeDimension.findLevel(string3);
                if (dimensionLevel != null) return var2_6;
            }
            AttributeDimension attributeDimension2 = attributeDimension;
        }
        return var2_6;
    }

    public List<AttributeDimension> getDimensions() {
        return this.attributeDimensions;
    }

    public void addHierarchy(Hierarchy hierarchy) {
        this.hierarchies.add(hierarchy);
    }

    public List<Hierarchy> getHierarchies() {
        return this.hierarchies;
    }

    public List<Hierarchy> getHierarchies(AttributeDimension attributeDimension) {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        for (Hierarchy hierarchy : this.hierarchies) {
            String string = hierarchy.getDimensionName();
            if (!hierarchy.getSchema().getName().equals(attributeDimension.getSchema().getName()) || !string.equals(attributeDimension.getName())) continue;
            arrayList.add(hierarchy);
        }
        return arrayList;
    }

    public Hierarchy getDefaultHierarchy(AttributeDimension attributeDimension) {
        List<Hierarchy> list = this.getHierarchies(attributeDimension);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void addAnalyticView(AnalyticView analyticView) {
        this.analyticViews.add(analyticView);
    }

    public List<AnalyticView> getAnalyticViews() {
        return this.analyticViews;
    }

    public AttributeDimension findDimension(String string) {
        if (string != null && !string.isEmpty()) {
            String string2 = string;
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.replace("\"", "");
            }
            for (AttributeDimension attributeDimension : this.attributeDimensions) {
                String string3 = attributeDimension.getName();
                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.replace("\"", "");
                }
                if (!string3.equals(string2)) continue;
                return attributeDimension;
            }
        }
        return null;
    }

    public Hierarchy findHierarchy(String string) {
        if (string != null && !string.isEmpty()) {
            String string2 = string;
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.replace("\"", "");
            }
            for (Hierarchy hierarchy : this.hierarchies) {
                String string3 = hierarchy.getName();
                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.replace("\"", "");
                }
                if (!string3.equals(string2)) continue;
                return hierarchy;
            }
        }
        return null;
    }

    public List<Hierarchy> findHierarchies(String string) {
        ArrayList<Hierarchy> arrayList = new ArrayList<Hierarchy>();
        if (string != null && !string.isEmpty()) {
            for (Hierarchy hierarchy : this.hierarchies) {
                if (!hierarchy.getDimensionName().equals(string)) continue;
                arrayList.add(hierarchy);
            }
        }
        return arrayList;
    }

    public AnalyticView findAV(String string) {
        if (string != null && !string.isEmpty()) {
            String string2 = string;
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.replace("\"", "");
            }
            for (AnalyticView analyticView : this.analyticViews) {
                String string3 = analyticView.getName();
                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.replace("\"", "");
                }
                if (!string3.equals(string2)) continue;
                return analyticView;
            }
        }
        return null;
    }

    public String getType() {
        return null;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public HCSSchema copy() {
        AbstractMappableSchemaObjectWithDesc abstractMappableSchemaObjectWithDesc;
        HCSSchema hCSSchema = new HCSSchema(this.getName());
        hCSSchema.setLoaded(true);
        for (AttributeDimension abstractMappableSchemaObjectWithDesc2 : this.getDimensions()) {
            abstractMappableSchemaObjectWithDesc = (AttributeDimension)abstractMappableSchemaObjectWithDesc2.copyTo(null);
            hCSSchema.addDimension((AttributeDimension)abstractMappableSchemaObjectWithDesc);
        }
        for (Hierarchy hierarchy : this.getHierarchies()) {
            abstractMappableSchemaObjectWithDesc = (Hierarchy)hierarchy.copyTo(null);
            hCSSchema.addHierarchy((Hierarchy)abstractMappableSchemaObjectWithDesc);
        }
        for (AnalyticView analyticView : this.getAnalyticViews()) {
            abstractMappableSchemaObjectWithDesc = (AnalyticView)analyticView.copyTo(null);
            hCSSchema.addAV((AnalyticView)abstractMappableSchemaObjectWithDesc);
        }
        return hCSSchema;
    }
}

