/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchy.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.hcs.HCSArb;
import oracle.hcs.db.panels.GeneralBaseEditorPanel;
import oracle.hcs.dimension.DimensionLister;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.hierarchy.panels.HierarchyInitializer;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.Schema;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;

public class HierarchyGeneralPanel
extends GeneralBaseEditorPanel<Hierarchy> {
    private Shuttle shuttle;
    private JComponent determinesComponent;
    private DefaultListModel selectedObjectListModel;
    private DefaultListModel allObjectListModel;
    private JList allObjectList;
    private JList selectedObjectList;
    private DBObjectChooser hierarchyDimensionChooser;
    private DefaultTableModel tableModel;
    private JTable table;
    public static final String ALL_DIMENSIONS = "dimensions";

    public HierarchyGeneralPanel() {
        this.setDbObjectInitializer(new HierarchyInitializer());
    }

    public DimensionLevel getLevel(AttributeDimension attributeDimension, HierarchyLevel hierarchyLevel) {
        String string = hierarchyLevel.getHierarchyLevelName();
        DimensionLevel dimensionLevel = attributeDimension.findLevel(string);
        if (dimensionLevel == null) {
            dimensionLevel = new DimensionLevel(null, string);
        }
        return dimensionLevel;
    }

    private void updateDetermines(ListModel listModel) {
        this.tableModel.setRowCount(0);
        int n = listModel.getSize();
        this.determinesComponent.setVisible(n > 0);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            hashSet.add(listModel.getElementAt(i).toString());
        }
        AttributeDimension attributeDimension = (AttributeDimension)this.hierarchyDimensionChooser.getDBObject();
        List<DimensionLevel> list = Arrays.asList(attributeDimension.getLevels());
        for (DimensionLevel dimensionLevel : list) {
            if (!hashSet.contains(dimensionLevel.getName())) continue;
            for (String string : dimensionLevel.getLevelDeterminesKeys()) {
                this.tableModel.addRow(new Object[]{dimensionLevel.getName(), string});
            }
        }
    }

    private void dimensionSelectionChanged() {
        AttributeDimension attributeDimension = (AttributeDimension)this.hierarchyDimensionChooser.getDBObject();
        if (attributeDimension == null) {
            return;
        }
        this.selectedObjectListModel.removeAllElements();
        this.initPickerFromWithAvailableLevels(new HierarchyLevel[0], attributeDimension);
    }

    private void initPickerToWithSelectedLevels(HierarchyLevel[] hierarchyLevelArray, AttributeDimension attributeDimension) {
        this.selectedObjectListModel.removeAllElements();
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray) {
            DimensionLevel dimensionLevel = this.getLevel(attributeDimension, hierarchyLevel);
            if (dimensionLevel == null) continue;
            this.selectedObjectListModel.addElement(dimensionLevel);
        }
    }

    private void initPickerFromWithAvailableLevels(HierarchyLevel[] hierarchyLevelArray, AttributeDimension attributeDimension) {
        ArrayList<DimensionLevel> arrayList = new ArrayList<DimensionLevel>();
        DimensionLevel[] dimensionLevelArray = attributeDimension.getLevels();
        if (dimensionLevelArray != null) {
            for (DimensionLevel dimensionLevel : dimensionLevelArray) {
                arrayList.add(dimensionLevel);
            }
            List<DimensionLevel> list = this.getDefaultSortedLevelList(arrayList);
            this.allObjectListModel.removeAllElements();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DimensionLevel dimensionLevel = (DimensionLevel)iterator.next();
                boolean bl = false;
                String string = this.getProvider().getExternalName(dimensionLevel.getName());
                for (HierarchyLevel hierarchyLevel : hierarchyLevelArray) {
                    String string2 = this.getProvider().getExternalName(hierarchyLevel.getHierarchyLevelName());
                    if (hierarchyLevel == null || !string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.allObjectListModel.addElement(dimensionLevel);
            }
        }
    }

    private List<DimensionLevel> getDefaultSortedLevelList(List<DimensionLevel> list) {
        ArrayList<DimensionLevel> arrayList = new ArrayList<DimensionLevel>();
        HashMap<DimensionLevel, Integer> hashMap = new HashMap<DimensionLevel, Integer>();
        for (DimensionLevel dimensionLevel : list) {
            String string = dimensionLevel.getName();
            String[] stringArray = dimensionLevel.getLevelDeterminesKeys();
            int n = 0;
            if (stringArray.length > 0) {
                block1: for (DimensionLevel dimensionLevel2 : list) {
                    String string2 = dimensionLevel2.getName();
                    String string3 = dimensionLevel2.getLevelKey();
                    if (string.equalsIgnoreCase(string2)) continue;
                    for (String string4 : stringArray) {
                        if (string3 == null || !string3.equalsIgnoreCase(string4)) continue;
                        ++n;
                        continue block1;
                    }
                }
                if (n == 0) {
                    arrayList.add(dimensionLevel);
                    continue;
                }
                hashMap.put(dimensionLevel, n);
                continue;
            }
            hashMap.put(dimensionLevel, 0);
        }
        arrayList.addAll(HierarchyGeneralPanel.sortLevelDeterminesList(new LinkedList<DimensionLevel>(hashMap.keySet())));
        return arrayList;
    }

    private static List<DimensionLevel> sortLevelDeterminesList(List<DimensionLevel> list) {
        Collections.sort(list, new Comparator<DimensionLevel>(){

            @Override
            public int compare(DimensionLevel dimensionLevel, DimensionLevel dimensionLevel2) {
                for (String string : dimensionLevel.getLevelDeterminesKeys()) {
                    if (!string.equalsIgnoreCase(dimensionLevel2.getLevelKey())) continue;
                    return 1;
                }
                return -1;
            }
        });
        return list;
    }

    @Override
    protected void initialisePanel() {
        HierarchyLevel[] hierarchyLevelArray;
        AttributeDimension attributeDimension;
        super.initialisePanel();
        this.hierarchyDimensionChooser.setProvider(this.getProvider());
        Hierarchy hierarchy = (Hierarchy)this.getUpdatedObject();
        String string = hierarchy.getDimensionName();
        if (string != null) {
            try {
                attributeDimension = this.getProvider().getObject("ATTRIBUTE DIMENSION", hierarchy.getSchema(), string);
                if (attributeDimension == null) {
                    attributeDimension = new AttributeDimension(null, string, null);
                }
                this.hierarchyDimensionChooser.setDBObject((DBObject)attributeDimension);
            }
            catch (DBException dBException) {
                hierarchyLevelArray = null;
                String string2 = dBException.getLocalizedMessage();
                if (string2 == null || string2.length() == 0) {
                    string2 = ((Object)((Object)dBException)).getClass().toString();
                }
                String string3 = HCSArb.get("FETCH_DIMENSION_LIST_TITLE");
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, (String)hierarchyLevelArray);
            }
        }
        if (this.isEditing()) {
            attributeDimension = (AttributeDimension)this.hierarchyDimensionChooser.getDBObject();
            hierarchyLevelArray = ((Hierarchy)this.getUpdatedObject()).getHierarchyLevelsReverse();
            this.initPickerToWithSelectedLevels(hierarchyLevelArray, attributeDimension);
            this.initPickerFromWithAvailableLevels(hierarchyLevelArray, attributeDimension);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        Hierarchy hierarchy = (Hierarchy)this.getUpdatedObject();
        String string = null;
        if (this.hierarchyDimensionChooser.getDBObject() != null) {
            string = this.hierarchyDimensionChooser.getDBObject().getName();
        }
        hierarchy.setDimensionName(string);
        AttributeDimension attributeDimension = (AttributeDimension)this.hierarchyDimensionChooser.getDBObject();
        hierarchy.setDimension(attributeDimension);
        DimensionLevel[] dimensionLevelArray = new DimensionLevel[this.selectedObjectListModel.getSize()];
        for (int i = 0; i < this.selectedObjectListModel.getSize(); ++i) {
            dimensionLevelArray[i] = (DimensionLevel)this.selectedObjectListModel.getElementAt(i);
        }
        List<DimensionLevel> list = Arrays.asList(dimensionLevelArray);
        Collections.reverse(list);
        hierarchy.setHierarchyLevels(null);
        int n = 0;
        for (DimensionLevel dimensionLevel : list) {
            HierarchyLevel hierarchyLevel = new HierarchyLevel((Hierarchy)this.getUpdatedObject(), dimensionLevel);
            hierarchyLevel.setHierLevelOrder(n++);
            hierarchy.addHierarchyLevel(hierarchyLevel);
        }
    }

    private JComponent createDeterminesTable() {
        this.tableModel = new DefaultTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.tableModel.setColumnIdentifiers(new String[]{HCSArb.getString("DETERMINES_PANEL_LEVEL_COLUMN"), HCSArb.getString("DETERMINES_PANEL_DETERMINES_COLUMN")});
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("HIERARCHY_DETERMINES_TITLE")));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        componentWithTitlebar.setMinimumSize(new Dimension(350, 200));
        return componentWithTitlebar;
    }

    private Shuttle createShuttlePanel() {
        this.allObjectListModel = new DefaultListModel();
        this.allObjectList = new JList(this.allObjectListModel);
        this.selectedObjectListModel = new DefaultListModel();
        this.selectedObjectList = new JList(this.selectedObjectListModel);
        this.shuttle = new Shuttle();
        this.shuttle.setName("shuttle");
        this.shuttle.setButtonsShown(15);
        ReorderableListPicker reorderableListPicker = new ReorderableListPicker(this.selectedObjectList);
        this.shuttle.setToPicker((ItemPicker)reorderableListPicker);
        ListPicker listPicker = new ListPicker(this.allObjectList){

            protected synchronized void sortItems() {
                ArrayList<DimensionLevel> arrayList = new ArrayList<DimensionLevel>();
                for (int i = 0; i < HierarchyGeneralPanel.this.allObjectListModel.size(); ++i) {
                    arrayList.add((DimensionLevel)HierarchyGeneralPanel.this.allObjectListModel.get(i));
                }
                HierarchyGeneralPanel.this.allObjectListModel.removeAllElements();
                for (DimensionLevel dimensionLevel : HierarchyGeneralPanel.this.getDefaultSortedLevelList(arrayList)) {
                    HierarchyGeneralPanel.this.allObjectListModel.addElement(dimensionLevel);
                }
            }
        };
        listPicker.setItemsSorted(true);
        this.shuttle.setFromPicker((ItemPicker)listPicker);
        String string = HCSArb.getString("HIERARCHY_AVAIL_LEVELS");
        JLabel jLabel = new JLabel(string);
        jLabel.setName("fromListLabel");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.shuttle.add((Component)jLabel, (Object)"FromHeader");
        jLabel.setLabelFor(listPicker.getList());
        string = HCSArb.getString("HIERARCHY_SELECTED_LEVELS");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setName("toListLabel");
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.shuttle.add((Component)jLabel2, (Object)"ToHeader");
        this.shuttle.setMinimumSize(new Dimension(350, 125));
        jLabel2.setLabelFor(reorderableListPicker.getList());
        this.shuttle.setEnabled(true);
        this.selectedObjectList.setEnabled(true);
        this.allObjectList.setEnabled(true);
        return this.shuttle;
    }

    protected void initialiseComponents() {
        super.initialiseComponents();
        this.registerDescriptionFields();
        ComponentFactory componentFactory = this.getComponentFactory();
        this.hierarchyDimensionChooser = new DBObjectChooser(null, (DBObjectLister)new DimensionLister(this.getProvider()), DBObjectCriteria.createCriteria((String)"ATTRIBUTE DIMENSION", (Schema)((Hierarchy)this.getUpdatedObject()).getSchema(), (String)"%"), new String[]{"ATTRIBUTE DIMENSION"});
        JLabel jLabel = new JLabel();
        this.getHelper().getResourceHelper().resLabel(jLabel, (Component)this.hierarchyDimensionChooser, HCSArb.getString("DIMENSION_LABEL"), "dimensionChooser");
        this.shuttle = this.createShuttlePanel();
        componentFactory.registerComponent((Component)this.shuttle, "hierarchyLevels");
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setName("pnlContext");
        jPanel.setLayout(new GridBagLayout());
        int n = this.layoutDescriptionFields(jPanel);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.hierarchyDimensionChooser, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.shuttle, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(1, 5, 0, 5), 0, 0));
        ++n;
        this.add(jPanel);
        this.hierarchyDimensionChooser.addChangeListener(new DBObjectChooser.ChangeListener(){

            public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                HierarchyGeneralPanel.this.dimensionSelectionChanged();
            }
        });
    }
}

