/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchy;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import oracle.hcs.HCSArb;
import oracle.hcs.db.BasePanelLibrary;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSObjectDependenciesGenerator;
import oracle.hcs.db.panels.HCSPanel;
import oracle.hcs.db.panels.HierarchyDDLPanel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.panels.HierarchyDescriptionPanel;
import oracle.hcs.hierarchy.panels.HierarchyGeneralPanel;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HierarchyPanelLibrary
extends BasePanelLibrary {
    private static final String GENERAL = HCSArb.get("GENERAL.TITLE");
    private static final String HIERARCHIES = HCSArb.get("HIERARCHIES_TITLE");
    private static final String DESCRIPTION = HCSArb.get("DESCRIPTIONS.TITLE");

    public HierarchyPanelLibrary() {
        super("HIERARCHY");
        this.addPanel(GENERAL, HierarchyGeneralPanel.class, "av_create_hier_general", new String[0]);
        Navigable navigable = this.addPanel(DESCRIPTION, HierarchyDescriptionPanel.class, "av_create_hier_descriptions", new String[0]);
    }

    @Override
    protected Class<? extends Traversable> getDDLPanel() {
        return HierarchyDDLPanel.class;
    }

    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(DESCRIPTION);
        return arrayList;
    }

    protected List<String> getSimpleTitles() {
        return null;
    }

    public String getCreateTitle() {
        return HCSArb.get("HIERARCHY_CREATE_TITLE");
    }

    public String getEditTitle() {
        return HCSArb.get("HIERARCHY_EDIT_TITLE");
    }

    public boolean canEditObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return true;
    }

    public Class<? extends Traversable> getHeader() {
        return HCSPanel.class;
    }

    public Dimension getSize(boolean bl) {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    public Navigable getDDLNavigable() {
        Navigable navigable = super.getDDLNavigable();
        navigable.setHelpID("av_create_hier_ddl");
        return navigable;
    }

    @Override
    protected HCSSyntaxType getObjectType() {
        return HCSSyntaxType.HIERARCHY;
    }

    @Override
    protected void addMetadataChanges(SystemObject systemObject, Difference difference, List<MetadataChange> list) {
        this.addMetadataChanges(systemObject, "hierarchyLevels", difference, list, HCSSyntaxType.LEVEL);
    }

    @Override
    protected void addParentObjectChanges(SystemObject systemObject, SystemObject systemObject2, List<MetadataChange> list) {
        super.addParentObjectChanges(systemObject, systemObject2, list);
        Hierarchy hierarchy = (Hierarchy)systemObject;
        Hierarchy hierarchy2 = (Hierarchy)systemObject2;
        if (!hierarchy.getDimensionName().equals(hierarchy2.getDimensionName())) {
            list.add(new MetadataChange(systemObject2.getName(), systemObject2.getName(), this.getObjectType()));
            list.add(new MetadataChange(hierarchy.getDimensionName(), hierarchy.getDimensionName(), HCSSyntaxType.DIMENSION));
        }
    }

    @Override
    protected boolean containsChanges(List<MetadataChange> list, HCSSyntaxType hCSSyntaxType) {
        boolean bl = false;
        for (MetadataChange metadataChange : list) {
            if (!metadataChange.getObjectType().equals((Object)hCSSyntaxType) || hCSSyntaxType.equals((Object)HCSSyntaxType.LEVEL)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    protected List<AbstractSchemaObjectWithDesc> getDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        return HCSObjectDependenciesGenerator.getHierarchyDependencies(string, oracleDatabaseImpl, string2);
    }
}

