/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchy;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import oracle.hcs.db.model.AbstractAVDBObjectBuilder;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyAttribute;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HierarchyBuilder
extends AbstractAVDBObjectBuilder<Hierarchy> {
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CAPTION = "CAPTION";

    public HierarchyBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "HIERARCHY");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public Hierarchy createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Hierarchy hierarchy = new Hierarchy();
        hierarchy.setName(string);
        hierarchy.setSchema(schema);
        hierarchy.setID(dBObjectID);
        return hierarchy;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"caption", "dimensionType", "levels", "hierarchies", "attributes", "hierarchyDefault", "sharing"})
    public void buildDetails(Hierarchy hierarchy) throws DBException, SQLException, IOException, JAXBException {
        Database database = (Database)this.getProvider();
        hierarchy.removeAllHierarchyLevels();
        this.build(hierarchy);
    }

    public void build(final Hierarchy hierarchy) throws DBException, SQLException {
        Database database = (Database)this.getProvider();
        hierarchy.setForceCreate(true);
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select dimension_owner, dimension_name from all_hierarchies  where hier_name = ? and owner = ?", new Object[]{hierarchy.getName(), hierarchy.getSchema()});
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select level_name from all_hier_levels  where hier_name = ? and owner = ? order by order_num desc", new Object[]{hierarchy.getName(), hierarchy.getSchema()});
        final QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select classification, value, language from all_hier_class  where hier_name = ? and owner = ? order by language,classification", new Object[]{hierarchy.getName(), hierarchy.getSchema()});
        final QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select classifications.hier_attr_name, to_char(attributes.expression), attributes.order_num from all_hier_hier_attr_class  classifications join  all_hier_hier_attributes attributes on classifications.owner = attributes.owner and classifications.hier_name = attributes.hier_name and  classifications.hier_attr_name = attributes.hier_attr_name where classifications.hier_name = ? and classifications.owner = ?group by classifications.hier_attr_name, to_char(attributes.expression), attributes.order_num", new Object[]{hierarchy.getName(), hierarchy.getSchema()});
        final QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select hier_attr_name, classification, value, language from all_hier_hier_attr_class  where hier_name = ? and owner = ? order by language,classification", new Object[]{hierarchy.getName(), hierarchy.getSchema()});
        final QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), " select sharing from all_objects  where object_type = ? and object_name = ? and owner = ?", new Object[]{hierarchy.getType(), hierarchy.getName(), hierarchy.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        hierarchy.setDimensionName(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)hierarchy, sQLException);
                }
            }
        });
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    int n = 0;
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        DimensionLevel dimensionLevel = new DimensionLevel(null, string);
                        HierarchyLevel hierarchyLevel = new HierarchyLevel(hierarchy, dimensionLevel);
                        hierarchyLevel.setHierLevelOrder(n++);
                        hierarchy.addHierarchyLevel(hierarchyLevel);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)hierarchy, sQLException);
                }
            }
        });
        queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    HierarchyBuilder.this.processClassificationsResultSet(hierarchy, hierarchy, resultSet);
                }
                catch (SQLException sQLException) {
                    queryWrapper3.throwDBException((DBObject)hierarchy, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        HierarchyAttribute hierarchyAttribute = hierarchy.findHierAttribute(string);
                        if (hierarchyAttribute != null) continue;
                        hierarchyAttribute = new HierarchyAttribute();
                        hierarchyAttribute.setName(string);
                        hierarchyAttribute.setExpression(string2);
                        hierarchyAttribute.setOrder(string3);
                        hierarchy.addHierAttribute(hierarchyAttribute);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper4.throwDBException((DBObject)hierarchy, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    AbstractAVDBObjectBuilder.LanguageDescriptionsCount languageDescriptionsCount = new AbstractAVDBObjectBuilder.LanguageDescriptionsCount();
                    languageDescriptionsCount.setDescriptionsCount(0);
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        string3 = string3 != null ? string3.trim() : "";
                        String string4 = resultSet.getString(4);
                        HierarchyAttribute hierarchyAttribute = hierarchy.findHierAttribute(string);
                        if (hierarchyAttribute == null) continue;
                        if (string2.equalsIgnoreCase(HierarchyBuilder.CAPTION) || string2.equalsIgnoreCase(HierarchyBuilder.DESCRIPTION) || string4 != null) {
                            HierarchyBuilder.this.processLanguageDescriptions(languageDescriptionsCount, string4, string2, string3, hierarchyAttribute, hierarchyAttribute);
                            continue;
                        }
                        HierarchyBuilder.this.setClassification(hierarchyAttribute, string2, string3, string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper5.throwDBException((DBObject)hierarchy, sQLException);
                }
            }
        });
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        hierarchy.setSharing(HierarchyBuilder.this.getSharing(string));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper6.throwDBException((DBObject)hierarchy, sQLException);
                }
            }
        });
    }

    public static String getRootDataType(String string) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL")) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isLetter(c) && !Character.isSpaceChar(c)) continue;
                stringBuffer.append(c);
            }
        } else {
            stringBuffer = new StringBuffer(string);
        }
        return stringBuffer.toString();
    }
}

