/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.panels.GeneralBaseSourceEditorPanel;
import oracle.hcs.db.panels.HCSLanguageExpressionBuilder;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Table;
import oracle.hcs.dimension.DimensionRemoveChildDispatcher;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.model.JoinPath;
import oracle.hcs.dimension.panels.AttributeDimensionInitializer;
import oracle.hcs.dimension.panels.LevelGenerator;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.preferences.HCSPreferenceSettings;
import oracle.hcs.syntaxbuilder.SyntaxBuilderLauncher;
import oracle.hcs.syntaxbuilder.editor.SnippetValidator;
import oracle.hcs.util.FeatureMap;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.config.Preferences;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;

public class DimensionGeneralPanel
extends GeneralBaseSourceEditorPanel<AttributeDimension> {
    private JTable allMemberPropertiesTable;
    private DefaultTableModel allMemberPropertiesTableModel;
    private JLabel dimensionClassTypeLabel;
    private JComboBox dimensionClassTypeComboBox;
    private DefaultComboBoxModel dimensionClassTypeModel;
    private JLabel dimensionSortAttributeLabel;
    private JComboBox dimensionSortAttributeComboBox;
    private DefaultComboBoxModel dimensionSortAttributeModel;
    private JRadioButton ascendingRadioButton;
    private JRadioButton descendingRadioButton;
    private JCheckBox nullsFirstCheckBox;
    private ButtonGroup sortRadioButtonGroup;
    private ActionListener sortAttributeComboBoxActionListener;
    private boolean initializedListener;
    private static final Object OBJ_LOCK = new Object();
    private JCheckBox generateLevelsCheckBox;
    private final String DEFAULT_ALL_MEMBER_NAME = HCSArb.getString("DIMENSION_DEFAULT_ALL_MEMBER_NAME");
    HCSLanguageExpressionBuilder languageExpressionBuilder;
    private boolean firstTime = true;
    private static final int DIM_MEMBER_PROPERTY_COL = 0;
    private static final int DIM_MEMBER_PROPERTY_VALUE_COL = 1;
    private static final int ALL_MEMBER_NAME_ROW = 0;
    private static final int ALL_MEMBER_CAPTION_ROW = 1;
    private static final int ALL_MEMBER_DESCRIPTION_ROW = 2;
    private static final Logger LOG = Logger.getLogger(DimensionGeneralPanel.class.getName());
    private HCSPreferenceSettings preferences = HCSPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private DimensionLevel[] cachedLevels;
    private String CASE = "case";
    private String END = "end";

    public DimensionGeneralPanel() {
        this.initializeDimensionClassTypeComponents();
        this.layoutComponents();
        this.setDbObjectInitializer(new AttributeDimensionInitializer());
    }

    public void initializeDimensionClassTypeComponents() {
        this.dimensionClassTypeLabel = new JLabel(HCSArb.getString("DIMENSION_CLASS_TYPE_LABEL"));
        this.dimensionClassTypeLabel.setName("dimensionClassTypeLabel");
        this.dimensionClassTypeModel = new DefaultComboBoxModel();
        this.dimensionClassTypeModel.addElement(HCSArb.getString("DIMENSION_CLASS_TYPE_NONE"));
        this.dimensionClassTypeModel.addElement(HCSArb.getString("DIMENSION_CLASS_TYPE_MEASURE"));
        this.dimensionClassTypeComboBox = new JComboBox(this.dimensionClassTypeModel);
        this.dimensionClassTypeComboBox.setName("dimensionClassTypeComboBox");
        this.dimensionClassTypeComboBox.setSelectedIndex(0);
        this.dimensionSortAttributeLabel = new JLabel(HCSArb.getString("DIMENSION_SORT_ATTRIBUTE_LABEL"));
        this.dimensionSortAttributeLabel.setName("dimensionSortAttributeLabel");
        this.dimensionSortAttributeModel = new DefaultComboBoxModel();
        this.dimensionSortAttributeModel.addElement(HCSArb.getString("DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"));
        this.dimensionSortAttributeComboBox = new JComboBox(this.dimensionSortAttributeModel);
        this.dimensionSortAttributeComboBox.setSelectedIndex(0);
        this.ascendingRadioButton = new JRadioButton(HCSArb.getString("DIMENSION_SORT_ASCENDING_OPTION"));
        this.descendingRadioButton = new JRadioButton(HCSArb.getString("DIMENSION_SORT_DESCENDING_OPTION"));
        this.nullsFirstCheckBox = new JCheckBox(HCSArb.getString("DIMENSION_SORT_NULLS_FIRST_OPTION"));
        this.nullsFirstCheckBox.setSelected(true);
        this.sortRadioButtonGroup = new ButtonGroup();
        this.sortRadioButtonGroup.add(this.ascendingRadioButton);
        this.sortRadioButtonGroup.add(this.descendingRadioButton);
        this.ascendingRadioButton.setSelected(true);
        this.enableSortAttributeControls(false);
        this.sortAttributeComboBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionGeneralPanel.this.enableSortOrderUIProperties();
            }
        };
        this.dimensionSortAttributeComboBox.addActionListener(this.sortAttributeComboBoxActionListener);
    }

    private void setupDimensionTypeChangeHandler() {
        ((AttributeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void objectUpdated(DBObjectChange dBObjectChange) {
                Object object = OBJ_LOCK;
                synchronized (object) {
                    for (String string : dBObjectChange.getAllChangedProperties()) {
                        if (!string.equals("dimensionType")) continue;
                        String string2 = ((AttributeDimension)DimensionGeneralPanel.this.getUpdatedObject()).getDimensionType();
                        if (string2 != null && string2.equalsIgnoreCase(HCSArb.getString("DIMENSION_NAME_FOR_TIME"))) {
                            if (DimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf("END_DATE") == -1) {
                                DimensionGeneralPanel.this.dimensionSortAttributeModel.addElement("END_DATE");
                            }
                            if (DimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf("TIME_SPAN") != -1) continue;
                            DimensionGeneralPanel.this.dimensionSortAttributeModel.addElement("TIME_SPAN");
                            continue;
                        }
                        if (DimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf("END_DATE") >= 0) {
                            if (DimensionGeneralPanel.this.dimensionSortAttributeComboBox.getSelectedItem().equals("END_DATE")) {
                                DimensionGeneralPanel.this.dimensionSortAttributeComboBox.setSelectedIndex(0);
                            }
                            DimensionGeneralPanel.this.dimensionSortAttributeModel.removeElement("END_DATE");
                        }
                        if (DimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf("TIME_SPAN") < 0) continue;
                        if (DimensionGeneralPanel.this.dimensionSortAttributeComboBox.getSelectedItem().equals("TIME_SPAN")) {
                            DimensionGeneralPanel.this.dimensionSortAttributeComboBox.setSelectedIndex(0);
                        }
                        DimensionGeneralPanel.this.dimensionSortAttributeModel.removeElement("TIME_SPAN");
                    }
                }
            }
        });
    }

    @Override
    protected void initialisePanel() {
        String string;
        DimensionLevel[] dimensionLevelArray;
        String string2 = Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)this.getProvider()));
        if (FeatureMap.getInstance().isSupported(string2, "SNOWFLAKE")) {
            this.enableMultipleSourceSupport();
        }
        super.initialisePanel();
        if (!this.initializedListener) {
            this.setupDimensionTypeChangeHandler();
            this.initializedListener = true;
            this.initMemberLanguageEditor();
            dimensionLevelArray = ((AttributeDimension)this.getUpdatedObject()).getLevels();
            this.cachedLevels = new DimensionLevel[dimensionLevelArray.length];
            for (int i = 0; i < this.cachedLevels.length; ++i) {
                this.cachedLevels[i] = new DimensionLevel(dimensionLevelArray[i].getDimension(), dimensionLevelArray[i].getName());
                this.cachedLevels[i].setLevelType(dimensionLevelArray[i].getLevelType());
            }
            ((AttributeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        DimensionLevel dimensionLevel;
                        int n;
                        int n2;
                        if (!string.equals("dimensionType")) continue;
                        DimensionLevel[] dimensionLevelArray = ((AttributeDimension)DimensionGeneralPanel.this.getUpdatedObject()).getLevels();
                        if (((AttributeDimension)DimensionGeneralPanel.this.getUpdatedObject()).isTime()) {
                            if (DimensionGeneralPanel.this.cachedLevels == null || DimensionGeneralPanel.this.cachedLevels.length != dimensionLevelArray.length) continue;
                            boolean bl = true;
                            for (n2 = 0; n2 < DimensionGeneralPanel.this.cachedLevels.length; ++n2) {
                                if (DimensionGeneralPanel.this.cachedLevels[n2].getName().equals(dimensionLevelArray[n2].getName())) continue;
                                bl = false;
                                break;
                            }
                            if (!bl) continue;
                            for (n2 = 0; n2 < DimensionGeneralPanel.this.cachedLevels.length; ++n2) {
                                dimensionLevelArray[n2].setLevelType(DimensionGeneralPanel.this.cachedLevels[n2].getLevelType());
                            }
                            continue;
                        }
                        DimensionGeneralPanel.this.cachedLevels = new DimensionLevel[dimensionLevelArray.length];
                        for (int i = 0; i < DimensionGeneralPanel.this.cachedLevels.length; ++i) {
                            DimensionGeneralPanel.this.cachedLevels[i] = new DimensionLevel(dimensionLevelArray[i].getDimension(), dimensionLevelArray[i].getName());
                            DimensionGeneralPanel.this.cachedLevels[i].setLevelType(dimensionLevelArray[i].getLevelType());
                        }
                        if (DimensionGeneralPanel.this.isEditing()) {
                            DimensionLevel[] dimensionLevelArray2 = dimensionLevelArray;
                            n2 = dimensionLevelArray2.length;
                            for (n = 0; n < n2; ++n) {
                                dimensionLevel = dimensionLevelArray2[n];
                                DimensionLevel dimensionLevel2 = ((AttributeDimension)DimensionGeneralPanel.this.getOriginalObject()).findLevel(dimensionLevel.getName());
                                if (((AttributeDimension)DimensionGeneralPanel.this.getOriginalObject()).isTime()) {
                                    dimensionLevel.setLevelType(null);
                                    continue;
                                }
                                if (dimensionLevel2 != null) {
                                    dimensionLevel.setLevelType(dimensionLevel2.getLevelType());
                                    continue;
                                }
                                dimensionLevel.setLevelType(null);
                            }
                            continue;
                        }
                        DimensionLevel[] dimensionLevelArray3 = dimensionLevelArray;
                        n2 = dimensionLevelArray3.length;
                        for (n = 0; n < n2; ++n) {
                            dimensionLevel = dimensionLevelArray3[n];
                            dimensionLevel.setLevelType(null);
                        }
                    }
                }
            });
        }
        if ((string = (dimensionLevelArray = (DimensionLevel[])this.getUpdatedObject()).getDimensionClassType()) == null) {
            string = "NONE";
        }
        if (string.equalsIgnoreCase("MEASURE")) {
            this.dimensionClassTypeComboBox.setSelectedItem(HCSArb.getString("DIMENSION_CLASS_TYPE_MEASURE"));
        } else {
            this.dimensionClassTypeComboBox.setSelectedItem(HCSArb.getString("DIMENSION_CLASS_TYPE_NONE"));
        }
        TableColumn tableColumn = this.allMemberPropertiesTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DimMemberPropertiesCellEditor());
        String string3 = dimensionLevelArray.getAllMemberName() == null ? String.format("'%s'", this.DEFAULT_ALL_MEMBER_NAME) : dimensionLevelArray.getAllMemberName();
        String string4 = dimensionLevelArray.getAllMemberCaption() == null && !this.isEditing() ? String.format("'%s'", this.DEFAULT_ALL_MEMBER_NAME) : dimensionLevelArray.getAllMemberCaption();
        String string5 = dimensionLevelArray.getAllMemberDescription() == null && !this.isEditing() ? String.format("'%s'", this.DEFAULT_ALL_MEMBER_NAME) : dimensionLevelArray.getAllMemberDescription();
        this.allMemberPropertiesTableModel.setRowCount(0);
        this.allMemberPropertiesTableModel.addRow(new String[]{HCSArb.get("DIMENSION_ALL_MEMBER_NAME_LABEL"), string3});
        this.allMemberPropertiesTableModel.addRow(new String[]{HCSArb.get("DIMENSION_ALL_MEMBER_CAPTION_LABEL"), string4});
        this.allMemberPropertiesTableModel.addRow(new String[]{HCSArb.get("DIMENSION_ALL_MEMBER_DESCRIPTION_LABEL"), string5});
        dimensionLevelArray.addObjectListener(new DBObjectListener(){

            public void objectUpdated(DBObjectChange dBObjectChange) {
                AttributeDimension attributeDimension = (AttributeDimension)DimensionGeneralPanel.this.getUpdatedObject();
                List list = dBObjectChange.getOwnedObjectsRemoved();
                if (list != null && list.size() > 0) {
                    AttributeDimension attributeDimension2 = attributeDimension;
                    for (DBObject dBObject : list) {
                        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
                        if (dBObject instanceof DimensionAttribute) {
                            abstractChildObjectWithDesc = (DimensionAttribute)dBObject;
                            attributeDimension2.removeAttributeCascade((DimensionAttribute)abstractChildObjectWithDesc);
                            continue;
                        }
                        if (!(dBObject instanceof DimensionLevel)) continue;
                        abstractChildObjectWithDesc = (DimensionLevel)dBObject;
                        String string = abstractChildObjectWithDesc.getName();
                        attributeDimension2.removeLevelCascade(string);
                    }
                    DimensionGeneralPanel.this.disableDescriptionFieldsWhenNoChildrenLeft(attributeDimension2);
                }
            }
        });
    }

    @Override
    protected DatabaseSource[] getDBObjectSources() {
        DatabaseSource[] databaseSourceArray = ((AttributeDimension)this.getUpdatedObject()).getSources();
        return databaseSourceArray;
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        if (this.allMemberPropertiesTable.isEditing()) {
            this.allMemberPropertiesTable.getCellEditor().stopCellEditing();
        }
        String string = (String)this.allMemberPropertiesTableModel.getValueAt(0, 1);
        attributeDimension.setAllMemberName(string);
        String string2 = (String)this.allMemberPropertiesTableModel.getValueAt(1, 1);
        if (string2 != null && string2.isEmpty()) {
            string2 = null;
        }
        attributeDimension.setAllMemberCaption(string2);
        String string3 = (String)this.allMemberPropertiesTableModel.getValueAt(2, 1);
        if (string3 != null && string3.isEmpty()) {
            string3 = null;
        }
        attributeDimension.setAllMemberDescription(string3);
        DatabaseSource[] databaseSourceArray = attributeDimension.getSources();
        List<DatabaseSource> list = Arrays.asList(databaseSourceArray);
        List<DatabaseSource> list2 = this.getSources();
        String string4 = this.getSourceTextFieldText();
        if (list2.size() == 0 && string4 != null && !string4.isEmpty() && ((AttributeDimension)this.getUpdatedObject()).isForceCreate()) {
            this.createNonExistingTableSource(string4);
            list2 = this.getSources();
        }
        if (!(list2.size() == list.size() && list2.containsAll(list) || list2.size() != 1)) {
            ((AttributeDimension)this.getUpdatedObject()).setLevels(new DimensionLevel[0]);
        }
        if (this.firstTime && !this.isEditing() || (list2.size() != list.size() || !list2.containsAll(list)) && list2.size() == 1) {
            if (list2.size() == 1) {
                this.generateAttributes();
            } else {
                this.updateAliases(list2);
                this.updateSources();
            }
            if (this.getOriginalObject() == null && this.generateLevelsCheckBox.isVisible() && this.generateLevelsCheckBox.isSelected() && list2.size() == 1) {
                LevelGenerator levelGenerator = new LevelGenerator(this.getProvider(), (AttributeDimension)this.getUpdatedObject());
                levelGenerator.generate();
            }
            this.firstTime = false;
        } else {
            if (list2.size() != list.size() || !list2.containsAll(list)) {
                int n = list.size();
                int n2 = list2.size();
                if (n2 > n) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (DatabaseSource object : list) {
                        hashSet.add(object.getName());
                    }
                    ArrayList arrayList = new ArrayList();
                    for (DatabaseSource databaseSource : list2) {
                        if (hashSet.contains(databaseSource.getName())) continue;
                        arrayList.add(databaseSource);
                    }
                    this.updateAliases(arrayList);
                } else if (n > n2) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (DatabaseSource databaseSource : list2) {
                        hashSet.add(databaseSource.getName());
                    }
                    ArrayList arrayList3 = new ArrayList();
                    for (DatabaseSource databaseSource : list) {
                        if (hashSet.contains(databaseSource.getName())) continue;
                        arrayList3.add(databaseSource);
                    }
                    ArrayList<JoinPath> arrayList = new ArrayList<JoinPath>();
                    for (JoinPath joinPath : attributeDimension.getJoinPaths()) {
                        Iterator iterator = arrayList3.iterator();
                        while (iterator.hasNext()) {
                            DatabaseSource databaseSource = (DatabaseSource)iterator.next();
                            for (Column column : databaseSource.getColumns()) {
                                if (!joinPath.getCondition().contains(databaseSource.getAlias() + "." + column.getName())) continue;
                                arrayList.add(joinPath);
                            }
                        }
                    }
                    for (JoinPath joinPath : arrayList) {
                        attributeDimension.removeJoinPath(joinPath);
                    }
                    HashMap<CallSite, DimensionAttribute> hashMap = new HashMap<CallSite, DimensionAttribute>();
                    for (DimensionAttribute dimensionAttribute : attributeDimension.getAttributes()) {
                        hashMap.put((CallSite)((Object)(dimensionAttribute.getAlias() + "." + dimensionAttribute.getMapExpression())), dimensionAttribute);
                    }
                    ArrayList arrayList2 = new ArrayList();
                    Object object = arrayList3.iterator();
                    while (object.hasNext()) {
                        DatabaseSource databaseSource = (DatabaseSource)object.next();
                        for (Column column : databaseSource.getColumns()) {
                            if (!hashMap.containsKey(databaseSource.getAlias() + "." + column.getName())) continue;
                            arrayList2.add((DimensionAttribute)hashMap.get(databaseSource.getAlias() + "." + column.getName()));
                        }
                    }
                    object = new ArrayList();
                    DimensionLevel[] dimensionLevelArray = arrayList2.iterator();
                    while (dimensionLevelArray.hasNext()) {
                        DimensionAttribute dimensionAttribute = (DimensionAttribute)dimensionLevelArray.next();
                        attributeDimension.removeAttribute(dimensionAttribute);
                        object.add(dimensionAttribute.getName());
                    }
                    for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
                        if (!object.contains(dimensionLevel.getLevelKey())) continue;
                        attributeDimension.removeLevel(dimensionLevel);
                    }
                }
            }
            this.updateSources();
        }
    }

    private void createNonExistingTableSource(String string) {
        String[] stringArray = string.split(",");
        ArrayList<DatabaseSource> arrayList = new ArrayList<DatabaseSource>();
        for (String string2 : stringArray) {
            Table table = new Table(((AttributeDimension)this.getUpdatedObject()).getSchema().getName(), string2, null);
            ArrayList<Column> arrayList2 = new ArrayList<Column>();
            Column column = new Column("COLUMN1", "Y", "");
            arrayList2.add(column);
            table.setColumns(arrayList2.toArray(new Column[arrayList2.size()]));
            arrayList.add(table);
        }
        ((AttributeDimension)this.getUpdatedObject()).setSources(arrayList.toArray(new DatabaseSource[arrayList.size()]));
        this.setSources(arrayList);
        ((AttributeDimension)this.getUpdatedObject()).removeAllAttributes();
        this.generateAttributes();
    }

    private boolean isQuoted(String string) {
        return string.indexOf("\"") >= 0;
    }

    private void generateAttributes() {
        Object object;
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        boolean bl = true;
        DatabaseSource[] databaseSourceArray = attributeDimension.getSources();
        List<DatabaseSource> list = Arrays.asList(databaseSourceArray);
        List<DatabaseSource> list2 = this.getSources();
        if (databaseSourceArray != null) {
            if (list2.size() != list.size()) {
                bl = true;
            }
            if (list2.size() == list.size() && list2.containsAll(list)) {
                bl = false;
            }
        }
        if (this.getSources() != null) {
            if (bl) {
                object = new DatabaseSource[this.getSources().size()];
                attributeDimension.setSources((DatabaseSource[])this.getSources().toArray((T[])object));
            }
            if (bl || attributeDimension.getAttributes().length == 0) {
                attributeDimension.removeAllAttributes();
                for (DatabaseSource databaseSource : list2) {
                    for (Column column : databaseSource.getColumns()) {
                        String string;
                        DimensionAttribute dimensionAttribute;
                        if (!this.isColumnValidDataType(column.getDataType().trim()) || (dimensionAttribute = attributeDimension.findAttribute(string = column.getName())) != null) continue;
                        dimensionAttribute = new DimensionAttribute();
                        dimensionAttribute.setName(string);
                        dimensionAttribute.setCaption(string);
                        dimensionAttribute.setDescription(string);
                        dimensionAttribute.setMapExpression(string);
                        attributeDimension.addAttribute(dimensionAttribute);
                    }
                }
            }
        }
        object = this.getSourceColumns(list2);
        attributeDimension.setSourceColumns((List<ColumnIdentifier>)object);
    }

    private void generateAttributes(List<DatabaseSource> list) {
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        for (DatabaseSource databaseSource : list) {
            for (Column column : databaseSource.getColumns()) {
                String string;
                DimensionAttribute dimensionAttribute;
                if (!this.isColumnValidDataType(column.getDataType().trim()) || (dimensionAttribute = attributeDimension.findAttribute(string = column.getName(), databaseSource.getAlias())) != null) continue;
                dimensionAttribute = new DimensionAttribute();
                Object object = string;
                if (databaseSource.getAlias() != null && !databaseSource.getAlias().isEmpty()) {
                    object = string + "_" + databaseSource.getAlias();
                }
                dimensionAttribute.setName((String)object);
                dimensionAttribute.setCaption((String)object);
                dimensionAttribute.setDescription((String)object);
                dimensionAttribute.setMapExpression(string);
                dimensionAttribute.setAlias(databaseSource.getAlias());
                attributeDimension.addAttribute(dimensionAttribute);
            }
        }
    }

    private void updateSources() {
        DatabaseSource[] databaseSourceArray;
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        boolean bl = true;
        DatabaseSource[] databaseSourceArray2 = attributeDimension.getSources();
        List<DatabaseSource> list = Arrays.asList(databaseSourceArray2);
        List<DatabaseSource> list2 = this.getSources();
        if (databaseSourceArray2 != null) {
            if (list2.size() != list.size()) {
                bl = true;
            }
            if (list2.size() == list.size() && list2.containsAll(list)) {
                bl = false;
            }
        }
        if (list2 != null && bl) {
            databaseSourceArray = new DatabaseSource[list2.size()];
            attributeDimension.setSources(list2.toArray(databaseSourceArray));
        }
        databaseSourceArray = this.getSourceColumns(list2);
        attributeDimension.setSourceColumns((List<ColumnIdentifier>)databaseSourceArray);
    }

    private void updateAliases(List<DatabaseSource> list) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<DatabaseSource> hashSet2 = new HashSet<DatabaseSource>();
        block0: for (DatabaseSource object : this.getSources()) {
            Object object2 = new HashSet();
            for (DatabaseSource databaseSource : this.getSources()) {
                if (databaseSource.getQualifiedName().equals(object.getQualifiedName())) continue;
                for (Column column : databaseSource.getColumns()) {
                    ((HashSet)object2).add(column.getName());
                }
            }
            for (Column column : object.getColumns()) {
                if (!((HashSet)object2).contains(column.getName())) continue;
                hashSet.add(object.getQualifiedName());
                continue block0;
            }
        }
        for (DatabaseSource databaseSource : this.getSources()) {
            if (!hashSet.contains(databaseSource.getQualifiedName()) || databaseSource.getAlias() != null && !databaseSource.getAlias().isEmpty()) continue;
            databaseSource.setAlias(this.generateAlias(databaseSource));
        }
        for (DatabaseSource databaseSource : list) {
            if (!hashSet.contains(databaseSource.getQualifiedName())) continue;
            hashSet.remove(databaseSource.getQualifiedName());
        }
        for (DatabaseSource databaseSource : this.getSources()) {
            if (!hashSet.contains(databaseSource.getQualifiedName())) continue;
            hashSet2.add(databaseSource);
        }
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        for (Object object2 : hashSet2) {
            for (Column column : object2.getColumns()) {
                String string;
                DimensionAttribute dimensionAttribute;
                if (!this.isColumnValidDataType(column.getDataType().trim()) || (dimensionAttribute = attributeDimension.findAttribute(string = column.getName(), null)) == null) continue;
                dimensionAttribute.setAlias(object2.getAlias());
            }
        }
        this.generateAttributes(list);
    }

    /*
     * WARNING - void declaration
     */
    private String generateAlias(DatabaseSource databaseSource) {
        void var4_6;
        HashSet<String> hashSet = new HashSet<String>();
        for (DatabaseSource object2 : this.getSources()) {
            if (object2.getAlias() == null) continue;
            hashSet.add(object2.getAlias());
        }
        String string = databaseSource.getName().replaceAll("[^A-Za-z]+", "");
        Object var4_5 = null;
        for (int i = 2; i <= string.length(); ++i) {
            String string2 = string.substring(0, i);
            if (hashSet.contains(string2)) continue;
            return string2;
        }
        return var4_6;
    }

    private void disableDescriptionFieldsWhenNoChildrenLeft(AttributeDimension attributeDimension) {
        DimensionAttribute[] dimensionAttributeArray = attributeDimension.getAttributes();
        DimensionLevel[] dimensionLevelArray = attributeDimension.getLevels();
        if (dimensionAttributeArray.length == 0 || dimensionLevelArray.length == 0) {
            DimensionRemoveChildDispatcher dimensionRemoveChildDispatcher = DimensionRemoveChildDispatcher.getInstance();
            dimensionRemoveChildDispatcher.setSchemaObject(attributeDimension);
            dimensionRemoveChildDispatcher.notifyObservers();
        }
    }

    private void enableSortOrderUIProperties() {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        if (this.dimensionSortAttributeComboBox.getItemCount() > 0) {
            String string = (String)this.dimensionSortAttributeComboBox.getSelectedItem();
            if (string.equalsIgnoreCase(HCSArb.getString("DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"))) {
                this.ascendingRadioButton.setSelected(true);
                this.nullsFirstCheckBox.setSelected(true);
                this.enableSortAttributeControls(false);
            } else {
                String string2 = oracleDatabaseImpl.getInternalName(string);
                DimensionAttribute dimensionAttribute = attributeDimension.findAttribute(string2);
                if (dimensionAttribute != null) {
                    this.enableSortAttributeControls(true);
                }
            }
        }
    }

    private void enableSortAttributeControls(boolean bl) {
        this.ascendingRadioButton.setEnabled(bl);
        this.descendingRadioButton.setEnabled(bl);
        this.nullsFirstCheckBox.setEnabled(bl);
    }

    private void initMemberLanguageEditor() {
        Properties properties = new Properties();
        properties.put("DIMENSION", ((AttributeDimension)this.getUpdatedObject()).getName());
        properties.setProperty("VISIBLE_DOCS", Boolean.toString(false));
        properties.setProperty("VISIBLE_SYNTAXDETAIL", Boolean.toString(false));
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        String string = attributeDimension.getSchema().getName();
        HCSSchema hCSSchema = null;
        String string2 = Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)this.getProvider()));
        try {
            if (!this.isEditing()) {
                hCSSchema = HCSMetadataCache.getSchemaCopy(string2, string);
                hCSSchema.addDimension(attributeDimension);
            } else {
                hCSSchema = HCSMetadataCache.getUpdatedSchema(string2, string);
            }
            this.languageExpressionBuilder = new HCSLanguageExpressionBuilder((OracleDatabaseImpl)this.getProvider(), "/oracle/hcs/dimension/panels/DimensionAllMemberLanguageSnippet.xml", hCSSchema, properties);
            this.languageExpressionBuilder.setLanguageSnippetValidator(new SnippetValidator(){

                @Override
                public boolean isValid(String string) {
                    OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)DimensionGeneralPanel.this.getProvider();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)oracleDatabaseImpl.getConnection());
                    String string2 = dBUtil.executeReturnOneCol(String.format("select %s from dual", string));
                    return string2 != null;
                }

                @Override
                public String getInvalidSyntaxMessage() {
                    return HCSArb.getString("SNIPPET_ALL_MEMBER_NAME_INVALID_SYNTAX");
                }
            });
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.getSourceTextField(), "sources");
        this.registerDescriptionFields();
        this.dimensionClassTypeModel.addElement(HCSArb.getString("DIMENSION_CLASS_TYPE_NONE"));
        this.dimensionClassTypeModel.addElement(HCSArb.getString("DIMENSION_CLASS_TYPE_MEASURE"));
        this.dimensionClassTypeComboBox = new JComboBox(this.dimensionClassTypeModel);
        this.dimensionClassTypeComboBox.setName("dimensionClassTypeComboBox");
        this.dimensionClassTypeComboBox.setSelectedIndex(0);
        this.initDimAllMemberPropertiesTable();
        componentFactory.registerComponent((Component)this.allMemberPropertiesTable, "allMemberName");
        this.generateLevelsCheckBox = new JCheckBox(HCSArb.get("DIMENSION_AUTO_GENERATE_LEVELS_LABEL"));
        this.generateLevelsCheckBox.setSelected(true);
        this.generateLevelsCheckBox.setVisible(this.preferences.getAutoGenerateLevels());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setName("pnlContext");
        jPanel.setLayout(new GridBagLayout());
        int n = this.layoutDescriptionFields(jPanel);
        n = this.layoutSource(jPanel, n) + 1;
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setMinimumSize(new Dimension(100, 150));
        componentWithTitlebar.setComponent((JComponent)new JScrollPane(this.allMemberPropertiesTable));
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("DIMENSION_ALL_MEMBER_PROPERTIES_LABEL")));
        jPanel.add((Component)componentWithTitlebar, new GridBagConstraints(0, n, 3, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.generateLevelsCheckBox, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("pnlDetails");
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("pnlCenter");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }

    private void initDimAllMemberPropertiesTable() {
        this.allMemberPropertiesTableModel = new DefaultTableModel();
        this.allMemberPropertiesTableModel.setColumnIdentifiers(new String[]{HCSArb.getString("DIMENSION_LEVEL_KEY_TYPE_COLUMN_LABEL"), HCSArb.getString("DIMENSION_LEVEL_KEY_LABEL")});
        this.allMemberPropertiesTable = new JTable(this.allMemberPropertiesTableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                TableColumnModel tableColumnModel = this.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                int n3 = tableColumn.getModelIndex();
                return n3 != 0;
            }
        };
    }

    @Override
    protected void afterSourceChanged() {
    }

    private class DimMemberPropertiesCellEditor
    extends DefaultCellEditor {
        protected int column;
        protected JTable table;

        public DimMemberPropertiesCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, final int n, int n2) {
            this.table = jTable;
            this.column = n2;
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            int n3 = tableColumn.getModelIndex();
            if (n3 == 1) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                final JTextField jTextField = (JTextField)this.getComponent();
                jTextField.setText((String)object);
                jPanel.add((Component)jTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
                final String string = (String)jTable.getValueAt(n, 0);
                JButton jButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.launchEditLevelMemberLanguageDialog(n);
                    }

                    private void launchEditLevelMemberLanguageDialog(int n2) {
                        String string3 = jTextField.getText();
                        DimensionGeneralPanel.this.languageExpressionBuilder.setMemberProperty(string);
                        DimensionGeneralPanel.this.languageExpressionBuilder.clearEditorText();
                        DimensionGeneralPanel.this.languageExpressionBuilder.setText(string3);
                        DimensionGeneralPanel.this.languageExpressionBuilder.setLanguageEditorUsage(HCSArb.format("SNIPPET_CODE_EDITOR_ALL_MEMBER_USAGE", string));
                        String string2 = SyntaxBuilderLauncher.spawnDialog(DimensionGeneralPanel.this.languageExpressionBuilder.getEditorPanel());
                        if (string2 != null) {
                            jTextField.setText(string2);
                        } else {
                            jTextField.setText(string3);
                        }
                    }
                });
                jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
                return jPanel;
            }
            return this.getComponent();
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField;
            String string;
            String string2;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n = tableColumn.getModelIndex();
            if (!(n != 1 || (string2 = (string = (jTextField = (JTextField)this.getComponent()).getText()).toLowerCase().trim()).startsWith(DimensionGeneralPanel.this.CASE) && string2.endsWith(DimensionGeneralPanel.this.END))) {
                String string3;
                if (string.startsWith("'")) {
                    string = string.substring(1);
                }
                if (string.endsWith("'")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (!(string3 = String.format("'%s'", UIStringUtils.escapeSingleQuotesForSQL(string))).equals(jTextField.getText())) {
                    jTextField.setText(string3);
                }
            }
            return super.stopCellEditing();
        }
    }
}

