/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.view;

import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSImagesArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.view.AVNode;
import oracle.hcs.db.view.MeasureNode;
import oracle.hcs.tree.view.CheckTreeManager;
import oracle.hcs.tree.view.JTree2;
import oracle.hcs.tree.view.NodeIcon;

public class MeasureTree
extends JTree2 {
    private CheckTreeManager checkTreeManager;

    public MeasureTree() {
        this.initUI();
    }

    public void setSelectedAll(boolean bl) {
        this.checkTreeManager.setSelectedAll(bl);
    }

    public void selectMeasureNode(String string, String string2) {
        TreePath treePath = this.findByName(this, new String[]{"root", string, string2});
        this.checkTreeManager.setSelected(treePath, true);
    }

    public boolean isSelected(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            boolean bl = this.isNodeSelected(defaultMutableTreeNode, object);
            return bl;
        }
        return false;
    }

    private boolean isNodeSelected(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            TreePath treePath = MeasureTree.getPath(defaultMutableTreeNode);
            boolean bl = true;
            boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
            return bl2;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || !this.isNodeSelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullySelected() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            boolean bl = this.isNodeFullySelected(defaultMutableTreeNode);
            return bl;
        }
        return true;
    }

    private boolean isNodeFullySelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = MeasureTree.getPath(defaultMutableTreeNode);
        boolean bl = true;
        boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
        if (!bl2) {
            return false;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || this.isNodeFullySelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode)) continue;
            return false;
        }
        return true;
    }

    public void init(AnalyticView analyticView) {
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getMeasureTree(analyticView);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultTreeModel.setRoot(defaultMutableTreeNode);
        }
    }

    private DefaultMutableTreeNode getMeasureTree(AnalyticView analyticView) {
        AVNode aVNode = new AVNode(analyticView);
        List<AVBaseMeasure> list = analyticView.getStoredAndCalculatedMeasures();
        for (AVBaseMeasure aVBaseMeasure : list) {
            MeasureNode measureNode = new MeasureNode(aVBaseMeasure);
            aVNode.add(measureNode);
        }
        return aVNode;
    }

    private void initUI() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        NodeIcon nodeIcon = new NodeIcon(){

            @Override
            public Icon getIcon(Object object) {
                if (object instanceof AVNode) {
                    return HCSImagesArb.getIcon("AV_ICON");
                }
                if (object instanceof MeasureNode) {
                    return HCSImagesArb.getIcon("MEASURE_ICON");
                }
                return null;
            }

            @Override
            public Icon getDisabledIcon(Object object) {
                if (object instanceof AVNode) {
                    return HCSImagesArb.getIcon("AV_ICON");
                }
                if (object instanceof MeasureNode) {
                    return HCSImagesArb.getIcon("MEASURE_ICON");
                }
                return null;
            }
        };
        this.checkTreeManager = new CheckTreeManager(this, nodeIcon);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.checkTreeManager != null) {
            this.checkTreeManager.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.checkTreeManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeAllPropertyChangeListeners() {
        this.checkTreeManager.removeAllPropertyChangeListeners();
    }

    public void enablePropertyChangeListeners(boolean bl) {
        this.checkTreeManager.enablePropertyChangeListeners(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkTreeManager.setEnabled(bl);
    }
}

