/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.MetadataUpdateListener;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSMetadataReader;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSpecTimeoutConnectionCache;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.util.HCSObjectsTimestamps;
import oracle.javatools.db.DBException;

public final class HCSMetadataCache {
    private static final Map<String, Status> schemas = Collections.synchronizedMap(new HashMap());
    private static final String KEY = "%s/%s";
    private static final Logger LOG = Logger.getLogger(HCSMetadataCache.class.getName());

    private HCSMetadataCache() {
        Connections.getInstance().addConnectionListener(new ConnectionListener(){

            public void connectionAdded(ConnectionEvent connectionEvent) {
            }

            public void connectionRemoved(ConnectionEvent connectionEvent) {
            }

            public void connectionRenamed(ConnectionEvent connectionEvent) {
            }

            public void connectionModified(ConnectionEvent connectionEvent) {
            }

            public void connectionOpened(ConnectionEvent connectionEvent) {
            }

            public void connectionClosed(ConnectionEvent connectionEvent) {
                Iterator<Map.Entry<String, Status>> iterator = schemas.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Status> entry = iterator.next();
                    if (!entry.getKey().startsWith(connectionEvent.getConnectionName(), 0)) continue;
                    iterator.remove();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HCSSchema getSchema(String string, String string2) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2));
            if (!(status == null || status.updating || status.changes != null && status.changes.size() != 0)) {
                return status.schema;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HCSSchema getUpdatedSchema(String string, String string2) throws DBException, SQLException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        Status status = null;
        try {
            Object object = schemas;
            synchronized (object) {
                status = HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2));
                if (status == null || status.schema == null && !status.updating) {
                    bl = true;
                    HCSMetadataCache.startUpdating(string, string2);
                    status = HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2));
                } else {
                    while (status.updating) {
                        try {
                            schemas.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        if (HCSMetadataCache.schemaChanged(status, string, string2)) {
                            bl2 = true;
                            HCSMetadataCache.startUpdating(string, string2);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(HCSMetadataCache.class.getName()).log(Level.SEVERE, "Error when checking for metadata changes", exception);
                    }
                }
            }
            if (bl) {
                object = Connections.getInstance().getConnection(string);
                status.schema = new HCSSchema(string2);
                HCSMetadataReader hCSMetadataReader = new HCSMetadataReader(new DatabaseImpl((Connection)object), status.schema);
                hCSMetadataReader.loadMetadata();
                HCSMetadataCache.putSchema(string, status.schema);
                bl = false;
            } else if (bl2) {
                HCSMetadataCache.doProcessChanges(status.schema, status.changes, string);
                bl2 = false;
            }
        }
        finally {
            if ((bl || bl2) && status != null) {
                status.updating = false;
            }
        }
        return status.schema;
    }

    private static boolean schemaChanged(Status status, String string, String string2) throws Exception {
        boolean bl = false;
        HCSSpecTimeoutConnectionCache hCSSpecTimeoutConnectionCache = HCSSpecTimeoutConnectionCache.getInstance("Get_Instance");
        Connection connection = null;
        if (hCSSpecTimeoutConnectionCache.isActive() && hCSSpecTimeoutConnectionCache.getConnection(string) != null) {
            connection = hCSSpecTimeoutConnectionCache.getConnection(string);
        }
        if (connection == null) {
            connection = Connections.getInstance().getConnection(string);
        }
        HCSSchema hCSSchema = null;
        if (hCSSpecTimeoutConnectionCache.isActive()) {
            if (hCSSpecTimeoutConnectionCache.getSchemaWithTimestamp(string) != null) {
                hCSSchema = hCSSpecTimeoutConnectionCache.getSchemaWithTimestamp(string);
            } else {
                hCSSchema = HCSObjectsTimestamps.getLatestHCSObjectsTimestamps(connection, string2);
                hCSSpecTimeoutConnectionCache.setSchemaWithTimestamp(hCSSchema, string);
            }
        } else {
            hCSSchema = HCSObjectsTimestamps.getLatestHCSObjectsTimestamps(connection, string2);
        }
        boolean bl2 = HCSMetadataCache.dimensionsChanged(status, hCSSchema, string, string2);
        boolean bl3 = HCSMetadataCache.hierarchiesChanged(status, hCSSchema, string, string2);
        bl = HCSMetadataCache.analyticViewsChanged(status, hCSSchema, string, string2);
        return bl2 || bl3 || bl;
    }

    private static boolean dimensionsChanged(Status status, HCSSchema hCSSchema, String string, String string2) {
        boolean bl = false;
        if (hCSSchema.getDimensions().size() > status.schema.getDimensions().size()) {
            for (AttributeDimension attributeDimension : hCSSchema.getDimensions()) {
                if (status.schema.findDimension(attributeDimension.getName()) != null && attributeDimension.getTimestamp() <= status.schema.findDimension(attributeDimension.getName()).getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(attributeDimension.getName(), HCSSyntaxType.DIMENSION));
                bl = true;
            }
        } else if (hCSSchema.getDimensions().size() < status.schema.getDimensions().size()) {
            for (AttributeDimension attributeDimension : status.schema.getDimensions()) {
                if (hCSSchema.findDimension(attributeDimension.getName()) != null && attributeDimension.getTimestamp() >= hCSSchema.findDimension(attributeDimension.getName()).getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(attributeDimension.getName(), HCSSyntaxType.DIMENSION));
                bl = true;
            }
        } else {
            for (AttributeDimension attributeDimension : status.schema.getDimensions()) {
                AttributeDimension attributeDimension2 = hCSSchema.findDimension(attributeDimension.getName());
                if (attributeDimension2 != null && attributeDimension.getTimestamp() >= attributeDimension2.getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(attributeDimension.getName(), HCSSyntaxType.DIMENSION));
                bl = true;
            }
        }
        return bl;
    }

    private static boolean hierarchiesChanged(Status status, HCSSchema hCSSchema, String string, String string2) {
        boolean bl = false;
        if (hCSSchema.getHierarchies().size() > status.schema.getHierarchies().size()) {
            for (Hierarchy hierarchy : hCSSchema.getHierarchies()) {
                if (status.schema.findHierarchy(hierarchy.getName()) != null && hierarchy.getTimestamp() <= status.schema.findHierarchy(hierarchy.getName()).getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(hierarchy.getName(), HCSSyntaxType.HIERARCHY));
                bl = true;
            }
        } else if (hCSSchema.getHierarchies().size() < status.schema.getHierarchies().size()) {
            for (Hierarchy hierarchy : status.schema.getHierarchies()) {
                if (hCSSchema.findHierarchy(hierarchy.getName()) != null && hierarchy.getTimestamp() >= hCSSchema.findHierarchy(hierarchy.getName()).getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(hierarchy.getName(), HCSSyntaxType.HIERARCHY));
                bl = true;
            }
        } else {
            for (Hierarchy hierarchy : status.schema.getHierarchies()) {
                Hierarchy hierarchy2 = hCSSchema.findHierarchy(hierarchy.getName());
                if (hierarchy2 != null && hierarchy.getTimestamp() >= hierarchy2.getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(hierarchy.getName(), HCSSyntaxType.HIERARCHY));
                bl = true;
            }
        }
        return bl;
    }

    private static boolean analyticViewsChanged(Status status, HCSSchema hCSSchema, String string, String string2) {
        boolean bl = false;
        if (hCSSchema.getAnalyticViews().size() > status.schema.getAnalyticViews().size()) {
            for (AnalyticView analyticView : hCSSchema.getAnalyticViews()) {
                if (status.schema.findAV(analyticView.getName()) != null && analyticView.getTimestamp() <= status.schema.findAV(analyticView.getName()).getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(analyticView.getName(), HCSSyntaxType.ANALYTIC_VIEW));
                bl = true;
            }
        } else if (hCSSchema.getAnalyticViews().size() < status.schema.getAnalyticViews().size()) {
            for (AnalyticView analyticView : status.schema.getAnalyticViews()) {
                if (hCSSchema.findAV(analyticView.getName()) != null && analyticView.getTimestamp() >= hCSSchema.findAV(analyticView.getName()).getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(analyticView.getName(), HCSSyntaxType.ANALYTIC_VIEW));
                bl = true;
            }
        } else {
            for (AnalyticView analyticView : status.schema.getAnalyticViews()) {
                AnalyticView analyticView2 = hCSSchema.findAV(analyticView.getName());
                if (analyticView2 != null && analyticView.getTimestamp() >= analyticView2.getTimestamp()) continue;
                HCSMetadataCache.recordMetadataChange(string, string2, new MetadataChange(analyticView.getName(), HCSSyntaxType.ANALYTIC_VIEW));
                bl = true;
            }
        }
        return bl;
    }

    private static void doProcessChanges(HCSSchema hCSSchema, HashSet<MetadataChange> hashSet, String string) throws SQLException, IOException, DBException {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        LinkedList<String> linkedList4 = new LinkedList<String>();
        Connection connection = Connections.getInstance().getConnection(string);
        HashMap<Object, LinkedList<String>> hashMap = new HashMap<Object, LinkedList<String>>();
        hCSSchema.setLoaded(false);
        HCSMetadataReader hCSMetadataReader = new HCSMetadataReader(new DatabaseImpl(connection), hCSSchema);
        for (MetadataChange object2 : hashSet) {
            object = object2.getParentName();
            String string2 = object2.getObjectName();
            switch (object2.getObjectType()) {
                case MEASURE: {
                    LinkedList<String> linkedList5 = (LinkedList<String>)hashMap.get(object);
                    if (linkedList5 == null) {
                        linkedList5 = new LinkedList<String>();
                        hashMap.put(object, linkedList5);
                    }
                    linkedList5.add(string2);
                    break;
                }
                case DIMENSION: {
                    linkedList4.add(string2);
                    if (!object2.getChangeType().equalsIgnoreCase("RENAME")) break;
                    linkedList4.add((String)object);
                    break;
                }
                case HIERARCHY: {
                    linkedList2.add(string2);
                    if (!object2.getChangeType().equalsIgnoreCase("RENAME")) break;
                    linkedList2.add((String)object);
                    break;
                }
                case ANALYTIC_VIEW: {
                    linkedList.add(string2);
                    if (!object2.getChangeType().equalsIgnoreCase("RENAME")) break;
                    linkedList.add((String)object);
                    break;
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = hCSSchema.findAV((String)entry.getKey());
            if (object == null) continue;
            hCSMetadataReader.reloadMeasures((AnalyticView)object, (List)entry.getValue());
        }
        if (!linkedList4.isEmpty()) {
            hCSMetadataReader.reloadDimensions(linkedList4);
        }
        if (!linkedList2.isEmpty()) {
            hCSMetadataReader.reloadHierarchies(linkedList2);
        }
        if (!linkedList.isEmpty()) {
            hCSMetadataReader.reloadAnalyticViews(linkedList, false);
        }
        if (!linkedList3.isEmpty()) {
            hCSMetadataReader.reloadAnalyticViews(linkedList3, true);
        }
        HCSMetadataCache.putSchema(string, hCSSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HCSSchema getSchemaCopy(String string, String string2) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            try {
                HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
                if (hCSSchema != null) {
                    HCSSchema hCSSchema2 = hCSSchema.copy();
                    return hCSSchema2;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error copying schema", exception);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void putSchema(String string, HCSSchema hCSSchema) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            String string2 = HCSMetadataCache.key(string, hCSSchema.getName());
            Status status = HCSMetadataCache.getStatus(string2);
            if (status == null) {
                status = new Status();
                schemas.put(string2, status);
            }
            schemas.put(string2, status);
            status.schema = hCSSchema;
            status.changes = null;
            status.updating = false;
            schemas.notifyAll();
        }
        HCSMetadataCache.fireMetadataEvent(string, hCSSchema.getName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HCSSchema removeSchema(String string, String string2) {
        HCSSchema hCSSchema = null;
        Map<String, Status> map = schemas;
        synchronized (map) {
            hCSSchema = HCSMetadataCache.clearStatus(HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2)));
        }
        HCSMetadataCache.fireMetadataEvent(string, string2, true);
        return hCSSchema;
    }

    private static final HCSSchema clearStatus(Status status) {
        HCSSchema hCSSchema = null;
        if (status != null) {
            hCSSchema = status.schema;
            status.schema = null;
            status.updating = false;
        }
        return hCSSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeSchemas(String string) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            for (Map.Entry<String, Status> entry : schemas.entrySet()) {
                if (!entry.getKey().startsWith(string, 0)) continue;
                HCSMetadataCache.clearStatus(entry.getValue());
            }
        }
    }

    public static final boolean hasForConnection(String string, String string2) {
        return HCSMetadataCache.getSchema(string, string2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean startUpdating(String string, String string2) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            String string3 = HCSMetadataCache.key(string, string2);
            Status status = HCSMetadataCache.getStatus(string3);
            if (status == null) {
                status = new Status();
                schemas.put(string3, status);
            }
            if (status.updating) {
                return false;
            }
            status.updating = true;
            HCSMetadataCache.fireMetadataEvent(string, string2, true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean recordMetadataChange(String string, String string2, MetadataChange metadataChange) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2));
            if (status != null) {
                if (status.changes == null) {
                    status.changes = new HashSet();
                }
                if (metadataChange.getObjectType() == HCSSyntaxType.MEASURE) {
                    for (MetadataChange metadataChange2 : status.changes) {
                        if (metadataChange2.getObjectType() != HCSSyntaxType.ANALYTIC_VIEW || !metadataChange2.getObjectName().equals(metadataChange.getParentName())) continue;
                        return true;
                    }
                } else if (metadataChange.getObjectType() == HCSSyntaxType.ANALYTIC_VIEW) {
                    LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
                    if (status.changes.add(metadataChange)) {
                        for (MetadataChange metadataChange3 : status.changes) {
                            if (metadataChange3.getObjectType() != HCSSyntaxType.MEASURE || !metadataChange3.getParentName().equals(metadataChange.getObjectName())) continue;
                            linkedList.add(metadataChange3);
                        }
                        status.changes.removeAll(linkedList);
                    }
                    return true;
                }
                status.changes.add(metadataChange);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUpdateListener(String string, String string2, MetadataUpdateListener metadataUpdateListener) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            String string3 = HCSMetadataCache.key(string, string2);
            Status status = HCSMetadataCache.getStatus(string3);
            if (status == null) {
                status = new Status();
                schemas.put(string3, status);
            }
            if (status.listeners == null) {
                status.listeners = new EventListenerList();
            }
            status.listeners.add(MetadataUpdateListener.class, metadataUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUpdateListener(String string, String string2, MetadataUpdateListener metadataUpdateListener) {
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2));
            if (status != null && status.listeners != null) {
                status.listeners.remove(MetadataUpdateListener.class, metadataUpdateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireMetadataEvent(String string, String string2, boolean bl) {
        Object[] objectArray;
        HCSSchema hCSSchema = null;
        Map<String, Status> map = schemas;
        synchronized (map) {
            Status status = HCSMetadataCache.getStatus(HCSMetadataCache.key(string, string2));
            if (status == null || status.listeners == null) {
                return;
            }
            hCSSchema = status.schema;
            objectArray = status.listeners.getListenerList();
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MetadataUpdateListener.class) continue;
            if (bl) {
                ((MetadataUpdateListener)objectArray[i + 1]).metadataCleared();
                continue;
            }
            ((MetadataUpdateListener)objectArray[i + 1]).metadataUpdated(hCSSchema);
        }
    }

    private static String key(String string, String string2) {
        return String.format(KEY, string, string2);
    }

    private static final Status getStatus(String string) {
        return schemas.get(string);
    }

    static class Status {
        HCSSchema schema;
        EventListenerList listeners;
        boolean updating;
        HashSet<MetadataChange> changes;

        Status() {
        }
    }
}

