/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.util.Logger;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.avviewer.AVViewerEditorToolbarActions;
import oracle.hcs.avviewer.AVViewerNode;
import oracle.hcs.avviewer.AVViewerPanel;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.MetadataUpdateListener;
import oracle.hcs.metadata.HCSSchema;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.AsynchronousEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVViewerEditor
extends AsynchronousEditor
implements MetadataUpdateListener {
    public static final String TYPE = "oracle.hcs.avviewer.AVViewerEditor";
    private static final String OBJECT_TYPE = HCSArb.get("AV_DATA_VIEWER_AV_TYPE");
    private AVViewerPanel panel;
    private Toolbar toolbar;
    private AVViewerEditorToolbarActions actions;

    public void openImpl(boolean bl) {
        if (bl) {
            this.closeOtherEditors();
            this.initToolbar();
        }
    }

    public void closeImpl(boolean bl) {
        super.closeImpl(bl);
        AVViewerNode aVViewerNode = (AVViewerNode)this.getContext().getNode();
        String string = aVViewerNode.getConnectionName();
        String string2 = aVViewerNode.getSchemaName();
        HCSMetadataCache.removeUpdateListener(string, string2, this);
    }

    private void initToolbar() {
        this.actions = new AVViewerEditorToolbarActions(this);
        this.actions.initToolbarActions();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        this.closeOtherEditors();
    }

    private void closeOtherEditors() {
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.findEditors(this.getContext());
        if (list.size() > 0) {
            editorManager.closeEditors(this.findEditorsToClose(list));
        } else {
            list = editorManager.getAllEditors();
            editorManager.closeEditors(this.findEditorsToClose(list));
        }
    }

    private List<Editor> findEditorsToClose(List<Editor> list) {
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (Editor editor : list) {
            ViewerNode viewerNode;
            if (!editor.getType().equalsIgnoreCase(TYPE) || editor == this || (viewerNode = (ViewerNode)editor.getContext().getNode()).getPinned()) continue;
            arrayList.add(editor);
        }
        return arrayList;
    }

    public Toolbar getFixedTopMargin() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
        }
        return this.toolbar;
    }

    public String getTabLabel() {
        AVViewerNode aVViewerNode = (AVViewerNode)this.getContext().getNode();
        return String.format("%s %s Data", aVViewerNode.getAVName(), OBJECT_TYPE);
    }

    protected void init() throws Exception {
        AVViewerNode aVViewerNode = (AVViewerNode)this.getContext().getNode();
        if (this.panel == null) {
            String string = aVViewerNode.getConnectionName();
            String string2 = aVViewerNode.getSchemaName();
            String string3 = aVViewerNode.getAVName();
            HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
            AnalyticView analyticView = hCSSchema.findAV(string3);
            for (AVCalculatedMeasure aVCalculatedMeasure : analyticView.getCalculatedMeasures()) {
                aVCalculatedMeasure.setSelected(false);
            }
            int n = 0;
            for (AVMeasure aVMeasure : analyticView.getMeasures()) {
                aVMeasure.setSelected(true);
                if (n == 5) break;
                ++n;
            }
            this.panel = new AVViewerPanel(null, (OracleDatabaseImpl)aVViewerNode.getDatabase(), analyticView);
            HCSMetadataCache.addUpdateListener(string, string2, this);
        }
    }

    protected boolean isContentModelLoaded() {
        return this.panel != null;
    }

    protected Component getGUIComponent() {
        boolean bl;
        boolean bl2 = bl = this.panel != null;
        if (bl) {
            return this.panel;
        }
        return null;
    }

    protected void getEditorContent(Context context) {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doSetContext(Context context) {
    }

    protected void editorReady() {
        super.editorReady();
        if (this.panel != null) {
            this.switchEditorGuiInUiThread(this.panel);
        }
    }

    @Override
    public void metadataUpdated(HCSSchema hCSSchema) {
        AVViewerNode aVViewerNode = (AVViewerNode)this.getContext().getNode();
        if (this.panel != null) {
            String string = aVViewerNode.getAVName();
            if (hCSSchema.findAV(string) == null) {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this));
            } else {
                AnalyticView analyticView = hCSSchema.findAV(string);
                try {
                    this.panel.reload((OracleDatabaseImpl)aVViewerNode.getDatabase(), analyticView);
                }
                catch (Exception exception) {
                    Logger.severe(AVViewerEditor.class, (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void metadataCleared() {
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("av_data_viewer");
    }
}

