/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.table.TableCheckBoxCellEditor;
import oracle.hcs.table.TableCheckBoxCellRenderer;
import oracle.hcs.templates.templateview.TemplateSelections;
import oracle.hcs.util.CheckBoxHeader;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class AVMeasureSelectionPanel
extends JPanel
implements TableModelListener,
TemplateSelections {
    private DefaultTableModel measureTableModel;
    private JTable measureTable;
    private SearchField measureFilterFld;
    private CheckBoxHeader checkBoxHeader;
    private AnalyticView cube;
    private List<PropertyChangeListener> listeners;
    private int totalRows;
    private int selectedRows;
    private static final int COL_SELECT = 0;
    private static final int COL_MEASURE_NAME = 1;
    private static final int COL_DESC = 2;
    private static final int COL_EXPRESSION = 3;

    public AVMeasureSelectionPanel(AnalyticView analyticView) {
        this.cube = analyticView;
        this.measureTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 <= 0;
            }
        };
        this.measureTableModel.addTableModelListener(this);
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.layoutComponents();
        this.initTable();
        this.loadMeasureTable();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    private void initTable() {
        this.measureTableModel.setRowCount(0);
        this.measureTableModel.setColumnCount(0);
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_SELECT_COLUMN"));
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_MEASURE_NAME_COLUMN"));
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_DESCRIPTION_COLUMN"));
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_EXPRESSION_COLUMN"));
        TableColumn tableColumn = this.measureTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new TableCheckBoxCellEditor());
        tableColumn.setCellRenderer(new TableCheckBoxCellRenderer());
        this.checkBoxHeader = new CheckBoxHeader(this.measureTable);
        tableColumn.setHeaderRenderer(this.checkBoxHeader);
        tableColumn.setPreferredWidth(70);
        tableColumn = this.measureTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(400);
    }

    private void loadMeasureTable() {
        String string;
        String string2;
        String string3 = "";
        if (this.measureFilterFld.getText() != null) {
            string3 = this.measureFilterFld.getText();
        }
        this.measureTableModel.setRowCount(0);
        this.totalRows = 0;
        this.selectedRows = 0;
        for (AVMeasure aVBaseMeasure : this.cube.getMeasures()) {
            boolean bl;
            string2 = aVBaseMeasure.getName();
            if (string3.length() > 0 && !(bl = string2.contains(string3.toUpperCase()))) continue;
            bl = aVBaseMeasure.isSelected();
            string = "";
            this.measureTableModel.addRow(new Object[]{bl, aVBaseMeasure.getName(), aVBaseMeasure.getDescription(), string});
            ++this.totalRows;
            if (!bl) continue;
            ++this.selectedRows;
        }
        for (AVBaseMeasure aVBaseMeasure : this.cube.getCalculatedMeasures()) {
            boolean bl;
            string2 = aVBaseMeasure.getName();
            if (string3.length() > 0 && !(bl = string2.contains(string3.toUpperCase()))) continue;
            Boolean bl2 = aVBaseMeasure.isSelected();
            string = ((AVCalculatedMeasure)aVBaseMeasure).getMeasureExpression();
            this.measureTableModel.addRow(new Object[]{bl2, aVBaseMeasure.getName(), aVBaseMeasure.getDescription(), string});
            ++this.totalRows;
            if (!bl2.booleanValue()) continue;
            ++this.selectedRows;
        }
        this.updateSelectAll();
    }

    public int getSelectedMeasuresCount() {
        return this.selectedRows;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n == -1) {
            return;
        }
        if (tableModelEvent.getSource() == this.measureTableModel && tableModelEvent.getType() == 0) {
            this.updateMeasureTableModelFromCell(n, n2);
        }
    }

    private void updateMeasureTableModelFromCell(int n, int n2) {
        if (n2 != 0) {
            return;
        }
        String string = (String)this.measureTable.getValueAt(n, 1);
        Object object = this.measureTable.getValueAt(n, n2);
        Boolean bl = (Boolean)object;
        for (AVMeasure aVBaseMeasure : this.cube.getMeasures()) {
            if (!aVBaseMeasure.getName().equals(string)) continue;
            aVBaseMeasure.setSelected(bl);
            if (bl.booleanValue() && this.selectedRows < this.totalRows) {
                ++this.selectedRows;
                break;
            }
            if (bl.booleanValue() || this.selectedRows <= 0) break;
            --this.selectedRows;
            break;
        }
        for (AVBaseMeasure aVBaseMeasure : this.cube.getCalculatedMeasures()) {
            if (!aVBaseMeasure.getName().equals(string)) continue;
            aVBaseMeasure.setSelected(bl);
            if (bl.booleanValue() && this.selectedRows < this.totalRows) {
                ++this.selectedRows;
                break;
            }
            if (bl.booleanValue() || this.selectedRows <= 0) break;
            --this.selectedRows;
            break;
        }
        this.updateSelectAll();
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.measureTable, string, bl == false, bl);
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    private void layoutComponents() {
        JLabel jLabel = new JLabel(HCSArb.get("AV_QUERY_TOP_LABEL"));
        jLabel.setName("topLabel");
        this.measureTable = new JTable(this.measureTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 == 3 && component instanceof JComponent) {
                    Object object = AVMeasureSelectionPanel.this.measureTableModel.getValueAt(n, n2);
                    JComponent jComponent = (JComponent)component;
                    if (object != null) {
                        String string = object.toString();
                        Properties properties = new Properties();
                        properties.put("HTML", Boolean.TRUE);
                    }
                }
                return component;
            }
        };
        this.measureTable.setName("measureTable");
        this.measureTable.setAutoResizeMode(0);
        JLabel jLabel2 = new JLabel(HCSArb.get("MEASURE_FILTER"));
        jLabel2.setName("measureFilterLabel");
        this.measureFilterFld = new SearchField(SearchField.Style.FILTER);
        this.measureFilterFld.setName("measureFilterFld");
        JPanel jPanel = new JPanel();
        jPanel.setName("measuresPanel");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("measureScrollPane");
        jScrollPane.getViewport().add(this.measureTable);
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 5, 0));
        jPanel.add((Component)this.measureFilterFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 5, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 5, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.measureFilterFld.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                AVMeasureSelectionPanel.this.loadMeasureTable();
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
    }

    private void updateSelectAll() {
        if (this.selectedRows == this.totalRows && this.selectedRows > 0) {
            this.checkBoxHeader.setSelected(true);
        } else if (this.selectedRows < this.totalRows) {
            this.checkBoxHeader.setSelected(false);
        } else if (this.selectedRows == 0) {
            this.checkBoxHeader.setSelected(false);
        }
        this.measureTable.getTableHeader().repaint();
    }

    @Override
    public List<String> getSelectedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AVBaseMeasure aVBaseMeasure : this.cube.getStoredAndCalculatedMeasures()) {
            if (!aVBaseMeasure.isSelected()) continue;
            arrayList.add(aVBaseMeasure.getName());
        }
        return arrayList;
    }

    @Override
    public void setSelectedItems(List<String> list) {
        for (AVBaseMeasure object : this.cube.getStoredAndCalculatedMeasures()) {
            object.setSelected(false);
        }
        for (String string : list) {
            AVCalculatedMeasure aVCalculatedMeasure;
            AVMeasure aVMeasure = this.cube.findMeasure(string);
            if (aVMeasure != null) {
                aVMeasure.setSelected(true);
            }
            if ((aVCalculatedMeasure = this.cube.findCalculatedMeasure(string)) == null) continue;
            aVCalculatedMeasure.setSelected(true);
        }
        this.loadMeasureTable();
    }
}

