/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.panels.HierarchyNode;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.treetable.TreeTableModel;

public class HierarchyTreeTableModel
implements TreeTableModel {
    private static final int HIERARCHY_ALIAS_COLUMN = 1;
    private static final int HIERARCHY_INCLUDE_COLUMN = 2;
    private static final int HIERARCHY_DEFAULT_COLUMN = 3;
    private static String[] columns = new String[]{HCSArb.getString("HIERARCHY_TABLE_DIMENSION_NAME"), HCSArb.getString("HIERARCHY_TABLE_ALIAS"), HCSArb.getString("HIERARCHY_TABLE_INCLUDE"), HCSArb.getString("HIERARCHY_TABLE_DEFAULT")};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class, Boolean.class, Boolean.class};
    private AVDimensionality[] dimensions;
    private HierarchyNode rootNode;

    public HierarchyTreeTableModel() {
        this(null, null);
    }

    public HierarchyTreeTableModel(DBObjectProvider dBObjectProvider, AVDimensionality[] aVDimensionalityArray) {
        this.rootNode = new HierarchyNode(dBObjectProvider, null, "", HierarchyNode.NodeContentType.ROOT_NODE);
        this.rootNode.setIsRoot(true);
        this.dimensions = aVDimensionalityArray;
        if (aVDimensionalityArray != null && dBObjectProvider != null) {
            this.populate(dBObjectProvider, aVDimensionalityArray);
        }
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        switch (n) {
            case 1: {
                return hierarchyNode.getHierarchyAlias();
            }
            case 2: {
                return hierarchyNode.isHierarchyIncluded();
            }
            case 3: {
                return hierarchyNode.isHierarchyDefault();
            }
        }
        return "";
    }

    public boolean isCellEditable(Object object, int n) {
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        return hierarchyNode.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.HIERARCHY_NODE) && n == 1;
    }

    public void setValueAt(Object object, Object object2, int n) {
        HierarchyNode hierarchyNode = (HierarchyNode)object2;
        if (hierarchyNode.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.HIERARCHY_NODE) && n == 1) {
            hierarchyNode.setHierarchyAlias(String.valueOf(object));
        }
    }

    public Object getRoot() {
        return this.rootNode;
    }

    protected Object[] getChildren(Object object) {
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        return hierarchyNode.getChildren();
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    public int getChildCount(Object object) {
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        return hierarchyNode.getChildren().length;
    }

    public boolean isLeaf(Object object) {
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        return hierarchyNode.getChildren().length == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void clear() {
        this.rootNode.clearChildren();
    }

    public void populate(DBObjectProvider dBObjectProvider, AVDimensionality[] aVDimensionalityArray) {
        for (AVDimensionality aVDimensionality : aVDimensionalityArray) {
            String string = aVDimensionality.getName();
            String string2 = aVDimensionality.getDimensionAlias();
            HierarchyNode hierarchyNode = this.rootNode.findDimensionNodeByAlias(string2);
            if (hierarchyNode != null) continue;
            this.rootNode.addHierarchyNode(dBObjectProvider, string, HierarchyNode.NodeContentType.DIMENSION_NODE);
            HierarchyNode hierarchyNode2 = (HierarchyNode)this.rootNode.getChildren()[this.rootNode.getChildren().length - 1];
            String string3 = dBObjectProvider.getExternalName(aVDimensionality.getDimensionAlias());
            hierarchyNode2.setDimensionAlias(string3);
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                hierarchyNode2.addHierarchyNode(dBObjectProvider, aVHierarchy, HierarchyNode.NodeContentType.HIERARCHY_NODE);
            }
        }
    }
}

