/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.util.SelectionNode;
import oracle.hcs.util.UIStringUtils;
import oracle.javatools.db.DBObjectProvider;

public class HierarchyNode
implements SelectionNode {
    private List<Object> children;
    private AVHierarchy hierarchy;
    private String dimensionName;
    private String dimensionAlias;
    private boolean isRoot;
    private NodeContentType type;
    private DBObjectProvider prov;

    public HierarchyNode() {
        this(null, null, "", null);
    }

    public HierarchyNode(DBObjectProvider dBObjectProvider, AVHierarchy aVHierarchy, String string, NodeContentType nodeContentType) {
        this.prov = dBObjectProvider;
        this.hierarchy = aVHierarchy;
        this.dimensionName = string;
        this.type = nodeContentType;
        this.children = new ArrayList<Object>();
    }

    public void setDimensionAlias(String string) {
        this.dimensionAlias = string;
    }

    public void setIsRoot(boolean bl) {
        this.isRoot = bl;
    }

    public void addHierarchyNode(DBObjectProvider dBObjectProvider, String string, NodeContentType nodeContentType) {
        HierarchyNode hierarchyNode = new HierarchyNode(dBObjectProvider, null, string, nodeContentType);
        this.children.add(hierarchyNode);
    }

    public void addHierarchyNode(DBObjectProvider dBObjectProvider, AVHierarchy aVHierarchy, NodeContentType nodeContentType) {
        HierarchyNode hierarchyNode = new HierarchyNode(dBObjectProvider, aVHierarchy, aVHierarchy.getParent().getName(), nodeContentType);
        this.children.add(hierarchyNode);
    }

    public boolean removeHierarchyNode(HierarchyNode hierarchyNode) {
        if (!this.children.isEmpty()) {
            return this.children.remove(hierarchyNode);
        }
        return false;
    }

    public String getDimensionName() {
        String string = null;
        string = this.prov != null ? this.prov.getExternalName(this.dimensionName) : this.dimensionName;
        return string;
    }

    public String getDimensionAlias() {
        return this.dimensionAlias;
    }

    public String getHierarchyName() {
        if (this.hierarchy != null) {
            return this.hierarchy.getHierarchyName();
        }
        return "";
    }

    public String getHierarchyAlias() {
        String string = "";
        if (this.hierarchy != null) {
            string = this.prov != null ? this.prov.getExternalName(this.hierarchy.getHierarchyAlias()) : this.hierarchy.getHierarchyAlias();
        }
        return string;
    }

    public void setHierarchyAlias(String string) {
        if (this.hierarchy != null) {
            string = UIStringUtils.stripDoubleQuotes(string);
            this.hierarchy.setHierarchyAlias(string);
        }
    }

    public boolean isHierarchyDefault() {
        if (this.hierarchy != null) {
            return this.hierarchy.isHierarchyDefault();
        }
        return false;
    }

    protected Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    public boolean isParent() {
        return this.children.size() > 0;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    public AVHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setIsDefaultHierarchy(boolean bl) {
        if (this.hierarchy != null) {
            this.hierarchy.setHierarchyDefault(bl);
        }
    }

    public NodeContentType getNodeContentType() {
        return this.type;
    }

    public boolean isHierarchyIncluded() {
        if (this.hierarchy != null) {
            return this.hierarchy.isHierarchyIncluded();
        }
        return false;
    }

    public void setIncludeHierarchy(boolean bl) {
        if (this.hierarchy != null) {
            this.hierarchy.setHierarchyIncluded(bl);
        }
    }

    public String toString() {
        switch (this.type) {
            case DIMENSION_NODE: {
                return String.format("%s (%s)", this.getDimensionName(), this.dimensionAlias);
            }
            case HIERARCHY_NODE: {
                return this.hierarchy.getHierarchyName();
            }
        }
        return "";
    }

    public boolean equals(Object object) {
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        if (this.hierarchy != null) {
            return this.hierarchy.equals(hierarchyNode.getHierarchy());
        }
        String string = hierarchyNode.getDimensionAlias();
        if (string != null) {
            return this.dimensionName.equalsIgnoreCase(hierarchyNode.getDimensionName()) && this.dimensionAlias.equals(string);
        }
        return this.dimensionName.equalsIgnoreCase(hierarchyNode.getDimensionName());
    }

    public HierarchyNode findHierarchyNode(AVHierarchy aVHierarchy) {
        HierarchyNode hierarchyNode = this;
        HierarchyNode hierarchyNode2 = null;
        Stack<HierarchyNode> stack = new Stack<HierarchyNode>();
        stack.push(hierarchyNode);
        while (!stack.isEmpty()) {
            HierarchyNode hierarchyNode3 = (HierarchyNode)stack.pop();
            if (!hierarchyNode3.isParent()) continue;
            for (Object object : hierarchyNode3.getChildren()) {
                HierarchyNode hierarchyNode4 = (HierarchyNode)object;
                if (!hierarchyNode4.isParent()) {
                    if (!hierarchyNode4.getHierarchy().equals(aVHierarchy)) continue;
                    return hierarchyNode4;
                }
                stack.push(hierarchyNode4);
            }
        }
        return hierarchyNode2;
    }

    public HierarchyNode findDimensionNode(String string) {
        HierarchyNode hierarchyNode = null;
        if (this.isRoot()) {
            for (Object object : this.getChildren()) {
                HierarchyNode hierarchyNode2 = (HierarchyNode)object;
                if (!hierarchyNode2.getDimensionName().equalsIgnoreCase(string)) continue;
                return hierarchyNode2;
            }
        }
        return hierarchyNode;
    }

    public HierarchyNode findDimensionNodeByAlias(String string) {
        HierarchyNode hierarchyNode = null;
        if (this.isRoot()) {
            for (Object object : this.getChildren()) {
                HierarchyNode hierarchyNode2 = (HierarchyNode)object;
                if (!hierarchyNode2.getDimensionAlias().equalsIgnoreCase(string)) continue;
                return hierarchyNode2;
            }
        }
        return hierarchyNode;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public static enum NodeContentType {
        ROOT_NODE,
        DIMENSION_NODE,
        HIERARCHY_NODE;

    }
}

