/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.hcs.HCSArb;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;

class HierarchyAliasCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected DBObjectProvider prov;
    protected JTextField cellTextField = new JTextField();
    protected AbstractChildObjectWithDesc abstractChildObjectWithDesc;
    protected int row;
    protected int column;
    protected JTable table;
    protected KeyAdapter ka = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u001b') {
                return;
            }
        }
    };

    public HierarchyAliasCellEditor(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
        this.cellTextField.addKeyListener(this.ka);
        this.cellTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void common() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.common();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.row = n;
        this.column = n2;
        this.cellTextField.setText((String)object);
        return this.cellTextField;
    }

    @Override
    public Object getCellEditorValue() {
        String string = this.cellTextField.getText();
        return string;
    }

    @Override
    public boolean stopCellEditing() {
        int n = 1;
        TableColumn tableColumn = this.table.getColumnModel().getColumn(this.column);
        int n2 = tableColumn.getModelIndex();
        if (n2 == n) {
            boolean bl = true;
            String string = null;
            String string2 = (String)this.table.getModel().getValueAt(this.row, 1);
            String string3 = this.cellTextField.getText();
            if (string3 == null || string3.length() == 0) {
                bl = false;
                string = HCSArb.getString("NO_ALIAS_HIERARCHY_ERROR");
            } else {
                try {
                    this.prov.validateName("HIERARCHY", string3);
                }
                catch (InvalidNameException invalidNameException) {
                    string = HCSArb.get("HIERARCHY_ALIAS_ERROR_NAME");
                    bl = false;
                }
            }
            if (!bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)HCSArb.get("GENERIC_ERROR_TITLE"), null);
                this.cellTextField.setText(string2);
                return bl;
            }
            if (!UIStringUtils.isQuotedName(string3)) {
                this.updateNameToUppercase(this.prov, string3.toUpperCase(), this.row, 1);
            }
        }
        return super.stopCellEditing();
    }

    protected void updateNameToUppercase(final DBObjectProvider dBObjectProvider, String string, int n, int n2) {
        final String string2 = string;
        final int n3 = n;
        final int n4 = n2;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    String string = (String)HierarchyAliasCellEditor.this.table.getModel().getValueAt(n3, n4);
                    string = dBObjectProvider.getInternalName(string);
                    String string22 = (String)string2;
                    if (string22 != null && string22.equalsIgnoreCase(string)) {
                        HierarchyAliasCellEditor.this.table.getModel().setValueAt(string2, n3, n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(thread);
    }
}

