/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.DDLBasedBaseMeasureActionsHelper;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.CalcReferences;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.NameProvider;
import oracle.hcs.util.UIStringUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;

public class RenameMeasuresHelper
extends DDLBasedBaseMeasureActionsHelper {
    protected List<AVBaseMeasure> dependencies;
    protected String analyticViewName;
    private List<AVBaseMeasure> measures;
    private Map<String, AVBaseMeasure> renameMeasuresMap;

    public RenameMeasuresHelper() {
        super(null, null);
    }

    public RenameMeasuresHelper(HCSSchema hCSSchema, AnalyticView analyticView, List<AVBaseMeasure> list, Database database) {
        super(database, hCSSchema);
        this.setOriginalAv((AnalyticView)DBUtil.makeTemporaryCopy((DBObject)analyticView));
        this.getOrigAv().setForceCreate(true);
        this.setUpdatedAv((AnalyticView)DBUtil.makeTemporaryCopy((DBObject)this.getOrigAv()));
        this.measures = list;
        this.analyticViewName = analyticView.getName();
        this.initParser(this.analyticViewName);
        this.renameMeasuresMap = new HashMap<String, AVBaseMeasure>();
        for (AVBaseMeasure aVBaseMeasure : list) {
            String string = aVBaseMeasure.getName();
            this.renameMeasuresMap.put(string, aVBaseMeasure);
        }
    }

    @Override
    public String getTitle() {
        return HCSArb.get("RENAME_MEASURES_TITLE");
    }

    protected void setDependencies(List<AVBaseMeasure> list) {
        this.dependencies = list;
    }

    @Override
    public Object getDependencies() {
        return this.dependencies;
    }

    protected void doRenameMeasures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, AVBaseMeasure> hashMap = new HashMap<String, AVBaseMeasure>();
        for (String string : this.renameMeasuresMap.keySet()) {
            AVBaseMeasure aVBaseMeasure = this.getUpdatedAv().findBaseMeasure(string);
            AVBaseMeasure aVBaseMeasure2 = this.renameMeasuresMap.get(string);
            String string2 = aVBaseMeasure2.getName();
            if (aVBaseMeasure == null) {
                aVBaseMeasure = this.getUpdatedAv().findBaseMeasure(string2);
            }
            if (UIStringUtils.isQuotedName(string2)) {
                string2 = this.getDatabase().getInternalName(string2);
            }
            if (!string2.equals(string)) {
                if (this.getUpdatedAv().getDefaultMeasure().equals(string)) {
                    this.getUpdatedAv().setDefaultMeasure(string2);
                    this.setDefaultMeasureChanged(true);
                }
                arrayList.add(string);
                this.addChangedMeasure(string);
            }
            if (aVBaseMeasure != null) {
                aVBaseMeasure.setName(string2);
                aVBaseMeasure.setCaption(aVBaseMeasure2.getCaption());
                aVBaseMeasure.setDescription(aVBaseMeasure2.getDescription());
                this.addChangedMeasure(string2);
            }
            hashMap.put(string2, aVBaseMeasure2);
        }
        this.getDependencies(arrayList);
        this.renameDependencies(arrayList);
        this.renameMeasuresMap.clear();
        this.renameMeasuresMap = hashMap;
    }

    private Object getDependencies(List<String> list) {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<AVBaseMeasure>();
            }
            for (String string : list) {
                NameProvider nameProvider = NameProvider.getInstance();
                nameProvider.setProvider((DBObjectProvider)this.getDatabase());
                List<AVBaseMeasure> list2 = CalcReferences.getDependencies(this.getSchema(), this.analyticViewName, string, this.getParser(), false);
                if (this.dependencies.isEmpty()) {
                    this.dependencies.addAll(list2);
                    continue;
                }
                for (AVBaseMeasure aVBaseMeasure : list2) {
                    if (this.dependencies.contains(aVBaseMeasure)) continue;
                    this.dependencies.add(aVBaseMeasure);
                }
            }
        }
        return this.dependencies;
    }

    private void renameDependencies(List<String> list) {
        for (String string : list) {
            AVBaseMeasure aVBaseMeasure = this.renameMeasuresMap.get(string);
            String string2 = aVBaseMeasure.getName();
            for (AVBaseMeasure aVBaseMeasure2 : this.dependencies) {
                if (!aVBaseMeasure2.isDerived()) continue;
                AVCalculatedMeasure aVCalculatedMeasure = this.getUpdatedAv().findCalculatedMeasure(aVBaseMeasure2.getName());
                String string3 = aVCalculatedMeasure.getName();
                String string4 = aVCalculatedMeasure.getExpression();
                string = this.getDatabase().getExternalName(string);
                string2 = this.getDatabase().getExternalName(string2);
                if (UIStringUtils.isQuotedName(string)) {
                    string4 = string4.replaceAll(string, string2);
                } else {
                    string4 = string4.replaceAll("\"" + string + "\"", string2);
                    string4 = string4.replaceAll("\\b(?iu)" + string + "\\b(?=(?:[^\"']*(\"|')[^\"']*\\1)*[^\"']*$)", string2);
                }
                aVCalculatedMeasure.setMeasureExpression(string4);
                this.addChangedMeasure(string3);
            }
        }
    }

    @Override
    public void setForceCreate(boolean bl) {
        this.getUpdatedAv().setForceCreate(bl);
    }

    @Override
    protected void modifyObjects() {
        this.doRenameMeasures();
    }
}

