/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ConfirmRenamePanel;
import oracle.hcs.actions.XMLQueryBasedActionHelper;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSCompileDDLGenerator;

public class RenameHelper
extends XMLQueryBasedActionHelper {
    private static final String RENAME_OBJECT_SQL = "renameObject";
    private static final String COMPILE_OBJECT_SQL = "compileObject";
    private ConfirmRenamePanel confirmRenamePanel;
    private String oldName;
    private String newName;
    private String errorMessage;
    private final String OWNER = "OWNER";
    private final String HIER_BIND_NAME = "HIERARCHY_NAME";
    private final String ATTR_DIM_BIND_NAME = "DIMENSION_NAME";
    private final String AV_BIND_NAME = "ANALYTIC_VIEW_NAME";
    private String objectBindName;
    private String queryName;
    private final String ATTR_DIMENSION_STATE_QUERY = "dimensionState";
    private final String HIERARCHY_STATE_QUERY = "hierarchyState";
    private final String AV_STATE_QUERY = "analyticViewState";
    private final String VALID = "VALID";
    private List<AbstractSchemaObjectWithDesc> dependencies;
    private HCSCompileDDLGenerator compileStatementsGeneratorHelper;
    private List<String> statementsToExecute;
    private final String OBJECTS_RENAME_OPTION_DEPENDENCIES_LABEL = "/*- - - - - - - - - - - - %s - - - - - - - - - - - -*/%s";

    public RenameHelper(DBObject dBObject, ConfirmRenamePanel confirmRenamePanel, HCSCompileDDLGenerator hCSCompileDDLGenerator, List<AbstractSchemaObjectWithDesc> list) {
        super(dBObject);
        this.confirmRenamePanel = confirmRenamePanel;
        this.compileStatementsGeneratorHelper = hCSCompileDDLGenerator;
        this.dependencies = list;
        this.oldName = confirmRenamePanel.getOldName();
    }

    @Override
    public String getTitle() {
        String string = this.getDBObject().getObjectName();
        String string2 = this.getProvider().getExternalName(string);
        return HCSArb.format("RENAME_DIALOG_TITLE", this.getDBObject().getSchemaName() + "." + string2);
    }

    @Override
    public String getSQL() {
        this.statementsToExecute = new ArrayList<String>();
        String string = this.getDBObject().getSchemaName();
        this.newName = this.confirmRenamePanel.getNewName();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getDBObject().getObjectType();
        this.setObjectsByType(string2);
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getDBObject().getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put(this.objectBindName, this.oldName);
        String string3 = this.getQuery(this.queryName);
        String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
        String string5 = String.format(this.getQuery(RENAME_OBJECT_SQL), string2, string, this.oldName, this.newName);
        this.statementsToExecute.add(string5);
        stringBuilder.append(String.format("%s%s", string5, ";\n\n"));
        if (string4 != null && string4.equals("VALID")) {
            String string6 = String.format(this.getQuery(COMPILE_OBJECT_SQL), string2, string, this.newName);
            this.statementsToExecute.add(string6);
            stringBuilder.append(String.format("%s%s", string6, ";\n\n"));
        }
        if (!this.dependencies.isEmpty()) {
            stringBuilder.append(String.format("/*- - - - - - - - - - - - %s - - - - - - - - - - - -*/%s", HCSArb.get("OBJECTS_RENAME_OPTION_DEPENDENCIES_LABEL"), "\n\n"));
            this.addAlterCompileDependenciesStatements(this.dependencies, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void addAlterCompileDependenciesStatements(List<AbstractSchemaObjectWithDesc> list, StringBuilder stringBuilder) {
        this.compileStatementsGeneratorHelper.clearCompileStatements();
        List<String> list2 = this.compileStatementsGeneratorHelper.generateCompileStatements(list);
        for (String string : list2) {
            String string2 = String.format("%s%s", string, ";\n\n");
            this.statementsToExecute.add(string);
            stringBuilder.append(string2);
        }
    }

    @Override
    public void commitChanges() throws Exception {
        this.getSQL();
        if (!this.statementsToExecute.isEmpty()) {
            Connection connection = this.getDBObject().getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            for (String string : this.statementsToExecute) {
                dBUtil.execute(string);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException == null) continue;
                throw sQLException;
            }
        }
    }

    private void setObjectsByType(String string) {
        if (string.equals("ATTRIBUTE DIMENSION")) {
            this.queryName = "dimensionState";
            this.objectBindName = "DIMENSION_NAME";
        } else if (string.equals("HIERARCHY")) {
            this.queryName = "hierarchyState";
            this.objectBindName = "HIERARCHY_NAME";
        } else if (string.equals("ANALYTIC VIEW")) {
            this.queryName = "analyticViewState";
            this.objectBindName = "ANALYTIC_VIEW_NAME";
        }
    }

    public boolean isNameValid() {
        this.newName = this.confirmRenamePanel.getNewName();
        String string = this.getDBObject().getObjectType();
        try {
            this.getProvider().validateName(string, this.newName);
        }
        catch (Exception exception) {
            this.errorMessage = exception.getMessage();
            return false;
        }
        return true;
    }

    @Override
    public boolean isObjectValid() {
        return this.isNameValid();
    }

    @Override
    public String getErrorTitle() {
        String string = this.getProvider().getExternalName(this.oldName);
        return HCSArb.format("RENAME_DIALOG_ERROR_TITLE", string);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

