/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyObjectsPropertiesAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmModifyObjectsPropertiesPanel;
import oracle.hcs.actions.DescriptionParentObjects;
import oracle.hcs.actions.ModifyObjectsPropertiesHelper;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.panels.HCSObjectDependenciesGenerator;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyAttribute;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class ModifyHierarchiesPropertiesAction
extends AbstractModifyObjectsPropertiesAction {
    private final String DIFF_PROPERTY = "hierarchies";
    private static final String HIERARCHY_TYPE = "HIERARCHY";
    private Map<String, List<Descriptions>> attributesDescObjectsMap = new HashMap<String, List<Descriptions>>();
    private final Logger LOG = Logger.getLogger(ModifyHierarchiesPropertiesAction.class.getName());
    private static final String HELP_ID = "obj_properties";

    @Override
    protected void initSchema() {
        try {
            String string = this.getConnectionName();
            String string2 = this.getSchemaName();
            HCSMetadataCache.removeSchema(string, string2);
            this.setSchema(HCSMetadataCache.getUpdatedSchema(string, string2));
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage());
        }
    }

    @Override
    protected Map<String, DescriptionParentObjects> createOriginalAndUpdatedTopDescObjects() {
        HashMap<String, DescriptionParentObjects> hashMap = new HashMap<String, DescriptionParentObjects>();
        for (DBObject dBObject : this.getSelection()) {
            DescriptionParentObjects descriptionParentObjects = new DescriptionParentObjects();
            Hierarchy hierarchy = this.getSchema().findHierarchy(dBObject.getObjectName());
            this.initForceCreateOption(hierarchy);
            HierarchyLevel[] hierarchyLevelArray = hierarchy.getHierarchyLevelsReverse();
            int n = 0;
            if (hierarchyLevelArray != null) {
                for (HierarchyLevel hierarchyLevel : hierarchyLevelArray) {
                    hierarchyLevel.setHierLevelOrder(n++);
                }
                hierarchy.setHierarchyLevels(hierarchyLevelArray);
            }
            Hierarchy object = (Hierarchy)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)hierarchy);
            descriptionParentObjects.setOriginalDescParentObj(hierarchy);
            descriptionParentObjects.setUpdatedDescParentObj(object);
            hashMap.put(dBObject.getObjectName(), descriptionParentObjects);
        }
        return hashMap;
    }

    @Override
    protected void initChildrenDescriptionObjects() {
        this.initHierarchyAttributes();
    }

    private void initHierarchyAttributes() {
        this.attributesDescObjectsMap = new HashMap<String, List<Descriptions>>();
        ArrayList<HierarchyAttribute> arrayList = new ArrayList<HierarchyAttribute>();
        for (String string : this.getOriginalAndUpdatedTopDescObjects().keySet()) {
            DescriptionParentObjects descriptionParentObjects = this.getOriginalAndUpdatedTopDescObjects().get(string);
            Hierarchy hierarchy = (Hierarchy)descriptionParentObjects.getUpdatedDescParentObj();
            for (HierarchyAttribute hierarchyAttribute : hierarchy.getHierarchyAttributes()) {
                if (this.attributesDescObjectsMap.containsKey(string)) {
                    this.attributesDescObjectsMap.get(string).add(hierarchyAttribute);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(hierarchyAttribute);
                this.attributesDescObjectsMap.put(hierarchy.getName(), arrayList);
            }
        }
    }

    @Override
    protected AlterHCSObjectHelper createModifyObjectsPropertiesHelper() {
        return new ModifyObjectsPropertiesHelper(this.getSchema(), this.getOriginalAndUpdatedTopDescObjects(), this.getDatabase(), this.getDiffProperty(), HCSSyntaxType.HIERARCHY){

            @Override
            public String getTitle() {
                return HCSArb.get("MODIFY_HIERARCHIES_PROPERTIES_TITLE");
            }

            @Override
            protected List<AbstractSchemaObjectWithDesc> getCompileDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
                return HCSObjectDependenciesGenerator.getHierarchyDependencies(string, oracleDatabaseImpl, string2);
            }
        };
    }

    @Override
    protected String getParentDescObjectName() {
        return null;
    }

    @Override
    protected Icon getTopObjectIcon() {
        return HCSNavigatorResource.getIcon("HIERARCHY_ICON");
    }

    @Override
    protected String getTableTitle() {
        if (this.getSelection().size() == 1) {
            return HCSArb.get("MODIFY_HIERARCHY_PROPS_TABLE_TITLE_LABEL");
        }
        return HCSArb.get("MODIFY_HIERARCHIES_PROPS_TABLE_TITLE_LABEL");
    }

    @Override
    protected String getDiffProperty() {
        return "hierarchies";
    }

    @Override
    protected String getParentObjectType() {
        return HIERARCHY_TYPE;
    }

    @Override
    protected String getProgressMessage() {
        return HCSArb.get("MODIFY_OBJS_PROPS_HIERS_PROGRESS_MSSG");
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        return new ConfirmModifyObjectsPropertiesPanel(this.getParentDescObjects(), this.getProvider(), this.tableTitle, this.getObjectTypesForView()){

            @Override
            protected Icon getRendererIcon(String string) {
                return ModifyHierarchiesPropertiesAction.this.getTopObjectIcon();
            }

            @Override
            protected Map<String, List<Descriptions>> getDescObjectsToPopulateModel(String string) {
                if (string.equals(HCSArb.get("MODIFY_HIERARCHIES_PROPS_ATTRIBUTES_VIEW"))) {
                    return ModifyHierarchiesPropertiesAction.this.attributesDescObjectsMap;
                }
                return ModifyHierarchiesPropertiesAction.this.getParentDescObjects();
            }
        };
    }

    @Override
    protected List<String> getObjectTypesForView() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getSelection().size() == 1) {
            arrayList.add(HCSArb.get("MODIFY_HIERARCHY_PROPS_HIER_VIEW"));
        } else {
            arrayList.add(HCSArb.get("MODIFY_HIERARCHIES_PROPS_HIERS_VIEW"));
        }
        return arrayList;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }
}

