/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ViewDataAction;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchyviewer.HierarchyET;
import oracle.hcs.hierarchyviewer.HierarchyViewerDialog;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HierarchyViewDataAction
extends ViewDataAction {
    private HierarchyViewerDialog dvdlg = null;
    private static final Logger LOG = Logger.getLogger(HierarchyViewDataAction.class.getName());
    private static Queries queries;
    private static final String XMLFILE = "/oracle/hcs/actions/actionsQueries.xml";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private static final String HIERARCHY_STATE_QUERY = "hierarchyState";
    private static final String COMPILE_OBJECT_SQL = "compileObject";
    private static final String OWNER = "OWNER";
    private static final String HIERARCHY_NAME = "HIERARCHY_NAME";
    private static final String INVALID = "INVALID";
    private HCSSchema schema;

    @Override
    public void showData(DBObject dBObject) throws Exception {
        this.showHierarchyViewerDialog(dBObject);
    }

    private void showHierarchyViewerDialog(DBObject dBObject) throws Exception {
        final Connection connection = dBObject.getConnection();
        final String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectType();
        final String string3 = dBObject.getObjectName();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        if (oracleDatabaseImpl != null) {
            DBUtil dBUtil = DBUtil.getInstance((Connection)oracleDatabaseImpl.getConnection());
            String string4 = String.format(this.getQuery(COMPILE_OBJECT_SQL), string2, string, string3);
            dBUtil.execute(string4);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(OWNER, string);
            hashMap.put(HIERARCHY_NAME, string3);
            String string5 = dBUtil.executeReturnOneCol(this.getQuery(HIERARCHY_STATE_QUERY), hashMap);
            if (string5 == null || string5.equalsIgnoreCase(INVALID)) {
                throw new Exception(HCSArb.format("HIERARCHY_DATA_VIEWER_INVALID_HIERARCHY", string3));
            }
            String string6 = HCSArb.getString("DATA_VIEWER_INITIALIZING_BUZY_BAR_TITLE");
            RaptorTask raptorTask = new RaptorTask(string6, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        String string4 = Connections.getInstance().getConnectionName(connection);
                        HierarchyViewDataAction.this.schema = HCSMetadataCache.getUpdatedSchema(string4, string);
                        this.setMessage(HCSArb.getString("HIERARCHY_DATA_VIEWER_READ_METADATA_MSG"));
                        Hierarchy hierarchy = HierarchyViewDataAction.this.schema.findHierarchy(string3);
                        HierarchyET hierarchyET = new HierarchyET(connection, hierarchy);
                        ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
                        arrayList.add(hierarchyET);
                        this.setMessage(HCSArb.getString("HIERARCHY_DATA_VIEWER_QUERYING_DATA_MSG"));
                        String string2 = String.format("'%s','%s'", hierarchy.getDimensionName(), hierarchy.getName());
                        List<String> list = HierarchyViewDataAction.this.getAvailableLanguageDescriptions(string2);
                        HierarchyViewDataAction.this.dvdlg = new HierarchyViewerDialog((Window)Ide.getMainWindow(), HCSArb.format("HIERARCHY_DATA_VIEWER_TITLE", string, string3), arrayList, string3, list, connection);
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            HierarchyViewDataAction.this.warn(throwable);
                            HierarchyViewDataAction.this.showErrorDialog(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (HierarchyViewDataAction.this.dvdlg != null) {
                                HierarchyViewDataAction.this.dvdlg.setModal(true);
                                HierarchyViewDataAction.this.dvdlg.setDefaultCloseOperation(2);
                                HierarchyViewDataAction.this.dvdlg.setMinimumSize(new Dimension(400, 400));
                                HierarchyViewDataAction.this.dvdlg.setLocationRelativeTo((Component)Ide.getMainWindow());
                                HierarchyViewDataAction.this.dvdlg.setVisible(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        HierarchyViewDataAction.queries = queries;
    }

    @Override
    protected String getErrorTitle() {
        return HCSArb.get("HIERARCHY_DATA_VIEWER_ERROR_TITLE");
    }
}

