/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.DropHCSObjectAction;
import oracle.hcs.actions.DropMultipleObjectsConfirmPanel;
import oracle.hcs.actions.XMLMultipleObjectsQueryBasedActionHelper;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.NamedObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.Ide;
import oracle.javatools.db.Database;

public class DropMultipleObjectsAction
extends DropHCSObjectAction {
    private static final String DROP_ATTRIBUTE_DIMENSION = "dropAttributeDimension";
    private static final String DROP_HIERARCHY = "dropHierarchy";
    private static final String DROP_ANALYTIC_VIEW = "dropAnalyticView";
    private List<DBObject> selection;
    private String dropPaneTitleLabel;
    private String confirmDropTableTitle;
    private String objectType;
    private HCSSyntaxType hcsSyntaxType;
    private String queryName;
    private String owner;
    private Connection conn;
    private List<NamedObjectWithDesc> namedObjects;
    private String successMsg;
    private static final Logger LOG = Logger.getLogger(DropMultipleObjectsAction.class.getName());

    private void initObjectsForDropAction(HCSSchema hCSSchema) {
        block4: {
            block5: {
                block3: {
                    this.namedObjects = new ArrayList<NamedObjectWithDesc>();
                    if (!this.objectType.equals("ATTRIBUTE DIMENSION")) break block3;
                    this.confirmDropTableTitle = HCSArb.get("MULTIPLE_ATTRIBUTE_DIMENSIONS_CONFIRM_TABLE_TITLE");
                    this.dropPaneTitleLabel = HCSArb.get("DROP_MULTIPLE_ATTRIBUTE_DIMENSIONS_TITLE");
                    this.hcsSyntaxType = HCSSyntaxType.DIMENSION;
                    this.queryName = DROP_ATTRIBUTE_DIMENSION;
                    this.successMsg = HCSArb.get("DROP_MULTIPLE_ATTRIBUTE_DIMENSIONS_SUCCESS_MSSG");
                    for (DBObject dBObject : this.selection) {
                        AttributeDimension attributeDimension = hCSSchema.findDimension(dBObject.getObjectName());
                        if (attributeDimension == null) continue;
                        this.namedObjects.add(attributeDimension);
                    }
                    break block4;
                }
                if (!this.objectType.equals("HIERARCHY")) break block5;
                this.confirmDropTableTitle = HCSArb.get("MULTIPLE_HIERARCHIES_CONFIRM_TABLE_TITLE");
                this.dropPaneTitleLabel = HCSArb.get("DROP_MULTIPLE_HIERARCHIES_TITLE");
                this.hcsSyntaxType = HCSSyntaxType.HIERARCHY;
                this.queryName = DROP_HIERARCHY;
                this.successMsg = HCSArb.get("DROP_MULTIPLE_HIERARCHIES_SUCCESS_MSSG");
                for (DBObject dBObject : this.selection) {
                    Hierarchy hierarchy = hCSSchema.findHierarchy(dBObject.getObjectName());
                    if (hierarchy == null) continue;
                    this.namedObjects.add(hierarchy);
                }
                break block4;
            }
            if (!this.objectType.equals("ANALYTIC VIEW")) break block4;
            this.confirmDropTableTitle = HCSArb.get("MULTIPLE_ANALYTIC_VIEWS_CONFIRM_TABLE_TITLE");
            this.dropPaneTitleLabel = HCSArb.get("DROP_MULTIPLE_ANALYTIC_VIEW_TITLE");
            this.hcsSyntaxType = HCSSyntaxType.ANALYTIC_VIEW;
            this.queryName = DROP_ANALYTIC_VIEW;
            this.successMsg = HCSArb.get("DROP_MULTIPLE_ANALYTIC_VIEWS_SUCCESS_MSSG");
            for (DBObject dBObject : this.selection) {
                AnalyticView analyticView = hCSSchema.findAV(dBObject.getObjectName());
                if (analyticView == null) continue;
                this.namedObjects.add(analyticView);
            }
        }
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        DropMultipleObjectsConfirmPanel dropMultipleObjectsConfirmPanel = null;
        if (this.namedObjects != null && !this.namedObjects.isEmpty()) {
            dropMultipleObjectsConfirmPanel = new DropMultipleObjectsConfirmPanel(this.namedObjects, this.owner, this.objectType, this.confirmDropTableTitle);
        }
        return dropMultipleObjectsConfirmPanel;
    }

    private void recordMetadataChanges(DBObject dBObject) {
        String string = Connections.getInstance().getConnectionName(this.conn);
        String string2 = dBObject.getObjectName();
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        linkedList.add(new MetadataChange(string2, string2, this.hcsSyntaxType, "DELETION"));
    }

    @Override
    protected void actionPostProcess() {
        if (this.selection != null && !this.selection.isEmpty()) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), this.successMsg, this.dropPaneTitleLabel, 1);
            String string = this.selection.get(0).getObjectType();
            this.refreshObjectsInNavigator(string, this.selection.get(0));
            for (DBObject dBObject : this.selection) {
                this.closeEditorForDroppedObjects(dBObject.getObjectName());
            }
        }
    }

    @Override
    protected void refreshParentObject(DBObject dBObject) {
        this.refreshNavigator(dBObject);
    }

    protected void refreshNavigator(DBObject dBObject) {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReloadParent(true);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        objectActionPostProcess.run();
    }

    @Override
    protected AlterHCSObjectHelper getHelper() throws Exception {
        if (this.selection != null && !this.selection.isEmpty()) {
            DBObject dBObject = this.selection.get(0);
            this.conn = dBObject.getConnection();
            this.objectType = dBObject.getObjectType();
            this.owner = dBObject.getSchemaName();
            Database database = dBObject.getDatabase();
            HCSSchema hCSSchema = this.getSchema();
            this.initObjectsForDropAction(hCSSchema);
            this.actionHelper = new DropMultipleObjectsHelper(this.selection, this.conn, database);
        }
        return this.actionHelper;
    }

    protected void setSelection(List<DBObject> list) {
        this.selection = list;
    }

    private class DropMultipleObjectsHelper
    extends XMLMultipleObjectsQueryBasedActionHelper {
        public DropMultipleObjectsHelper(List<DBObject> list, Connection connection, Database database) {
            super(list, connection, database);
        }

        @Override
        public String getTitle() {
            return DropMultipleObjectsAction.this.dropPaneTitleLabel;
        }

        @Override
        protected List<String> initSQLStatements() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DBObject dBObject : this.getDBObjectsList()) {
                String string = dBObject.getObjectName();
                String string2 = String.format(this.getQuery(DropMultipleObjectsAction.this.queryName), dBObject.getSchemaName(), string);
                arrayList.add(string2);
            }
            return arrayList;
        }
    }
}

