/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.List;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractDropMeasureAction;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.metadata.HCSSchema;
import oracle.ide.model.Node;

public class DropMeasureAction
extends AbstractDropMeasureAction {
    public static final String ANALYTIC_VIEW_NAME = "ANALYTIC_VIEW_NAME";
    private HCSSchema schema;

    @Override
    protected String getAVName() {
        String string = null;
        if (this.getDBObject().getNode() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)this.getDBObject().getNode();
            string = (String)objectNode.getProperty(ANALYTIC_VIEW_NAME);
        }
        return string;
    }

    @Override
    protected AVBaseMeasure getMeasure() {
        AVMeasure aVMeasure = null;
        try {
            Node node = this.getDBObject().getNode();
            String string = this.getAVName();
            String string2 = String.valueOf(node.getData());
            AnalyticView analyticView = this.schema.findAV(string);
            aVMeasure = analyticView.findMeasure(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return aVMeasure;
    }

    @Override
    protected String getTitle(String string) {
        return HCSArb.format("DROP_MEASURE_TITLE", string);
    }

    @Override
    protected String getProgressMessage() {
        return HCSArb.getString("DROP_MEASURE_ACTION_PROGRESSBAR_TITLE");
    }

    @Override
    public String getDropMeasureLabel(String string) {
        return HCSArb.format("DROP_MEASURE_NOTIFICATION", string);
    }

    @Override
    public String getDropMeasureConfirmation(String string) {
        return HCSArb.format("DROP_MEASURE_CONFIRMATION", string);
    }

    @Override
    public String getType() {
        return "BASE";
    }

    @Override
    protected boolean isDialogActionValid() {
        Node node = this.getDBObject().getNode();
        String string = this.getAVName();
        this.schema = this.getSchema();
        String string2 = String.valueOf(node.getData());
        AnalyticView analyticView = this.schema.findAV(string);
        AVMeasure aVMeasure = analyticView.findMeasure(string2);
        List<AVMeasure> list = analyticView.getMeasuresList();
        if (list.size() == 1 && aVMeasure != null) {
            String string3 = HCSArb.get("DROP_MEASURE_ERROR_CANNOT_DROP_LAST_MEASURE");
            this.showErrorDialog(string3, aVMeasure.getName());
            return false;
        }
        return true;
    }
}

