/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.util.UIStringUtils;

public class ConfirmRenamePanel
extends ActionConfirmPanel {
    private String owner;
    private String currentName;
    private JTextField oldName;
    private JTextField newName;
    private JTextField ownerName;

    public ConfirmRenamePanel(String string, String string2) {
        this.owner = string;
        this.currentName = string2;
        this.layoutComponents();
        this.initializeFields();
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.setName("renamePromptPanel");
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JLabel jLabel = new JLabel(HCSArb.getString("RENAME_DIALOG_OWNER_LABEL"));
        jLabel.setName("lblOwner");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.ownerName = new JTextField(1024);
        this.ownerName.setName("ownerName");
        this.ownerName.setMinimumSize(new Dimension(250, 20));
        this.add((Component)this.ownerName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel(HCSArb.getString("DESCRIPTION_PANEL_NAME_LABEL"));
        jLabel2.setName("lblOldName");
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.oldName = new JTextField(1024);
        this.oldName.setName("oldName");
        this.oldName.setMinimumSize(new Dimension(250, 20));
        this.add((Component)this.oldName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = new JLabel(HCSArb.format("RENAME_DIALOG_NEW_NAME_LABEL", new Object[0]));
        jLabel3.setName("lblNewName");
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.newName = new JTextField(1024);
        this.newName.setName("newName");
        this.newName.setMinimumSize(new Dimension(250, 20));
        this.add((Component)this.newName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void initializeFields() {
        this.ownerName.setText(this.owner);
        this.ownerName.setEditable(false);
        this.oldName.setText(this.currentName);
        this.oldName.setEditable(false);
    }

    @Override
    public void commitPanel() {
        String string = this.newName.getText();
        if (!string.isEmpty() && !UIStringUtils.isQuotedName(string)) {
            string = string.toUpperCase();
            this.newName.setText(string);
        }
    }

    public String getNewName() {
        return this.newName.getText();
    }

    public String getOldName() {
        return this.oldName.getText();
    }
}

