/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.DescriptionsNode;
import oracle.hcs.actions.ModifyObjectsPropertiesTreeTableModel;
import oracle.hcs.av.panels.MeasureFormatsRenderer;
import oracle.hcs.db.DatabaseUtils;
import oracle.hcs.db.model.Classification;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.util.TreeSelectionRenderer;
import oracle.hcs.util.TreeSelectorFilter;
import oracle.hcs.util.TreeSelectorToolTip;
import oracle.hcs.util.UIStringUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.treetable.JFastTreeTable;

public class ConfirmModifyObjectsPropertiesPanel
extends ActionConfirmPanel {
    private TreeSelectorFilter filter;
    private SearchField searchField;
    private JFastTreeTable treeTable;
    private TreeSelectionRenderer treeRenderer;
    private TreeSelectorToolTip treeSelectorToolTip;
    private Map<String, List<Descriptions>> parentDescObjects;
    private final int CLASS_TYPE_COLUMN = 0;
    private final int CLASS_VALUE_COLUMN = 1;
    private final String FORMAT_STRING = "FORMAT_STRING";
    private JTree jTree;
    private String tableTitle;
    private AbstractAction addClassificationAction;
    private AbstractAction removeClassificationAction;
    private DBObjectProvider prov;
    private boolean isObjectValid;
    private JComboBox objectTypesCombo;
    private String currentComboValue;
    private List<String> objectTypes;
    private Map<String, ModifyObjectsPropertiesTreeTableModel> cachedTreeModels;

    public ConfirmModifyObjectsPropertiesPanel(Map<String, List<Descriptions>> map, DBObjectProvider dBObjectProvider, String string, List<String> list) {
        this.tableTitle = string;
        this.parentDescObjects = map;
        this.prov = dBObjectProvider;
        this.isObjectValid = true;
        this.objectTypes = list;
        this.initComponents();
        this.setLayoutComponents();
    }

    public void initComponents() {
        List<String> list;
        this.initObjectTypesComboBox(this.objectTypes);
        this.currentComboValue = (String)this.objectTypesCombo.getSelectedItem();
        this.initCachedTreeModels();
        ModifyObjectsPropertiesTreeTableModel modifyObjectsPropertiesTreeTableModel = this.cachedTreeModels.get(this.currentComboValue);
        this.createTreeTableFilter();
        this.treeTable = new JFastTreeTable(modifyObjectsPropertiesTreeTableModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                if (ConfirmModifyObjectsPropertiesPanel.this.treeSelectorToolTip != null) {
                    DescriptionsNode descriptionsNode;
                    int n = this.rowAtPoint(mouseEvent.getPoint());
                    JTree jTree = ConfirmModifyObjectsPropertiesPanel.this.treeTable.getTree();
                    TreePath treePath = jTree.getPathForRow(n);
                    if (treePath != null && !(descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent()).isParent()) {
                        string = ConfirmModifyObjectsPropertiesPanel.this.treeSelectorToolTip.getToolTipforNode(treePath.getLastPathComponent());
                    }
                }
                return string;
            }
        };
        this.treeSelectorToolTip = new TreeSelectorToolTip(){

            @Override
            public String getToolTipforNode(Object object) {
                String string = "";
                DescriptionsNode descriptionsNode = (DescriptionsNode)object;
                if (!descriptionsNode.isParent() && descriptionsNode.getClassification() != null) {
                    String string2 = descriptionsNode.getClassificationType();
                    if (string2.equals(HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL"))) {
                        string = HCSArb.format("MODIFY_OBJECTS_PROPS_CLASSIFICATION_CANNOT_BE_REMOVED_MSSG", HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL"));
                    } else if (string2.equals(HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"))) {
                        string = HCSArb.format("MODIFY_OBJECTS_PROPS_CLASSIFICATION_CANNOT_BE_REMOVED_MSSG", HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"));
                    }
                }
                return string;
            }
        };
        this.treeTable.setAutoResizeMode(4);
        this.treeTable.setCellSelectionEnabled(false);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (40 == keyEvent.getKeyCode() || 38 == keyEvent.getKeyCode()) {
                    TreePath treePath = ConfirmModifyObjectsPropertiesPanel.this.jTree.getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    DescriptionsNode descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
                    ConfirmModifyObjectsPropertiesPanel.this.disableIcons(descriptionsNode);
                }
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                TreePath treePath = ConfirmModifyObjectsPropertiesPanel.this.jTree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                DescriptionsNode descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
                if (n < 13 && descriptionsNode.isTopObject() || n > 25 && n < 31 && !descriptionsNode.isTopObject()) {
                    if (ConfirmModifyObjectsPropertiesPanel.this.jTree.isExpanded(treePath)) {
                        ConfirmModifyObjectsPropertiesPanel.this.jTree.collapsePath(treePath);
                    } else {
                        ConfirmModifyObjectsPropertiesPanel.this.jTree.expandPath(treePath);
                    }
                }
                ConfirmModifyObjectsPropertiesPanel.this.disableIcons(descriptionsNode);
            }
        });
        this.jTree = this.treeTable.getTree();
        this.jTree.setEditable(true);
        this.treeRenderer = new ModifyObjectsPropertiesTreeRenderer();
        this.treeRenderer.setTreeTable((JTable)this.treeTable);
        this.jTree.setCellRenderer((TreeCellRenderer)((Object)this.treeRenderer));
        this.jTree.setRowHeight(this.treeTable.getRowHeight());
        this.jTree.setShowsRootHandles(true);
        this.searchField = new SearchField(SearchField.Style.FILTER);
        if (this.filter != null && (list = this.filter.getCategoriesFilter()) != null) {
            String string = HCSArb.get("MODIFY_OBJECTS_PROPS_NAME_COLUMN");
            String string2 = HCSArb.get("MODIFY_OBJECTS_PROPS_CLASSIFICATION_TYPE_COLUMN");
            this.searchField.addCategory(new SearchCategory(string));
            this.searchField.addCategory(new SearchCategory(string2));
        }
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                if (ConfirmModifyObjectsPropertiesPanel.this.filter != null) {
                    SearchCategory searchCategory = searchEvent.getSearchCategory();
                    String string = "";
                    if (searchCategory != null) {
                        string = searchCategory.getLabel();
                    }
                    ConfirmModifyObjectsPropertiesPanel.this.filter.filterChanged(searchEvent.getSearchText(), string);
                    ConfirmModifyObjectsPropertiesPanel.this.updateTreeTableUI();
                    ConfirmModifyObjectsPropertiesPanel.this.expandTree(null);
                    ConfirmModifyObjectsPropertiesPanel.this.setFirstTreeNodeSelected();
                }
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.searchField.setTypingDelay(SearchField.TypingDelay.SLOW);
        if (this.treeTable.getRowCount() == 0) {
            this.treeTable.setEnabled(false);
        }
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            this.jTree.expandRow(i);
        }
        this.jTree.setRootVisible(false);
        this.treeTable.setKeySearchNavigable(true);
        this.setModelColumns();
        this.setFirstTreeNodeSelected();
    }

    private void disableIcons(DescriptionsNode descriptionsNode) {
        int n = this.objectTypesCombo.getSelectedIndex();
        if (n != 0 && descriptionsNode.isTopObject()) {
            this.addClassificationAction.setEnabled(false);
            this.removeClassificationAction.setEnabled(false);
        } else {
            this.addClassificationAction.setEnabled(true);
            this.removeClassificationAction.setEnabled(true);
        }
    }

    private void createTreeTableFilter() {
        this.filter = new TreeSelectorFilter(){

            @Override
            public void filterChanged(String string, String string2) {
                ModifyObjectsPropertiesTreeTableModel modifyObjectsPropertiesTreeTableModel = ConfirmModifyObjectsPropertiesPanel.this.cachedTreeModels.get(ConfirmModifyObjectsPropertiesPanel.this.currentComboValue);
                modifyObjectsPropertiesTreeTableModel.storeNewDescObjectsWithNewClassifications((DescriptionsNode)modifyObjectsPropertiesTreeTableModel.getRoot());
                modifyObjectsPropertiesTreeTableModel.clear();
                String string3 = (String)ConfirmModifyObjectsPropertiesPanel.this.objectTypesCombo.getSelectedItem();
                Map<String, List<Descriptions>> map = ConfirmModifyObjectsPropertiesPanel.this.getDescObjectsToPopulateModel(string3);
                boolean bl = false;
                if (ConfirmModifyObjectsPropertiesPanel.this.objectTypesCombo.getSelectedIndex() == 0) {
                    bl = true;
                }
                modifyObjectsPropertiesTreeTableModel.filterModel(string, string2, map, bl);
                ConfirmModifyObjectsPropertiesPanel.this.jTree.setModel(null);
                ConfirmModifyObjectsPropertiesPanel.this.jTree.setModel((TreeModel)((Object)modifyObjectsPropertiesTreeTableModel));
            }

            @Override
            public String getName() {
                return HCSArb.get("MODIFY_OBJECT_PROPERTIES_FILTER_LABEL");
            }

            @Override
            public List<String> getCategoriesFilter() {
                ArrayList<String> arrayList = new ArrayList<String>();
                ModifyObjectsPropertiesTreeTableModel modifyObjectsPropertiesTreeTableModel = (ModifyObjectsPropertiesTreeTableModel)((Object)ConfirmModifyObjectsPropertiesPanel.this.jTree.getModel());
                for (int i = 0; i < modifyObjectsPropertiesTreeTableModel.getColumnCount(); ++i) {
                    arrayList.add(modifyObjectsPropertiesTreeTableModel.getColumnName(i));
                }
                return arrayList;
            }
        };
    }

    private void initCachedTreeModels() {
        this.cachedTreeModels = new HashMap<String, ModifyObjectsPropertiesTreeTableModel>();
        ModifyObjectsPropertiesTreeTableModel modifyObjectsPropertiesTreeTableModel = null;
        for (int i = 0; i < this.objectTypes.size(); ++i) {
            String string = this.objectTypes.get(i);
            Map<String, List<Descriptions>> map = this.getDescObjectsToPopulateModel(string);
            modifyObjectsPropertiesTreeTableModel = new ModifyObjectsPropertiesTreeTableModel(this.prov, this.parentDescObjects, string);
            modifyObjectsPropertiesTreeTableModel.clear();
            if (i == 0) {
                modifyObjectsPropertiesTreeTableModel.populateParentDescObjects();
            } else {
                modifyObjectsPropertiesTreeTableModel.populateChildrenDescObjects(map);
            }
            if (this.cachedTreeModels.containsKey(string)) continue;
            this.cachedTreeModels.put(string, modifyObjectsPropertiesTreeTableModel);
        }
    }

    private void setModelColumns() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new ModifyObjectsPropertiesEditor());
        tableColumn.setCellRenderer(new ModifyObjectsPropertiesTableCellRenderer());
        tableColumn.setPreferredWidth(220);
        tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellEditor(new ModifyObjectsPropertiesEditor());
        tableColumn.setPreferredWidth(220);
    }

    @Override
    public void commitPanel() {
        this.stopTreeTableCellEditing();
    }

    private void stopTreeTableCellEditing() {
        TableCellEditor tableCellEditor = this.treeTable.getCellEditor();
        if (this.treeTable.isEditing()) {
            tableCellEditor.stopCellEditing();
        }
    }

    public void setLayoutComponents() {
        JComponent jComponent;
        this.setLayout(new GridBagLayout());
        if (this.filter != null) {
            jComponent = new JLabel(this.filter.getName());
            this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(7, 5, 5, 5), 0, 0));
            this.add((Component)this.searchField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(5, 5, 7, 5), 0, 0));
        }
        this.add((Component)new JLabel(HCSArb.get("MODIFY_OBJS_PROPS_OBJECT_TYPES_LABEL")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.objectTypesCombo, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        jComponent = new JScrollPane((Component)this.treeTable);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(this.tableTitle));
        componentWithTitlebar.setComponent(jComponent);
        componentWithTitlebar.setControlBar(new ControlBar());
        ControlBar controlBar = componentWithTitlebar.getControlBar();
        this.addClassificationAction((JToolBar)controlBar);
        this.removeClassificationAction((JToolBar)controlBar);
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, 3, 2, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void addClassificationAction(JToolBar jToolBar) {
        this.addClassificationAction = new AbstractAction("Run", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = ConfirmModifyObjectsPropertiesPanel.this.jTree.getSelectionPaths();
                if (treePathArray == null || treePathArray.length > 1) {
                    return;
                }
                TreePath treePath = treePathArray[0];
                DescriptionsNode descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
                if (!descriptionsNode.isParent()) {
                    treePath = treePath.getParentPath();
                    descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
                }
                List<Classification> list = ConfirmModifyObjectsPropertiesPanel.this.getClassificationsToCompare(descriptionsNode.getParentDescriptionObject());
                String string = ConfirmModifyObjectsPropertiesPanel.this.generateNewClassificationType(list);
                Classification classification = new Classification(string, "", null);
                descriptionsNode.addDescriptionsNode(classification, descriptionsNode.getParentDescriptionObject(), true);
                Descriptions descriptions = descriptionsNode.getParentDescriptionObject();
                if (descriptions != null) {
                    descriptions.addClassification(classification);
                }
                ConfirmModifyObjectsPropertiesPanel.this.expandTree(treePath);
                int n = descriptionsNode.getChildren().size();
                DescriptionsNode descriptionsNode2 = (DescriptionsNode)descriptionsNode.getChildren().get(n - 1);
                ConfirmModifyObjectsPropertiesPanel.this.setFocusOnLastInsertedNode(treePath, descriptionsNode2);
            }
        };
        this.addClassificationAction.putValue("ShortDescription", HCSArb.get("MODIFY_OBJECTS_PROPS_TOOLTIP_ADD_CLASSIFICATION"));
        jToolBar.add(this.addClassificationAction);
    }

    private void removeClassificationAction(JToolBar jToolBar) {
        this.removeClassificationAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = ConfirmModifyObjectsPropertiesPanel.this.jTree.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                ConfirmModifyObjectsPropertiesPanel.this.stopTreeTableCellEditing();
                List<TreePath> list = ConfirmModifyObjectsPropertiesPanel.this.getPathsToDelete(treePathArray);
                for (TreePath treePath : list) {
                    int n;
                    int n2;
                    int n3;
                    DescriptionsNode descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
                    String string = "";
                    if (descriptionsNode.getClassification() != null) {
                        string = descriptionsNode.getClassification().getClassificationType();
                    }
                    DescriptionsNode descriptionsNode2 = (DescriptionsNode)treePath.getParentPath().getLastPathComponent();
                    descriptionsNode2.removeDescriptionsNode(descriptionsNode);
                    Classification classification = descriptionsNode.getClassification();
                    Descriptions descriptions = descriptionsNode.getParentDescriptionObject();
                    if (descriptions != null) {
                        descriptions.removeClassifications(classification);
                    }
                    if ((n3 = (n2 = ConfirmModifyObjectsPropertiesPanel.this.jTree.getRowForPath(treePath)) + 1) >= (n = ConfirmModifyObjectsPropertiesPanel.this.treeTable.getRowCount())) {
                        n3 = n - list.size() - 1;
                    }
                    ConfirmModifyObjectsPropertiesPanel.this.treeTable.changeSelection(n3, 0, false, false);
                    ConfirmModifyObjectsPropertiesPanel.this.treeTable.requestFocus();
                }
                ConfirmModifyObjectsPropertiesPanel.this.updateTreeTableUI();
            }
        };
        this.removeClassificationAction.putValue("ShortDescription", HCSArb.format("MODIFY_OBJECTS_PROPS_TOOLTIP_REMOVE_CLASSIFICATION", new Object[0]));
        jToolBar.add(this.removeClassificationAction);
    }

    private List<TreePath> getPathsToDelete(TreePath[] treePathArray) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            DescriptionsNode descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
            String string = "";
            if (descriptionsNode.getClassification() != null) {
                string = descriptionsNode.getClassification().getClassificationType();
            }
            if (descriptionsNode.isParent() || descriptionsNode.isRoot() || string.equals(HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL")) || string.equals(HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"))) continue;
            arrayList.add(treePath);
        }
        return arrayList;
    }

    private void setFocusOnLastInsertedNode(final TreePath treePath, final DescriptionsNode descriptionsNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                TreePath treePath2 = treePath.pathByAddingChild(descriptionsNode);
                if (!ConfirmModifyObjectsPropertiesPanel.this.jTree.isVisible(treePath2)) {
                    ConfirmModifyObjectsPropertiesPanel.this.jTree.makeVisible(treePath2);
                }
                if ((n = ConfirmModifyObjectsPropertiesPanel.this.jTree.getRowForPath(treePath2)) != -1) {
                    ConfirmModifyObjectsPropertiesPanel.this.treeTable.changeSelection(n, 0, false, false);
                    ConfirmModifyObjectsPropertiesPanel.this.treeTable.editCellAt(n, 0);
                    ConfirmModifyObjectsPropertiesPanel.this.treeTable.transferFocus();
                }
            }
        });
        this.updateTreeTableUI();
    }

    private void initObjectTypesComboBox(List<String> list) {
        this.objectTypesCombo = new JComboBox();
        for (String string : list) {
            this.objectTypesCombo.addItem(string);
        }
        this.objectTypesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ConfirmModifyObjectsPropertiesPanel.this.objectTypesCombo.getSelectedItem();
                ConfirmModifyObjectsPropertiesPanel.this.stopTreeTableCellEditing();
                if (ConfirmModifyObjectsPropertiesPanel.this.cachedTreeModels.containsKey(string)) {
                    ModifyObjectsPropertiesTreeTableModel modifyObjectsPropertiesTreeTableModel = ConfirmModifyObjectsPropertiesPanel.this.cachedTreeModels.get(string);
                    String string2 = modifyObjectsPropertiesTreeTableModel.getViewFilter();
                    ConfirmModifyObjectsPropertiesPanel.this.searchField.setText(string2);
                    ConfirmModifyObjectsPropertiesPanel.this.jTree.setModel(null);
                    ConfirmModifyObjectsPropertiesPanel.this.jTree.setModel((TreeModel)((Object)modifyObjectsPropertiesTreeTableModel));
                    ConfirmModifyObjectsPropertiesPanel.this.updateTreeTableUI();
                }
                ConfirmModifyObjectsPropertiesPanel.this.addClassificationAction.setEnabled(true);
                ConfirmModifyObjectsPropertiesPanel.this.removeClassificationAction.setEnabled(true);
                ConfirmModifyObjectsPropertiesPanel.this.currentComboValue = string;
                ConfirmModifyObjectsPropertiesPanel.this.expandTree(null);
                ConfirmModifyObjectsPropertiesPanel.this.setFirstTreeNodeSelected();
            }
        });
    }

    private void setFirstTreeNodeSelected() {
        TreePath treePath;
        int n = 0;
        int n2 = this.objectTypesCombo.getSelectedIndex();
        if (n2 != 0) {
            n = 1;
        }
        if ((treePath = this.jTree.getPathForRow(n)) != null) {
            this.jTree.setSelectionPath(treePath);
        }
    }

    protected Icon getRendererIcon(String string) {
        return null;
    }

    protected Map<String, List<Descriptions>> getDescObjectsToPopulateModel(String string) {
        return Collections.EMPTY_MAP;
    }

    protected boolean showFormatStringPropertyCombo(String string) {
        return false;
    }

    private void expandTree(TreePath treePath) {
        if (treePath != null) {
            if (!this.jTree.isExpanded(treePath)) {
                this.jTree.expandPath(treePath);
            }
        } else {
            for (int i = 0; i < this.jTree.getRowCount(); ++i) {
                this.jTree.expandRow(i);
            }
        }
    }

    private void updateTreeTableUI() {
        this.treeTable.updateUI();
    }

    private List<Classification> getClassificationsToCompare(Descriptions descriptions) {
        List<Classification> list;
        ArrayList<Classification> arrayList = new ArrayList<Classification>();
        if (descriptions.getCaption() != null) {
            arrayList.add(new Classification(HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL"), descriptions.getCaption(), null));
        }
        if (descriptions.getDescription() != null) {
            arrayList.add(new Classification(HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"), descriptions.getDescription(), null));
        }
        if ((list = Arrays.asList(descriptions.getClassifications())) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private String generateNewClassificationType(List<Classification> list) {
        int n = 1;
        String string = HCSArb.get("MODIFY_OBJECTS_PROPS_NEW_CLASSIFICATION_TYPE_PREFIX_NAME");
        while (this.isClassificationTypeDuplicate(String.format("%s%d", string, n), list, false)) {
            ++n;
        }
        return String.format("%s%d", string, n);
    }

    private boolean isClassificationTypeDuplicate(String string, List<Classification> list, boolean bl) {
        int n = 0;
        for (Classification classification : list) {
            String string2 = classification.getClassificationType();
            if (!string2.equals(string)) continue;
            ++n;
        }
        return n > 0 && !bl || n >= 2 && bl;
    }

    private class ModifyObjectsPropertiesTreeRenderer
    extends TreeSelectionRenderer {
        private int visibleRow;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DescriptionsNode descriptionsNode = (DescriptionsNode)object;
            if (descriptionsNode.isTopObject()) {
                String string = ConfirmModifyObjectsPropertiesPanel.this.objectTypes.get(0);
                this.setIcon(ConfirmModifyObjectsPropertiesPanel.this.getRendererIcon(string));
            } else if (!descriptionsNode.isTopObject() && descriptionsNode.isParent()) {
                this.setIcon(ConfirmModifyObjectsPropertiesPanel.this.getRendererIcon(ConfirmModifyObjectsPropertiesPanel.this.currentComboValue));
            } else if (descriptionsNode.isObjectNew()) {
                this.setIcon(OracleIcons.getIcon((String)"edit.png"));
            } else {
                this.setIcon(null);
            }
            return this;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.visibleRow = n;
            return this;
        }
    }

    private class ModifyObjectsPropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        JLabel label;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = (String)jTable.getValueAt(n, 0);
            if (component instanceof JLabel) {
                this.label = (JLabel)component;
                String string2 = (String)object;
                if (string2.isEmpty() && !string.equals("") && string.equals("FORMAT_STRING") && ConfirmModifyObjectsPropertiesPanel.this.showFormatStringPropertyCombo(ConfirmModifyObjectsPropertiesPanel.this.currentComboValue)) {
                    this.label.setText(HCSArb.get("MODIFY_BASE_MEASURES_PROPERTIES_SELECT_MEASURE_FORMAT"));
                    this.label.setEnabled(false);
                    this.label.setHorizontalTextPosition(2);
                    this.setCellIcon(OracleIcons.getIcon((String)"extras/dropdown.png"), n2, jTable, this.label.getText());
                } else {
                    this.label.setText((String)object);
                    this.label.setEnabled(true);
                    this.label.setIcon(null);
                }
            }
            return component;
        }

        private void setCellIcon(Icon icon, int n, JTable jTable, String string) {
            int n2 = this.getFontMetrics(this.getFont()).stringWidth(string);
            Insets insets = this.getInsets();
            int n3 = 0;
            int n4 = jTable.getColumnModel().getColumn(n).getWidth();
            this.label.setIcon(icon);
            n3 = n4 - n2 - this.label.getIcon().getIconWidth() - insets.left - insets.right - 5;
            this.label.setIconTextGap(n3);
        }
    }

    private class ModifyObjectsPropertiesEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox combo;
        private JTextField jTextField;
        private String classificationTypeCell;
        private int row;
        private int column;
        private JTable jTable;
        private String oldClassificationType;
        private String classTypeValue;
        private String errMsg;
        private String errMsgTitle = HCSArb.get("MODIFY_OBJECTS_PROPS_CLASSIFICATION_TYPE_ERROR_TITLE");

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.jTable = jTable;
            this.classificationTypeCell = (String)jTable.getValueAt(n, 0);
            boolean bl2 = jTable.isCellEditable(n, n2);
            this.oldClassificationType = this.classificationTypeCell;
            if (this.classificationTypeCell.equals("FORMAT_STRING") && ConfirmModifyObjectsPropertiesPanel.this.showFormatStringPropertyCombo(ConfirmModifyObjectsPropertiesPanel.this.currentComboValue) && this.column != 0) {
                this.combo = new JComboBox(){

                    @Override
                    public Object getSelectedItem() {
                        Object object = super.getSelectedItem();
                        if (object instanceof Object[]) {
                            Object[] objectArray = (Object[])object;
                            return objectArray[0];
                        }
                        return object;
                    }
                };
                this.combo.setRenderer(new MeasureFormatsRenderer());
                this.combo.setModel(new DefaultComboBoxModel((E[])DatabaseUtils.getMeasureNumericFormats()));
                this.combo.setEditable(true);
                String string = (String)jTable.getModel().getValueAt(n, n2);
                this.setComboValue(string);
                return this.combo;
            }
            if (!bl2) {
                return null;
            }
            this.jTextField = new JTextField();
            this.jTextField.setText((String)object);
            if (this.column == 0) {
                int n3 = 40;
                if (ConfirmModifyObjectsPropertiesPanel.this.objectTypesCombo.getSelectedIndex() > 0) {
                    n3 = 60;
                }
                this.jTextField.setBorder(BorderFactory.createEmptyBorder(0, n3, 0, 0));
            }
            return this.jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.classificationTypeCell.equals("FORMAT_STRING") && ConfirmModifyObjectsPropertiesPanel.this.showFormatStringPropertyCombo(ConfirmModifyObjectsPropertiesPanel.this.currentComboValue) && this.column != 0) {
                return this.combo.getSelectedItem();
            }
            return this.jTextField.getText();
        }

        @Override
        public boolean stopCellEditing() {
            ConfirmModifyObjectsPropertiesPanel.this.isObjectValid = true;
            if (this.column == 0) {
                this.classTypeValue = this.jTextField.getText();
                if (this.classTypeValue == null || this.classTypeValue.isEmpty()) {
                    ConfirmModifyObjectsPropertiesPanel.this.isObjectValid = false;
                    this.errMsg = HCSArb.get("MODIFY_OBJECTS_PROPS_EMPTY_CLASSIFICATION_TYPE_ERROR_MSSG");
                    this.showErrorMessage(this.errMsg, this.errMsgTitle);
                    return super.stopCellEditing();
                }
                try {
                    ConfirmModifyObjectsPropertiesPanel.this.prov.validateName("", this.classTypeValue);
                }
                catch (InvalidNameException invalidNameException) {
                    ConfirmModifyObjectsPropertiesPanel.this.isObjectValid = false;
                    if (this.column == 0) {
                        this.errMsg = HCSArb.get("MODIFY_OBJECTS_PROPS_CLASSIFICATION_TYPE_GENERAL_ERROR_MSSG");
                    }
                    this.showErrorMessage(this.errMsg, this.errMsgTitle);
                    return super.stopCellEditing();
                }
                this.classTypeValue = UIStringUtils.normalizeName(this.classTypeValue, ConfirmModifyObjectsPropertiesPanel.this.prov);
                if (!this.isCellValueValid()) {
                    ConfirmModifyObjectsPropertiesPanel.this.isObjectValid = false;
                    this.showErrorMessage(this.errMsg, this.errMsgTitle);
                    return super.stopCellEditing();
                }
                if (UIStringUtils.isQuotedName(this.classTypeValue)) {
                    this.classTypeValue = this.classTypeValue.toUpperCase();
                }
                this.jTextField.setText(this.classTypeValue);
                this.jTable.setValueAt(this.classTypeValue, this.row, this.column);
            } else if (this.column == 1 && this.classificationTypeCell.equals("FORMAT_STRING") && ConfirmModifyObjectsPropertiesPanel.this.showFormatStringPropertyCombo(ConfirmModifyObjectsPropertiesPanel.this.currentComboValue)) {
                String string = (String)this.combo.getEditor().getItem();
                this.setComboValue(string);
            }
            return super.stopCellEditing();
        }

        private void setComboValue(String string) {
            boolean bl = false;
            int n = this.combo.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])this.combo.getModel().getElementAt(i);
                if (!objectArray[0].equals(string)) continue;
                this.combo.setSelectedItem(objectArray);
                bl = true;
                break;
            }
            if (!bl) {
                this.combo.setSelectedItem(string);
            }
        }

        private boolean isCellValueValid() {
            TreePath treePath = ConfirmModifyObjectsPropertiesPanel.this.jTree.getPathForRow(this.row);
            String string = "";
            ArrayList<Classification> arrayList = new ArrayList();
            if (treePath != null) {
                DescriptionsNode descriptionsNode = (DescriptionsNode)treePath.getLastPathComponent();
                string = descriptionsNode.getParentObjName();
                arrayList = ConfirmModifyObjectsPropertiesPanel.this.getClassificationsToCompare(descriptionsNode.getParentDescriptionObject());
            }
            switch (this.column) {
                case 0: {
                    this.jTable.setValueAt(this.classTypeValue, this.row, this.column);
                    if (!ConfirmModifyObjectsPropertiesPanel.this.isClassificationTypeDuplicate(this.classTypeValue, arrayList, true)) break;
                    this.errMsg = HCSArb.format("MODIFY_OBJECTS_PROPS_DUPLICATED_CLASSIFICATION_TYPE_ERROR_MSSG", this.classTypeValue, string);
                    return false;
                }
            }
            return true;
        }

        private void showErrorMessage(String string, String string2) {
            MessageDialog.error((Component)ConfirmModifyObjectsPropertiesPanel.this, (Object)string, (String)string2, null);
            this.jTextField.setText(this.oldClassificationType);
            ConfirmModifyObjectsPropertiesPanel.this.isObjectValid = true;
        }
    }
}

