/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.HCSActionDDLPanel;
import oracle.hcs.actions.UpdatedObjectChangeListener;
import oracle.hcs.db.HCSExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class AlterHCSObjectDialog
extends JDialog
implements UpdatedObjectChangeListener {
    private HCSActionDDLPanel sqlPanel;
    private AlterHCSObjectHelper helper;
    private JTabbedPane tabs;
    private ActionConfirmPanel confirmPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private int selection;
    public static final int YES_SELECTION = 1;
    public static final int NO_SELECTION = 0;
    private static final int CONFIRM_PANEL_TAB = 0;
    private static final int SQL_TAB = 1;
    private String helpId;
    private JCheckBox forceCreate;
    private Logger Log = Logger.getLogger(AlterHCSObjectDialog.class.getName());
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";

    public AlterHCSObjectDialog(Frame frame, String string, ActionConfirmPanel actionConfirmPanel, AlterHCSObjectHelper alterHCSObjectHelper, String string2) {
        super(frame, string);
        this.helpId = string2;
        this.confirmPanel = actionConfirmPanel;
        this.helper = alterHCSObjectHelper;
        this.helper.setForceCreate(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.confirmPanel, string2);
        this.initComponents();
        this.layoutComponents();
        this.setDefaultCloseOperation(2);
        Dimension dimension = new Dimension(600, 450);
        this.setMinimumSize(dimension);
        this.setLocationRelativeTo(frame);
        this.registerKeyboardActions();
    }

    private void initComponents() {
        this.okButton = new JButton(HCSArb.getString("DROP_CASCADE_YES_CHOICE"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (AlterHCSObjectDialog.this.helper.isObjectValid()) {
                        AlterHCSObjectDialog.this.selection = 1;
                        AlterHCSObjectDialog.this.confirmPanel.commitPanel();
                        AlterHCSObjectDialog.this.helper.commitChanges();
                        AlterHCSObjectDialog.this.close();
                    } else {
                        AlterHCSObjectDialog.this.showErrorDialog(AlterHCSObjectDialog.this.helper.getErrorTitle(), AlterHCSObjectDialog.this.helper.getErrorMessage());
                    }
                }
                catch (Exception exception) {
                    AlterHCSObjectDialog.this.Log.log(Level.SEVERE, exception.getMessage());
                    AlterHCSObjectDialog.this.showErrorDialog(HCSArb.get("GENERIC_ERROR_TITLE"), exception.getMessage());
                }
            }
        });
        this.cancelButton = new JButton(HCSArb.getString("DROP_CASCADE_NO_CHOICE"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlterHCSObjectDialog.this.selection = 0;
                AlterHCSObjectDialog.this.close();
            }
        });
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)HCSArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp((JComponent)AlterHCSObjectDialog.this.confirmPanel);
            }
        });
        this.forceCreate = new JCheckBox(HCSArb.getString("FORCE_CREATE_DROP_RENAME"));
        if (!this.helper.isReadOnly()) {
            this.tabs = new JTabbedPane(){

                @Override
                public void setSelectedIndex(int n) {
                    if (n == 0 || AlterHCSObjectDialog.this.helper.isObjectValid()) {
                        super.setSelectedIndex(n);
                    } else {
                        AlterHCSObjectDialog.this.showErrorDialog(AlterHCSObjectDialog.this.helper.getErrorTitle(), AlterHCSObjectDialog.this.helper.getErrorMessage());
                    }
                }
            };
            this.tabs.add((Component)this.confirmPanel, HCSArb.getString("ALTER_HCS_DIALOG_CONFIRM_TAB_LABEL"));
            this.sqlPanel = new HCSActionDDLPanel();
            this.tabs.add((Component)this.sqlPanel, HCSArb.getString("ALTER_HCS_DIALOG_DDL_TAB_LABEL"));
            this.tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AlterHCSObjectDialog.this.tabs.getSelectedIndex() == 1) {
                        AlterHCSObjectDialog.this.confirmPanel.commitPanel();
                        AlterHCSObjectDialog.this.helper.refreshMetadataObjects(AlterHCSObjectDialog.this.confirmPanel.isCascadeActionToDependendentObjects());
                        AlterHCSObjectDialog.this.helper.clearSqlStatements();
                        AlterHCSObjectDialog.this.sqlPanel.setDDLText(AlterHCSObjectDialog.this.helper.getSQL());
                    }
                }
            });
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.forceCreate.setSelected(true);
        this.forceCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlterHCSObjectDialog.this.helper.setForceCreate(AlterHCSObjectDialog.this.forceCreate.isSelected());
                AlterHCSObjectDialog.this.helper.clearSqlStatements();
                AlterHCSObjectDialog.this.sqlPanel.setDDLText(AlterHCSObjectDialog.this.helper.getSQL());
            }
        });
        int n = 0;
        this.add((Component)this.forceCreate, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.helper.isReadOnly()) {
            this.add((Component)this.tabs, new GridBagConstraints(0, n, 1, 1, 0.5, 0.5, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        } else {
            this.add((Component)this.confirmPanel, new GridBagConstraints(0, n, 1, 1, 0.5, 0.5, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        }
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 5, 5));
    }

    public void setVisibleForceCreateOption(boolean bl) {
        this.forceCreate.setVisible(bl);
    }

    private void close() {
        this.dispose();
        this.setVisible(false);
    }

    public int getUserSelection() {
        return this.selection;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlterHCSObjectDialog.this.selection = 0;
                AlterHCSObjectDialog.this.close();
            }
        };
        jRootPane.registerKeyboardAction(actionListener, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp((JComponent)AlterHCSObjectDialog.this.confirmPanel);
            }
        };
        jRootPane.registerKeyboardAction(actionListener2, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
    }

    private void showErrorDialog(String string, String string2) {
        HCSExceptionHandler.handleException((Window)Ide.getMainWindow(), string, string2);
    }

    @Override
    public void objectDataChanged() {
        this.helper.clearDDL();
    }
}

