/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.jdeveloper.db.ConnectionInfo;

public abstract class ConnectionSelector {
    private static final List<ConnectionSelector> m_selectors = new CopyOnWriteArrayList<ConnectionSelector>();

    public static void registerSelector(ConnectionSelector connectionSelector) {
        m_selectors.add(0, connectionSelector);
    }

    public static boolean selectConnection(final ConnectionInfo connectionInfo, final Context context, final boolean bl) {
        boolean bl2 = false;
        if (connectionInfo.getStoreName() != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                bl2 = ConnectionSelector.selectConnectionImpl(connectionInfo, context, bl);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionSelector.selectConnectionImpl(connectionInfo, context, bl);
                    }
                });
            }
        }
        return bl2;
    }

    private static boolean selectConnectionImpl(ConnectionInfo connectionInfo, Context context, boolean bl) {
        boolean bl2 = false;
        for (ConnectionSelector connectionSelector : m_selectors) {
            if (!connectionSelector.findAndSelectConnection(connectionInfo, context, bl)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public abstract boolean findAndSelectConnection(ConnectionInfo var1, Context var2, boolean var3);
}

