/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.explorer;

import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.JDBCParametersParser;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class DBConnectionExplorer
extends Explorer {
    private final JTree m_tree = new JTree();
    private final JScrollPane m_gui = new JScrollPane(this.m_tree);
    private final ConnectionsListener m_listener;
    private DatabaseConnections m_store;
    private ConnectionInfo m_current;

    public DBConnectionExplorer() {
        this.m_tree.setCellRenderer(new DBCRend());
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_listener = new ConnectionsListener(){

            @Override
            public void connectionAdded(ConnectionsEvent connectionsEvent) {
            }

            @Override
            public void connectionRemoved(ConnectionsEvent connectionsEvent) {
            }

            @Override
            public void connectionUpdated(ConnectionsEvent connectionsEvent) {
                ConnectionInfo connectionInfo = DBConnectionExplorer.this.m_current;
                if (connectionInfo != null && ModelUtil.areEqual((Object)connectionInfo.getConnectionName(), (Object)connectionsEvent.getName())) {
                    DBConnectionExplorer.this.setConnectionInfo(connectionInfo);
                }
            }
        };
    }

    public void stateChanged(int n) {
        DatabaseConnections databaseConnections = this.m_store;
        if (n != 0 && databaseConnections != null) {
            databaseConnections.removeListener(this.m_listener);
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        ConnectionInfo connectionInfo = databaseConnectionStores.getCurrentConnectionInfo(context);
        this.setConnectionInfo(connectionInfo);
        if (connectionInfo != null) {
            this.m_store = databaseConnectionStores.getStore(connectionInfo.getStoreName());
            this.m_store.addListener(this.m_listener);
        }
    }

    private void setConnectionInfo(ConnectionInfo connectionInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.m_current = connectionInfo;
        if (connectionInfo == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("");
        } else {
            Properties properties;
            defaultMutableTreeNode = new DefaultMutableTreeNode(connectionInfo.getConnectionName());
            DatabaseProvider databaseProvider = connectionInfo.getReferenceable();
            if (databaseProvider != null && (properties = databaseProvider.getProperties()) != null) {
                Object object;
                DatabaseConnectionHook.ConnectionType connectionType4;
                String string = properties.getProperty("subtype");
                DatabaseConnectionHook.ConnectionType connectionType2 = null;
                DatabaseConnectionHook.ConnectionType connectionType3 = null;
                for (DatabaseConnectionHook.ConnectionType connectionType4 : DatabaseConnectionHook.getHook().getConnectionTypes()) {
                    object = connectionType4.getSubtype();
                    if (ModelUtil.hasLength((String)string) && string.equals(object)) {
                        connectionType2 = connectionType4;
                    }
                    if (!"thirdParty".equals(object)) continue;
                    connectionType3 = connectionType4;
                }
                Iterator<DatabaseConnectionHook.ConnectionType> iterator = connectionType2 == null ? connectionType3 : connectionType2;
                Object object2 = connectionType4 = iterator == null ? null : ((DatabaseConnectionHook.ConnectionType)((Object)iterator)).getConnectionCreator();
                if (connectionType4 != null) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(((DatabaseConnectionHook.ConnectionType)((Object)iterator)).getPropertyDisplayName("subtype") + " : " + (connectionType2 == null ? string : connectionType2.getDisplayName())));
                    object = properties.stringPropertyNames();
                    object.remove("subtype");
                    object.remove("password");
                    object.remove("SavePassword");
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        if (!connectionType4.isPassword((String)iterator2.next())) continue;
                        iterator2.remove();
                    }
                    for (DefaultMutableTreeNode defaultMutableTreeNode2 : this.getPropertyNodes(properties, (Set<String>)object, (DatabaseConnectionHook.ConnectionType)((Object)iterator))) {
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    }
                }
            }
        }
        this.m_tree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        for (int i = 0; i < this.m_tree.getRowCount(); ++i) {
            this.m_tree.expandRow(i);
        }
    }

    private Collection<DefaultMutableTreeNode> getPropertyNodes(Properties properties, Set<String> set, DatabaseConnectionHook.ConnectionType connectionType) {
        TreeSet<DefaultMutableTreeNode> treeSet = new TreeSet<DefaultMutableTreeNode>(new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
                return String.valueOf(defaultMutableTreeNode).compareTo(String.valueOf(defaultMutableTreeNode2));
            }
        });
        for (String string : set) {
            String string2 = connectionType.getPropertyDisplayName(string);
            String string3 = properties.getProperty(string);
            if (!ModelUtil.hasLength((String)string3)) continue;
            if ("parameters".equals(string)) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
                Properties properties2 = new Properties();
                JDBCParametersParser.parseParameterString((String)string3, (Properties)properties2);
                for (String string4 : properties2.stringPropertyNames()) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(string4 + " = " + properties2.getProperty(string4)));
                }
                treeSet.add(defaultMutableTreeNode);
                continue;
            }
            treeSet.add(new DefaultMutableTreeNode(string2 + " : " + string3));
        }
        return treeSet;
    }

    public Component getGUI() {
        return this.m_gui;
    }

    private static class DBCRend
    extends DefaultTreeCellRenderer {
        DBCRend() {
            this.setLeafIcon(OracleIcons.getIcon((String)"properties.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (n == 0) {
                jLabel.setIcon(OracleIcons.getIcon((String)"database.png"));
            }
            return jLabel;
        }
    }
}

