/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import javax.swing.SwingUtilities;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DatabaseFinder
extends ProgressRunnable {
    private String m_connString;
    private Database m_db;
    private DBException m_exception;

    public static Database findDatabase(String string) {
        Database database = (Database)DBObjectProviderFactory.findProvider((String)"db", (Object)string);
        if (database == null) {
            DatabaseFinder databaseFinder = new DatabaseFinder(string);
            database = databaseFinder.getDatabase(true);
        }
        return database;
    }

    public static Database findDatabaseEx(String string) throws DBException {
        Database database = null;
        if (string != null && (database = (Database)DBObjectProviderFactory.findProvider((String)"db", (Object)string)) == null) {
            DatabaseFinder databaseFinder = new DatabaseFinder(string);
            database = databaseFinder.getDatabase(false);
            if (databaseFinder.m_exception != null) {
                throw databaseFinder.m_exception;
            }
        }
        return database;
    }

    private DatabaseFinder(String string) {
        this.setTitle(ConnBundle.get("TITLE_CONNECTING"));
        this.setMessage(ConnBundle.format("MESSAGE_CONNECTING", DatabaseFactory.decodeIdentifier((String)string)[1]));
        this.m_connString = string;
    }

    protected Object doWork() {
        try {
            this.m_db = (Database)DBObjectProviderFactory.findOrCreateProvider((String)"db", (Object)this.m_connString);
        }
        catch (DBException dBException) {
            this.m_exception = dBException;
        }
        return null;
    }

    private Database getDatabase(boolean bl) {
        if (this.m_db == null) {
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException progressException) {
                DBLog.getLogger((Object)((Object)this)).log(DBLog.getExceptionLogLevel(), "Error running connection progress bar", progressException.getCause());
            }
        }
        if (bl && this.m_exception != null) {
            this.reportError(this.m_exception);
        }
        return this.m_db;
    }

    private void reportError(final DBException dBException) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = ConnBundle.get("ERROR_CONNECTING");
                DBExceptionDialog.showErrorDialog(null, (String)string, (DBException)dBException);
            }
        });
    }

    protected int getProgressShowDelay() {
        return 1000;
    }
}

