/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.Context;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class StorePicker
extends JComboBox {
    private final DefaultComboBoxModel m_model = (DefaultComboBoxModel)this.getModel();
    private final Context m_ideContext;

    public StorePicker() {
        this((Context)null);
    }

    public StorePicker(Context context) {
        super(new NonNullableComboBoxModel());
        this.m_ideContext = context;
        for (String string : this.listStores()) {
            this.m_model.addElement(string);
        }
        final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                object = StorePicker.this.getShortLabel(string);
                JLabel jLabel = (JLabel)defaultListCellRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setIcon(StorePicker.this.getIcon(string));
                return jLabel;
            }
        });
    }

    protected String getShortLabel(String string) {
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        return databaseConnectionStores.getShortLabel(string);
    }

    protected Icon getIcon(String string) {
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        return databaseConnectionStores.getIcon(string);
    }

    public String getStore() {
        return (String)this.m_model.getSelectedItem();
    }

    public boolean setStore(String string) {
        if (this.m_model.getIndexOf(string) >= 0) {
            this.m_model.setSelectedItem(string);
            return true;
        }
        return false;
    }

    protected Collection<String> listStores() {
        return DatabaseConnectionStores.getInstance().listStores(this.m_ideContext);
    }

    protected final Context getContext() {
        return this.m_ideContext;
    }

    public void addItem(Object object) {
        throw new UnsupportedOperationException();
    }
}

