/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnresolvedIdentifier;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.syntax.parser.IdentifierResolver;

public final class UnresolvedMetadataObjectReference
extends BaseMetadataObjectReference
implements UnresolvedIdentifier {
    private Identifier m_Identifier = null;
    private IdentifierResolver m_IDResolver = null;
    private int m_MinNumComps;
    private int m_MaxNumComps;

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedMetadataObjectReference(this, object);
    }

    final int getMinNumComps() {
        return this.m_MinNumComps;
    }

    final int getMaxNumComps() {
        return this.m_MaxNumComps;
    }

    boolean isValidReference() {
        return this.getIDResolver().fullyQualifyObjectID(new Identifier(this.getIdentifier()), this.getMinNumComps(), this.getMaxNumComps(), false, this.getObjectType());
    }

    @Override
    public final Identifier getIdentifier() {
        return this.m_Identifier;
    }

    @Override
    public final BaseMetadataObject getBaseMetadataObject() {
        throw new SyntaxException("InvalidIdentifier", this.getIdentifier().toString());
    }

    @Override
    public final IdentifierResolver getIDResolver() {
        return this.m_IDResolver;
    }

    public UnresolvedMetadataObjectReference(Identifier identifier, IdentifierResolver identifierResolver, int n, Class clazz) {
        this(identifier, identifierResolver, n, n, clazz);
    }

    public UnresolvedMetadataObjectReference(Identifier identifier, IdentifierResolver identifierResolver, int n, int n2, Class clazz) {
        super(clazz);
        this.m_IDResolver = identifierResolver;
        this.m_Identifier = identifier;
        this.m_MinNumComps = n;
        this.m_MaxNumComps = n2;
        this.initialize();
    }

    @Override
    public final String getName() {
        return this.getIdentifier().getName();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getIdentifier().toString());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        Class clazz = this.getObjectType();
        MdmObject mdmObject = this.getIDResolver().getMdmObjectAndID(this.getIdentifier(), this.getMinNumComps(), this.getMaxNumComps(), clazz);
        if (null != mdmObject) {
            return new MetadataObjectReference(mdmObject, clazz);
        }
        validationContext.addUnresolvedID(this);
        return this;
    }
}

