/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class HierarchicalCondition
extends Condition {
    public static final String PARENT = "PARENT";
    public static final String CHILD = "CHILD";
    public static final String ANCESTOR = "ANCESTOR";
    public static final String ROOT_ANCESTOR = "ROOT_ANCESTOR";
    public static final String DESCENDANT = "DESCENDANT";
    public static final String LEAF_DESCENDANT = "LEAF_DESCENDANT";
    public static final String RELATIVE = "RELATIVE";
    static final String[] ALL_RELATIONSHIPS = new String[]{"PARENT", "CHILD", "ANCESTOR", "ROOT_ANCESTOR", "DESCENDANT", "LEAF_DESCENDANT", "RELATIVE"};
    private TypedExpression m_BaseExpression;
    private TypedExpression m_ReferenceExpression;
    private BaseMetadataObjectReference m_Hierarchy;
    private String m_Relationship;
    private boolean m_Negated;
    private boolean m_IncludeSelf;

    private BaseMetadataObjectReference getHierarchyReference() {
        return this.m_Hierarchy;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getBaseExpression());
        syntaxPrintingContext.append(" IS ");
        if (this.isNegated()) {
            syntaxPrintingContext.append("NOT ");
        }
        syntaxPrintingContext.append(this.getRelationship());
        if (this.includeSelf()) {
            syntaxPrintingContext.append(" OR SELF");
        }
        syntaxPrintingContext.append(" OF ");
        syntaxPrintingContext.print(this.getReferenceExpression());
        syntaxPrintingContext.append(" WITHIN ");
        this.getHierarchyReference().toSyntax(syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = validationContext.validateExp(this.m_BaseExpression);
        this.m_ReferenceExpression = validationContext.validateExp(this.m_ReferenceExpression);
        this.m_Hierarchy = (BaseMetadataObjectReference)validationContext.validate(this.m_Hierarchy);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.getBaseExpression().isDefinitionComplete()) {
            return false;
        }
        if (!this.getReferenceExpression().isDefinitionComplete()) {
            return false;
        }
        if (!this.m_Hierarchy.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public HierarchicalCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, MdmHierarchy mdmHierarchy, boolean bl, boolean bl2) {
        this.m_Relationship = HierarchicalCondition.validateEnum(string, ALL_RELATIONSHIPS);
        HierarchicalCondition.validateValue(typedExpression);
        HierarchicalCondition.validateValue(typedExpression2);
        HierarchicalCondition.validateValue(mdmHierarchy);
        this.m_BaseExpression = typedExpression;
        this.m_ReferenceExpression = typedExpression2;
        this.m_Hierarchy = new MetadataObjectReference(mdmHierarchy, MdmHierarchy.class);
        this.m_Negated = bl;
        this.m_IncludeSelf = bl2;
        this.initialize();
    }

    public HierarchicalCondition(ExpParser expParser, TypedExpression typedExpression, String string, TypedExpression typedExpression2, BaseMetadataObjectReference baseMetadataObjectReference, boolean bl, boolean bl2) {
        this.m_Relationship = HierarchicalCondition.validateEnum(string, ALL_RELATIONSHIPS);
        HierarchicalCondition.validateValue(typedExpression);
        HierarchicalCondition.validateValue(typedExpression2);
        HierarchicalCondition.validateValue(baseMetadataObjectReference);
        this.m_BaseExpression = typedExpression;
        this.m_ReferenceExpression = typedExpression2;
        this.m_Hierarchy = baseMetadataObjectReference;
        this.m_Negated = bl;
        this.m_IncludeSelf = bl2;
        this.initialize();
    }

    public HierarchicalCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, MdmHierarchy mdmHierarchy, boolean bl) {
        this(typedExpression, string, typedExpression2, mdmHierarchy, bl, false);
    }

    public HierarchicalCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, MdmHierarchy mdmHierarchy) {
        this(typedExpression, string, typedExpression2, mdmHierarchy, false, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitHierarchicalCondition(this, object);
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }

    public TypedExpression getReferenceExpression() {
        return this.m_ReferenceExpression;
    }

    public MdmHierarchy getHierarchy() {
        return (MdmHierarchy)this.m_Hierarchy.getBaseMetadataObject();
    }

    public String getHierarchyID() {
        return this.m_Hierarchy.getIdentifier().toString();
    }

    public String getRelationship() {
        return this.m_Relationship;
    }

    public boolean isNegated() {
        return this.m_Negated;
    }

    public boolean includeSelf() {
        return this.m_IncludeSelf;
    }
}

