/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.express.idl.util.XMLWriter;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataObjectState;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataXMLFormat;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.transaction.Transaction;

public abstract class MetadataToXMLConverter {
    private XMLWriter m_Writer = null;
    private Transaction m_Transaction = null;
    private ArrayList m_NextAttrNames = null;
    private ArrayList m_NextAttrValues = null;
    private boolean m_InAttributes = false;
    private Map<Identifier, Identifier> m_RenameMapXMLIDToNewID = null;

    public final XMLWriter getWriter() {
        return this.m_Writer;
    }

    protected final void setWriter(XMLWriter xMLWriter) {
        this.m_Writer = xMLWriter;
    }

    protected Map<Identifier, Identifier> getIDRenameMap() {
        boolean bl = true;
        return this.getIDRenameMap(bl);
    }

    protected Map<Identifier, Identifier> getIDRenameMap(boolean bl) {
        if (null == this.m_RenameMapXMLIDToNewID && bl) {
            this.m_RenameMapXMLIDToNewID = new HashMap<Identifier, Identifier>();
        }
        return this.m_RenameMapXMLIDToNewID;
    }

    public Identifier getRenamedIDFromXMLID(Identifier identifier) {
        Map<Identifier, Identifier> map = this.getIDRenameMap(false);
        if (null == map || map.isEmpty()) {
            return null;
        }
        int n = identifier.getOwnerIndex();
        Identifier identifier2 = new Identifier(identifier);
        while (identifier2.getNumComponents() > n + 1) {
            identifier2.removeLastComponent();
        }
        Identifier identifier3 = new Identifier(identifier2);
        boolean bl = false;
        for (int i = n + 1; i < identifier.getNumComponents(); ++i) {
            String string = identifier.getComponent(i);
            identifier3.addComponent(string);
            if (map.containsKey(identifier3)) {
                bl = true;
                string = map.get(identifier3).getComponent(i);
            }
            identifier2.addComponent(string);
        }
        if (!bl) {
            return null;
        }
        return identifier2;
    }

    public String getXMLVersion() {
        return "0.1";
    }

    public final void beginElement(XMLTag xMLTag) {
        String string = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        this.getWriter().beginElement(string);
        if (this.m_NextAttrNames != null) {
            for (int i = 0; i < this.m_NextAttrNames.size(); ++i) {
                this.getWriter().appendAttribute((String)this.m_NextAttrNames.get(i), (String)this.m_NextAttrValues.get(i));
            }
            this.m_NextAttrNames.clear();
            this.m_NextAttrValues.clear();
        }
    }

    public final void closeTag() {
        this.getWriter().closeTag();
    }

    public final void endElement() {
        this.getWriter().endElement();
    }

    public final void endElement(XMLTag xMLTag) {
        String string = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        this.getWriter().endElement(string);
    }

    public final void newLine() {
        this.getWriter().newLine();
    }

    public final void appendCData(String string) {
        this.getWriter().appendCData(string);
    }

    public final void appendCDataElement(XMLTag xMLTag, String string) {
        this.beginElement(xMLTag);
        this.closeTag();
        this.appendCData(string);
        this.endElement(xMLTag);
    }

    public final void appendAttribute(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject, boolean bl) {
        if (xMLTag.allowsSuppression() && this.suppressAttribute(xMLTag, string, baseMetadataObject)) {
            return;
        }
        String string2 = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string2) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        if (xMLTag.isWritableForVersion(this)) {
            this.getWriter().appendAttribute(string2, string, bl);
        }
    }

    public final void appendAttribute(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject) {
        this.appendAttribute(xMLTag, string, baseMetadataObject, true);
    }

    public final void appendAttribute(XMLTag xMLTag, String string) {
        this.appendAttribute(xMLTag, string, null);
    }

    public final void appendSyntax(XMLTag xMLTag, SyntaxObject syntaxObject, BaseMetadataObject baseMetadataObject) {
        String string = "";
        if (null != syntaxObject) {
            String string2 = null;
            if (this.suppressOwnerName(xMLTag, syntaxObject, baseMetadataObject)) {
                string2 = baseMetadataObject.getOwnerName();
            }
            if ((string = this.toSyntax(syntaxObject, string2)).contains("..") && this.suppressNamespace(xMLTag, syntaxObject, baseMetadataObject)) {
                string = this.toSyntax(syntaxObject, string2, true);
            }
        }
        if (this.isMetadataXMLVersionSameOrLaterThan("1.1") && this.needsCDataFormatting(string)) {
            this.appendCDataElement(xMLTag, string);
        } else {
            this.appendAttribute(xMLTag, string, baseMetadataObject);
        }
    }

    public final void appendSyntaxElement(XMLTag xMLTag, XMLTag xMLTag2, SyntaxObject syntaxObject, BaseMetadataObject baseMetadataObject) {
        String string = "";
        if (null != syntaxObject) {
            String string2 = null;
            if (this.suppressOwnerName(xMLTag2, syntaxObject, baseMetadataObject)) {
                string2 = baseMetadataObject.getOwnerName();
            }
            if ((string = this.toSyntax(syntaxObject, string2)).contains("..") && this.suppressNamespace(xMLTag2, syntaxObject, baseMetadataObject)) {
                string = this.toSyntax(syntaxObject, string2, true);
            }
        }
        if (this.isMetadataXMLVersionSameOrLaterThan("1.1") && this.needsCDataFormatting(string)) {
            this.appendCDataElement(xMLTag, string);
        } else {
            this.beginElement(xMLTag);
            this.appendAttribute(xMLTag2, string, baseMetadataObject);
            this.endElement();
        }
    }

    public final String toSyntax(SyntaxObject syntaxObject) {
        return this.toSyntax(syntaxObject, null);
    }

    public final String toSyntax(SyntaxObject syntaxObject, String string) {
        return this.toSyntax(syntaxObject, string, false);
    }

    public final String toSyntax(SyntaxObject syntaxObject, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        syntaxObject.toSyntax(stringBuffer, string, null, bl, this);
        return stringBuffer.toString();
    }

    public final void appendSQLDataType(XMLTag xMLTag, SQLDataType sQLDataType, BaseMetadataObject baseMetadataObject) {
        String string = "";
        if (null != sQLDataType) {
            string = sQLDataType.getSQLText();
        }
        this.appendAttribute(xMLTag, string, baseMetadataObject);
    }

    public final void appendAttributeToNextElement(XMLTag xMLTag, String string) {
        String string2 = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string2) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        this.appendAttributeToNextElement(string2, string);
    }

    public final void appendAttributeToNextElement(String string, String string2) {
        if (this.m_NextAttrNames == null) {
            this.m_NextAttrNames = new ArrayList(3);
        }
        this.m_NextAttrNames.add(string);
        if (this.m_NextAttrValues == null) {
            this.m_NextAttrValues = new ArrayList(3);
        }
        this.m_NextAttrValues.add(string2);
    }

    final void appendAttribute(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder) {
        if (null == metadataObjectHolder) {
            return;
        }
        String string = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        this.getWriter().appendAttribute(string, metadataObjectHolder.getObjectID());
    }

    public String getIDValue(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject) {
        return this.escapeString(string);
    }

    public final String getIDValue(String string, BaseMetadataObject baseMetadataObject) {
        return this.getIDValue(BaseMetadataXMLTags.NAME, string, baseMetadataObject);
    }

    public final String escapeString(String string) {
        this.getWriter();
        return XMLWriter.escapeString(string);
    }

    public final void appendIDAttribute(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder, BaseMetadataObject baseMetadataObject) {
        if (metadataObjectHolder.getMetadataObject() instanceof MdmObject) {
            MdmObject mdmObject = (MdmObject)metadataObjectHolder.getMetadataObject();
            if (baseMetadataObject.getTopLevelObject() == mdmObject.getTopLevelObject()) {
                this.appendIDAttribute(xMLTag, mdmObject.getName(), (BaseMetadataObject)mdmObject);
            } else {
                mdmObject.appendObjectRefXMLString(baseMetadataObject, xMLTag, this);
            }
        }
    }

    public final void appendIDAttribute(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject) {
        if (xMLTag.allowsSuppression() && this.suppressAttribute(xMLTag, string, baseMetadataObject)) {
            return;
        }
        String string2 = this.getIDValue(xMLTag, string, baseMetadataObject);
        if (null == string2) {
            return;
        }
        String string3 = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string3) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        this.getWriter().appendAttribute(string3, string2, false);
    }

    final void appendAttribute(XMLTag xMLTag, Source source) {
        if (null == source) {
            return;
        }
        String string = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        this.getWriter().appendAttribute(string, source.getID());
    }

    final void appendElement(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder) {
        if (metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject) {
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)metadataObjectHolder.getMetadataObject();
            baseMetadataObject.appendXMLString(this, xMLTag);
        }
    }

    final void appendChoiceElement(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder) {
        if (metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject) {
            this.beginElement(xMLTag);
            this.closeTag();
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)metadataObjectHolder.getMetadataObject();
            baseMetadataObject.appendXMLString(this, null);
            this.endElement(xMLTag);
        }
    }

    final void appendIDRefElement(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder, BaseMetadataObject baseMetadataObject) {
        if (null == metadataObjectHolder) {
            return;
        }
        if (metadataObjectHolder.getMetadataObject() == null && baseMetadataObject != null) {
            baseMetadataObject.getBaseMetadataProvider().fetchMetadataObject(metadataObjectHolder);
        }
        if (!(metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject)) {
            return;
        }
        ((BaseMetadataObject)metadataObjectHolder.getMetadataObject()).appendObjectRefXMLString(baseMetadataObject, xMLTag, this);
    }

    final void appendIDRefElement(XMLTag xMLTag, Source source, BaseMetadataObject baseMetadataObject) {
        this.beginElement(xMLTag);
        this.appendAttribute(BaseMetadataXMLTags.REF_ID, source);
        this.endElement();
    }

    public final void beginDocType(XMLTag xMLTag) {
        String string = xMLTag.getVersionedValue(this.getXMLFormat().getVersion());
        if (null == string) {
            throw new RuntimeException("Missing name in " + xMLTag.toString());
        }
        this.getWriter().beginDocType(string, null);
    }

    public final void endDocType() {
        this.getWriter().endDocType();
    }

    public final void appendParameterEntityDecl(String string, String string2, String string3) {
        this.getWriter().appendParameterEntityDecl(string, string2, string3);
    }

    public final void appendParameterEntityRef(String string) {
        this.getWriter().appendParameterEntityRef(string);
    }

    public final boolean needsCDataFormatting(SyntaxObject syntaxObject) {
        if (!this.isMetadataXMLVersionSameOrLaterThan("1.1") || null == syntaxObject) {
            return false;
        }
        String string = this.toSyntax(syntaxObject);
        return this.needsCDataFormatting(string);
    }

    public final boolean needsCDataFormatting(String string) {
        return string.indexOf(10) >= 0;
    }

    public final boolean canWriteObjectRefAsAttribute(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder, BaseMetadataObject baseMetadataObject) {
        if (!this.isMetadataXMLVersionSameOrLaterThan("1.2")) {
            return false;
        }
        if (null == metadataObjectHolder) {
            return true;
        }
        if (null == metadataObjectHolder.getMetadataObject() && null != baseMetadataObject) {
            baseMetadataObject.getBaseMetadataProvider().fetchMetadataObject(metadataObjectHolder);
        }
        if (!(metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject)) {
            return false;
        }
        BaseMetadataObject baseMetadataObject2 = (BaseMetadataObject)metadataObjectHolder.getMetadataObject();
        BaseMetadataObject baseMetadataObject3 = baseMetadataObject2.getTopLevelObject();
        if (null == baseMetadataObject || baseMetadataObject.getTopLevelObject() != baseMetadataObject3) {
            MdmSchema mdmSchema = baseMetadataObject3.getOwner();
            if (null == baseMetadataObject || baseMetadataObject.getOwner() != mdmSchema) {
                return false;
            }
            String string = baseMetadataObject3.getPropertyStringValue(BaseMetadataXMLTags.NAMESPACE);
            if (null != string && string.length() > 0 && this.supportsNamespaces()) {
                return false;
            }
        }
        return true;
    }

    public final boolean supportsNamespaces() {
        return this.isMetadataXMLVersionSameOrLaterThan("1.1");
    }

    public final boolean isInAttributes() {
        return this.m_InAttributes;
    }

    final void setInAttributes(boolean bl) {
        this.m_InAttributes = bl;
    }

    final boolean addMetadataObject(MetadataObjectHolder metadataObjectHolder, List list) {
        if (null != metadataObjectHolder && metadataObjectHolder.getMetadataObject() instanceof BaseMetadataObject) {
            return this.addMetadataObjectAndChildren((BaseMetadataObject)metadataObjectHolder.getMetadataObject(), list);
        }
        return false;
    }

    public final boolean addMetadataObject(BaseMetadataObject baseMetadataObject, List list) {
        return this.addMetadataObjectAndChildren(baseMetadataObject, list);
    }

    public final boolean addMetadataObject(BaseMetadataObject baseMetadataObject) {
        LinkedList linkedList = new LinkedList();
        return this.addMetadataObjectAndChildren(baseMetadataObject, linkedList);
    }

    protected abstract boolean addMetadataObjectAndChildren(BaseMetadataObject var1, List var2);

    public abstract void generateXML(XMLWriter var1);

    final Transaction getTransaction() {
        return this.m_Transaction;
    }

    public void resetState() {
        if (this.m_NextAttrNames != null) {
            this.m_NextAttrNames.clear();
            this.m_NextAttrValues.clear();
        }
        this.setInAttributes(false);
    }

    public void rollbackState() {
    }

    public final void setTransaction(Transaction transaction) {
        this.m_Transaction = transaction;
        this.resetState();
    }

    public abstract MetadataXMLFormat getXMLFormat();

    abstract boolean isModifiedObject(BaseMetadataObject var1);

    public final boolean isMetadataXMLVersionSameOrLaterThan(String string) {
        return this.getXMLFormat().isSameOrLaterThan(string);
    }

    public BaseMetadataObjectState getIncrementalSendState(BaseMetadataObject baseMetadataObject) {
        return null;
    }

    boolean suppressOwnerName(XMLTag xMLTag, SyntaxObject syntaxObject, BaseMetadataObject baseMetadataObject) {
        return true;
    }

    boolean suppressAttribute(XMLTag xMLTag, String string, BaseMetadataObject baseMetadataObject) {
        return false;
    }

    boolean suppressNamespace(XMLTag xMLTag, SyntaxObject syntaxObject, BaseMetadataObject baseMetadataObject) {
        return false;
    }
}

