/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.List;
import java.util.Set;
import oracle.olapi.ArraySet;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.ImmutableDefinition;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.transaction.Transaction;

public final class ExpressionDefinition
extends ImmutableDefinition {
    private Expression m_Expression;

    public ExpressionDefinition(Expression expression, DataProvider dataProvider, Transaction transaction) {
        super(dataProvider._getSourceIDProvider().createExpressionID(), dataProvider, transaction);
        this.m_Expression = expression;
    }

    @Override
    public final Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitExpressionDefinition(this, object);
    }

    @Override
    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
        if (!bl) {
            return;
        }
        ArraySet arraySet = new ArraySet();
        this.getExpression().getQueryDimensions(arraySet);
        for (ColumnExpression columnExpression : arraySet) {
            set.add(columnExpression.getListSource(this.getDataProvider()));
        }
    }

    @Override
    final void accumulateOutputs(List list, Transaction transaction) {
    }

    @Override
    protected final SourceDefinition getType() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
        if (this.getExpression() instanceof Condition) {
            return fundamentalMetadataProvider.getBooleanDataType()._getSourceDefinition();
        }
        TypedExpression typedExpression = (TypedExpression)this.getExpression();
        DataType dataType = typedExpression.getDataType();
        if (dataType.matchesCategory(1)) {
            return fundamentalMetadataProvider.getIntegerDataType()._getSourceDefinition();
        }
        if (dataType.matchesCategory(2)) {
            return fundamentalMetadataProvider.getNumberDataType()._getSourceDefinition();
        }
        if (dataType.matchesCategory(24)) {
            return fundamentalMetadataProvider.getDateDataType()._getSourceDefinition();
        }
        return fundamentalMetadataProvider.getValueDataType()._getSourceDefinition();
    }

    public final Expression getExpression() {
        return this.m_Expression;
    }
}

