/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.CursorInputParameter;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.BooleanParameter;
import oracle.olapi.data.source.DateParameter;
import oracle.olapi.data.source.NumberParameter;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterVisitor;
import oracle.olapi.data.source.StringParameter;

public final class ParameterToXMLConverter
extends ParameterVisitor {
    private HashSet m_VisitedParameters = new HashSet();
    private XMLWriter m_Writer = null;

    Set getVisitedParameters() {
        return this.m_VisitedParameters;
    }

    public XMLWriter getWriter() {
        return this.m_Writer;
    }

    void setWriter(XMLWriter xMLWriter) {
        this.m_Writer = xMLWriter;
    }

    private void beginParameter(Parameter parameter) {
        this.getWriter().beginElement("Parameter");
        this.appendAttribute(parameter);
    }

    private void endParameter() {
        this.getWriter().closeTag();
        this.getWriter().endElement("Parameter");
        this.getWriter().newLine();
    }

    private void appendAttribute(String string, String string2) {
        this.getWriter().appendAttribute(string, string2);
    }

    private void appendAttribute(Parameter parameter) {
        this.appendAttribute("ID", parameter.getID());
    }

    void addParameter(Parameter parameter) {
        this.getVisitedParameters().add(parameter);
    }

    public void visitParameter(Parameter parameter) {
        this.beginParameter(parameter);
        if (parameter instanceof CursorInputParameter) {
            this.visitCursorInputParameter((CursorInputParameter)parameter, null);
        } else {
            parameter.acceptVisitor(this, null);
        }
        this.endParameter();
    }

    @Override
    public final Object visitStringParameter(StringParameter stringParameter, Object object) {
        this.addStringParamInfo(stringParameter, stringParameter.getValue());
        return null;
    }

    private final void addStringParamInfo(Parameter parameter, String string) {
        this.appendAttribute("Datatype", "Wstring");
        this.appendAttribute("Value", string);
    }

    @Override
    public final Object visitDateParameter(DateParameter dateParameter, Object object) {
        this.addDateParamInfo(dateParameter, dateParameter.getValue());
        return null;
    }

    private final void addDateParamInfo(Parameter parameter, Date date) {
        this.appendAttribute("Datatype", "Date");
        long l = (int)(date.getTime() / 1000L);
        this.appendAttribute("Value", Long.toString(l));
    }

    @Override
    public final Object visitBooleanParameter(BooleanParameter booleanParameter, Object object) {
        this.addBooleanParamInfo(booleanParameter, booleanParameter.getValue());
        return null;
    }

    private final void addBooleanParamInfo(Parameter parameter, Boolean bl) {
        this.appendAttribute("Datatype", "Boolean");
        if (bl.booleanValue()) {
            this.appendAttribute("Value", "True");
        } else {
            this.appendAttribute("Value", "False");
        }
    }

    @Override
    public final Object visitNumberParameter(NumberParameter numberParameter, Object object) {
        this.addNumberParamInfo(numberParameter, numberParameter.getValue());
        return null;
    }

    private final void addNumberParamInfo(Parameter parameter, Number number) {
        if (number instanceof Short) {
            this.appendAttribute("Datatype", "Short");
        } else if (number instanceof Integer) {
            this.appendAttribute("Datatype", "Long");
        } else if (number instanceof Long) {
            this.appendAttribute("Datatype", "LongLong");
        } else if (number instanceof Float) {
            this.appendAttribute("Datatype", "Float");
        } else if (number instanceof Double) {
            this.appendAttribute("Datatype", "Double");
        } else {
            throw new UnsupportedOperationException();
        }
        this.appendAttribute("Value", number.toString());
    }

    private final Object visitCursorInputParameter(CursorInputParameter cursorInputParameter, Object object) {
        if (cursorInputParameter.getSourceType() == SourceType.NUMBER_SOURCE) {
            this.addNumberParamInfo(cursorInputParameter, (Number)cursorInputParameter.getValueObject());
        } else if (cursorInputParameter.getSourceType() == SourceType.DATE_SOURCE) {
            this.addDateParamInfo(cursorInputParameter, (Date)cursorInputParameter.getValueObject());
        } else if (cursorInputParameter.getSourceType() == SourceType.BOOLEAN_SOURCE) {
            this.addBooleanParamInfo(cursorInputParameter, (Boolean)cursorInputParameter.getValueObject());
        } else if (cursorInputParameter.getSourceType() == SourceType.STRING_SOURCE) {
            this.addStringParamInfo(cursorInputParameter, (String)cursorInputParameter.getValueObject());
        } else {
            throw new UnsupportedOperationException();
        }
        return null;
    }
}

