/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.express.ErrorDescription;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorSpecifierStruct;
import oracle.express.olapi.data.CountHolder;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockFetcher;
import oracle.express.olapi.data.CursorBlockManager;
import oracle.express.olapi.data.CursorStructure;
import oracle.express.olapi.data.SourceIdentifierProvider;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorInputParameter;
import oracle.express.olapi.data.full.CursorLockReleaser;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ExpressGenerationInfoListener;
import oracle.express.olapi.data.full.FullCursorBlockFetcher;
import oracle.express.olapi.data.full.FullCursorStructureFactory;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.olapi.data.cursor.CursorManager;
import oracle.olapi.data.cursor.CursorManagerUpdateEvent;
import oracle.olapi.data.cursor.CursorManagerUpdateListener;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.source.CursorLockException;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.Source;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;
import org.omg.CORBA.NO_IMPLEMENT;

public abstract class DataCursorManager
extends BaseCursorManager
implements CursorManager {
    private boolean m_NeedsSpecificationUpdate = true;
    private FullCursorBlockFetcher m_CursorBlockFetcher = null;
    private CursorBlockManager m_CursorBlockManager = null;
    private CursorStructure m_RootCursorStructure = null;
    private int m_NumCursorStructures = -1;
    private List m_CursorManagerUpdateListeners = new ArrayList();

    protected DataCursorManager(Source source, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, List list) {
        super(source, cursorManagerInterface, l, definitionManager, list);
        this.setCursorBlockFetcher(new FullCursorBlockFetcher(this, this.getCursorManagerInterface()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCursorManagerUpdateListener(CursorManagerUpdateListener cursorManagerUpdateListener) {
        List list = this.m_CursorManagerUpdateListeners;
        synchronized (list) {
            this.m_CursorManagerUpdateListeners.add(cursorManagerUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeCursorManagerUpdateListener(CursorManagerUpdateListener cursorManagerUpdateListener) {
        List list = this.m_CursorManagerUpdateListeners;
        synchronized (list) {
            this.m_CursorManagerUpdateListeners.remove(cursorManagerUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataUpdatedEvent() {
        List list = this.m_CursorManagerUpdateListeners;
        synchronized (list) {
            Iterator iterator = this.m_CursorManagerUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((CursorManagerUpdateListener)iterator.next()).cursorManagerDataUpdated(new CursorManagerUpdateEvent(this, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStructureUpdatedEvent() {
        List list = this.m_CursorManagerUpdateListeners;
        synchronized (list) {
            Iterator iterator = this.m_CursorManagerUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((CursorManagerUpdateListener)iterator.next()).cursorManagerStructureUpdated(new CursorManagerUpdateEvent(this, 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSpecificationUpdatedEvent() {
        List list = this.m_CursorManagerUpdateListeners;
        synchronized (list) {
            Iterator iterator = this.m_CursorManagerUpdateListeners.iterator();
            while (iterator.hasNext()) {
                ((CursorManagerUpdateListener)iterator.next()).cursorManagerSpecificationUpdated(new CursorManagerUpdateEvent(this, 2));
            }
        }
    }

    @Override
    protected final void _closed() {
        super._closed();
        CursorLockReleaser.releaseCursorLock(this.getSource().getDefinition(), this.getDefinitionManager());
        this.getCursorBlockFetcher().close();
        this.setCursorBlockFetcher(null);
    }

    synchronized void _dataUpdated() {
        if (this.isPreparedForOpenCursor()) {
            this.getCursorBlockManager().dataUpdated();
        }
        this.fireDataUpdatedEvent();
    }

    synchronized void _structureUpdated() {
        this.undoCursorPreparations();
        this.setNeedsSpecificationUpdate(true);
        this.fireStructureUpdatedEvent();
    }

    final FullCursorBlockFetcher getCursorBlockFetcher() {
        return this.m_CursorBlockFetcher;
    }

    final CursorBlockManager getCursorBlockManager() {
        return this.m_CursorBlockManager;
    }

    private final void setCursorBlockFetcher(FullCursorBlockFetcher fullCursorBlockFetcher) {
        this.m_CursorBlockFetcher = fullCursorBlockFetcher;
    }

    private final void setCursorBlockManager(CursorBlockManager cursorBlockManager) {
        this.m_CursorBlockManager = cursorBlockManager;
    }

    final int getNumCursorStructures() {
        return this.m_NumCursorStructures;
    }

    private final void setNumCursorStructures(int n) {
        this.m_NumCursorStructures = n;
    }

    final boolean isPreparedForOpenCursor() {
        return null != this.getCursorBlockManager();
    }

    final void prepareForOpenCursor(CursorSpecification cursorSpecification, CursorBlock cursorBlock) {
        Parameter[] parameterArray = new Parameter[this.getParameters().size()];
        this.getParameters().toArray(parameterArray);
        if (null == cursorBlock) {
            cursorBlock = this.getCursorBlockFetcher().fetchAnyCursorBlock(parameterArray);
        }
        this.setCursorBlockManager(this.createCursorBlockManager(cursorBlock));
        CountHolder countHolder = new CountHolder();
        this.setRootCursorStructure(FullCursorStructureFactory.createCursorStructure(cursorSpecification, countHolder));
        this.setNumCursorStructures(countHolder.getCount());
    }

    private final CursorBlockManager createCursorBlockManager(CursorBlock cursorBlock) {
        DataProvider dataProvider = this.getDefinitionManager().getDataProvider();
        String string = dataProvider.getProperty("CursorBlockCacheSize");
        int n = 5;
        if (null != string) {
            n = Integer.parseInt(string);
        }
        return new CursorBlockManager((SourceIdentifierProvider)this.getDefinitionManager(), (CursorBlockFetcher)this.getCursorBlockFetcher(), cursorBlock, n);
    }

    final void undoCursorPreparations() {
        if (this.isPreparedForOpenCursor()) {
            this.getCursorBlockManager().die();
            this.setCursorBlockManager(null);
            this.setRootCursorStructure(null);
            this.setNumCursorStructures(-1);
            for (Parameter parameter : this.getParameters()) {
                if (!(parameter instanceof CursorInputParameter)) continue;
                ((CursorInputParameter)parameter).clearCursorInputs();
            }
        }
    }

    final CursorStructure getRootCursorStructure() {
        return this.m_RootCursorStructure;
    }

    private final void setRootCursorStructure(CursorStructure cursorStructure) {
        this.m_RootCursorStructure = cursorStructure;
    }

    boolean inputSourcesModified(Transaction transaction) {
        return false;
    }

    public Source[] getInputSources() {
        return null;
    }

    @Override
    protected void localCreateDefinitionSequence(Transaction transaction, SourceConverter sourceConverter) {
        boolean bl = false;
        Source[] sourceArray = null;
        DataProvider dataProvider = this.getDefinitionManager().getDataProvider();
        if (!dataProvider.areParametersSupported()) {
            bl = this.inputSourcesModified(transaction);
            sourceArray = this.getInputSources();
        } else {
            sourceArray = new Source[]{};
        }
        try {
            sourceConverter.convertDefinitionTree(this.getSource().getDefinition(), sourceArray, bl, this.getCursorManagerID(), false, this.getParameters());
        }
        catch (CursorLockException cursorLockException) {
            CursorLockReleaser.releaseCursorLock(this.getSource().getDefinition(), this.getDefinitionManager());
            throw cursorLockException;
        }
    }

    @Override
    public final boolean isSpecificationUpdateNeeded() {
        return this.m_NeedsSpecificationUpdate;
    }

    final void setNeedsSpecificationUpdate(boolean bl) {
        this.m_NeedsSpecificationUpdate = bl;
    }

    final void updateSpecification(CursorSpecifierStruct[] cursorSpecifierStructArray) {
        this.setNeedsSpecificationUpdate(false);
        try {
            this.getCursorManagerInterface().updateSpecification(cursorSpecifierStructArray);
        }
        catch (ExpressException expressException) {
            ExpressServerException expressServerException = new ExpressServerException(expressException);
            ErrorDescription errorDescription = (ErrorDescription)expressServerException.getErrorStack().getErrorDescriptions().get(0);
            if (errorDescription.getErrorType() == 1) {
                throw new NoDataAvailableException();
            }
            throw expressServerException;
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
        this.undoCursorPreparations();
        this.fireSpecificationUpdatedEvent();
        ExpressGenerationInfoListener expressGenerationInfoListener = this.getDefinitionManager().getDataProvider().getGenerationInfoListener();
        if (null != expressGenerationInfoListener) {
            expressGenerationInfoListener.notifyOfUpdateSpecification(this);
        }
    }

    protected void commitIncrementalTransaction() {
        BaseTransaction baseTransaction;
        DataProvider dataProvider = this.getDefinitionManager().getDataProvider();
        if (!dataProvider.getBaseTransactionProvider().hideIncrementalTransactions()) {
            return;
        }
        BaseTransaction baseTransaction2 = this.getTransaction();
        if (baseTransaction2 != (baseTransaction = baseTransaction2.getSystemTransaction())) {
            baseTransaction.commit();
        }
    }
}

