/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Date;
import oracle.express.idl.ExpressOlapiDataCursorModule.PersistentSourceIdStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.ValueCursorBlockStruct;
import oracle.express.idl.reconciliation.TxsOqDataBlockStruct;
import oracle.express.idl.reconciliation.TxsOqDataUnion;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorStructure;
import oracle.express.olapi.data.CursorStructureVisitor;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.express.olapi.data.CursorValidationContext;
import oracle.express.olapi.data.DependencyGroupUser;
import oracle.express.olapi.data.ExpressCursor;
import oracle.express.olapi.data.ExpressValueCursor;
import oracle.express.olapi.data.InvalidCursorBlockException;
import oracle.express.olapi.data.RandomAccessPositionHelper;
import oracle.express.olapi.data.SourceIdentifierProvider;
import oracle.olapi.data.cursor.IncorrectDataTypeException;
import oracle.olapi.data.cursor.SourceIdentifier;

public final class ValueCursorStructure
extends CursorStructure {
    private static final int _INVALID = -1;
    private static final int _SHORT = 0;
    private static final int _LONG = 1;
    private static final int _LONGLONG = 2;
    private static final int _IDL_FLOAT = 3;
    private static final int _DOUBLE = 4;
    private static final int _WSTRING = 5;
    private static final int _BOOLEAN = 6;
    private static final int _DATE = 7;
    private static final int _NUMBER = 8;
    private static final int _UNION = 9;
    private static final int _LITERALS = 0;
    private static final int _TRANSIENT_SOURCES = 1;
    private static final int _PERSISTENT_SOURCES = 2;

    public ValueCursorStructure(int n, SourceIdentifier sourceIdentifier, boolean bl, boolean bl2, boolean bl3, int n2) {
        super(n, sourceIdentifier, bl, bl2, bl3, n2);
    }

    @Override
    final boolean validateWithBlock(CursorValidationContext cursorValidationContext) {
        boolean bl;
        if (!super.validateWithBlock(cursorValidationContext)) {
            return false;
        }
        CursorBlock cursorBlock = cursorValidationContext.getCursorBlock();
        TxsOqDataBlockStruct txsOqDataBlockStruct = cursorBlock.getDataBlock(this._getId());
        int n = DependencyGroupUser.getDependencyGroupIndex(txsOqDataBlockStruct.exteriorDependencyGroupIndex, cursorValidationContext, true);
        long l = this._getLength(txsOqDataBlockStruct);
        boolean bl2 = bl = n >= 0 && (long)n < l;
        if (bl) {
            cursorValidationContext.setNewDataIndex(this._getId(), n);
        }
        return bl;
    }

    @Override
    final void _setPosition(long l, ExpressCursor expressCursor) {
        RandomAccessPositionHelper.setPosition(l, expressCursor);
    }

    @Override
    final boolean _next(CursorTreeManager cursorTreeManager) {
        return RandomAccessPositionHelper.next(this._getId(), this._getExtent(cursorTreeManager), cursorTreeManager);
    }

    @Override
    final boolean _nextOrReset(CursorTreeManager cursorTreeManager) {
        return RandomAccessPositionHelper.nextOrReset(this._getId(), this._getExtent(cursorTreeManager), cursorTreeManager);
    }

    @Override
    final boolean _hasNext(CursorTreeManager cursorTreeManager) {
        return RandomAccessPositionHelper.hasNext(this._getId(), this._getExtent(cursorTreeManager), cursorTreeManager);
    }

    @Override
    final long _getExtent(CursorTreeManager cursorTreeManager) {
        if (!cursorTreeManager.getCursorBlockManager().hasBlock(this._getId())) {
            return 1L;
        }
        ValueCursorBlockStruct valueCursorBlockStruct = cursorTreeManager.getCurrentCursorBlock().getValueCursorBlock(this._getId());
        int n = 0;
        if (valueCursorBlockStruct.dependencyValueCursorBlockIndex != -1) {
            n = cursorTreeManager.getCursor(cursorTreeManager.getCurrentCursorBlock().getValueCursorBlocks()[valueCursorBlockStruct.dependencyValueCursorBlockIndex].indexBlock.id).getIndexDirect();
        }
        return valueCursorBlockStruct.indexBlock.logicalExtents[n];
    }

    @Override
    public final int getIndex(CursorValidationContext cursorValidationContext) {
        int n;
        if (!cursorValidationContext.getCursorTreeManager().getCursorBlockManager().hasBlock(this._getId())) {
            return 0;
        }
        CursorBlock cursorBlock = cursorValidationContext.getCursorBlock();
        ValueCursorBlockStruct valueCursorBlockStruct = cursorBlock.getValueCursorBlock(this._getId());
        long l = cursorValidationContext.getPosition(this._getId());
        int n2 = 0;
        if (valueCursorBlockStruct.dependencyValueCursorBlockIndex != -1) {
            ValueCursorBlockStruct valueCursorBlockStruct2 = cursorBlock.getValueCursorBlocks()[valueCursorBlockStruct.dependencyValueCursorBlockIndex];
            n2 = cursorValidationContext.getIndex(valueCursorBlockStruct2.indexBlock.id);
        }
        int n3 = valueCursorBlockStruct.indexBlock.physicalExtents[n2];
        int n4 = valueCursorBlockStruct.indexBlock.physicalExtents[n2 + 1];
        int n5 = DependencyGroupUser.getDependencyGroupIndex(valueCursorBlockStruct.indexBlock.exteriorDependencyGroupIndex, cursorValidationContext);
        int n6 = valueCursorBlockStruct.starts[n5];
        long l2 = valueCursorBlockStruct.indexBlock.logicalOffsets[n5];
        if (n6 >= n3 && n6 < n4 ? (l > l2 ? (n = (int)(l - l2) + n6 - 1) >= n4 : (n = (int)l + n3 - 1) >= n6) : (n = (int)l + n3 - 1) >= n4) {
            throw new InvalidCursorBlockException();
        }
        return n;
    }

    final TxsOqDataBlockStruct _getDataBlock(CursorTreeManager cursorTreeManager) {
        return cursorTreeManager.getCurrentCursorBlock().getDataBlock(this._getId());
    }

    final int _getCursorDataIndex(CursorTreeManager cursorTreeManager) {
        ExpressValueCursor expressValueCursor = (ExpressValueCursor)cursorTreeManager.getCursor(this._getId());
        return expressValueCursor.getDataIndex();
    }

    final boolean _hasCurrentValue(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        int n2 = txsOqDataBlockStruct.naMask[n / 32];
        n2 >>= n % 32;
        return (n2 &= 1) == 0;
    }

    final long _getLength(TxsOqDataBlockStruct txsOqDataBlockStruct) {
        switch (txsOqDataBlockStruct.values.discriminator()) {
            case 0: {
                switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                    case 6: {
                        return txsOqDataBlockStruct.values.literals().booleanValues().length;
                    }
                    case 5: {
                        return txsOqDataBlockStruct.values.literals().wstringValues().length;
                    }
                    case 0: {
                        return txsOqDataBlockStruct.values.literals().shortValues().length;
                    }
                    case 1: {
                        return txsOqDataBlockStruct.values.literals().longValues().length;
                    }
                    case 3: {
                        return txsOqDataBlockStruct.values.literals().floatValues().length;
                    }
                    case 4: {
                        return txsOqDataBlockStruct.values.literals().doubleValues().length;
                    }
                    case 7: {
                        return txsOqDataBlockStruct.values.literals().dateValues().length;
                    }
                    case 9: {
                        return txsOqDataBlockStruct.values.literals().dataUnionValues().length;
                    }
                }
                break;
            }
            case 1: {
                return txsOqDataBlockStruct.values.transientSourceIds().length;
            }
            case 2: {
                return txsOqDataBlockStruct.values.persistentSourceIds().length;
            }
        }
        return -1L;
    }

    final Object _getCurrentValue(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        if (txsOqDataBlockStruct.values.discriminator() != 0) {
            return this._getCurrentSource(txsOqDataBlockStruct, n, cursorTreeManager);
        }
        Object object = null;
        short s = txsOqDataBlockStruct.values.literals().discriminator();
        if (s == 9) {
            TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
            s = txsOqDataUnion.discriminator();
        }
        switch (s) {
            case 6: {
                object = new Boolean(this._getCurrentBoolean(txsOqDataBlockStruct, n));
                break;
            }
            case 5: {
                object = this._getCurrentString(txsOqDataBlockStruct, n);
                break;
            }
            case 0: {
                object = new Short(this._getCurrentShort(txsOqDataBlockStruct, n));
                break;
            }
            case 1: {
                object = new Integer(this._getCurrentInteger(txsOqDataBlockStruct, n));
                break;
            }
            case 3: {
                object = new Float(this._getCurrentFloat(txsOqDataBlockStruct, n));
                break;
            }
            case 4: {
                object = new Double(this._getCurrentDouble(txsOqDataBlockStruct, n));
                break;
            }
            case 7: {
                object = this._getCurrentDate(txsOqDataBlockStruct, n);
            }
        }
        return object;
    }

    final boolean _getCurrentBoolean(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentBoolean(txsOqDataBlockStruct, n);
    }

    final boolean _getCurrentBoolean(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 6: {
                    bl2 = txsOqDataBlockStruct.values.literals().booleanValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 6) break;
                    bl2 = txsOqDataUnion.booleanValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return bl2;
    }

    final String _getCurrentString(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentString(txsOqDataBlockStruct, n);
    }

    final String _getCurrentString(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        String string = null;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 5: {
                    string = txsOqDataBlockStruct.values.literals().wstringValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 5) break;
                    string = txsOqDataUnion.wstringValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return string;
    }

    final short _getCurrentShort(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentShort(txsOqDataBlockStruct, n);
    }

    final short _getCurrentShort(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        short s = 0;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 0: {
                    s = txsOqDataBlockStruct.values.literals().shortValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 0) break;
                    s = txsOqDataUnion.shortValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return s;
    }

    final int _getCurrentInteger(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentInteger(txsOqDataBlockStruct, n);
    }

    final int _getCurrentInteger(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        int n2 = 0;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 1: {
                    n2 = txsOqDataBlockStruct.values.literals().longValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 1) break;
                    n2 = txsOqDataUnion.longValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return n2;
    }

    final float _getCurrentFloat(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentFloat(txsOqDataBlockStruct, n);
    }

    final float _getCurrentFloat(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        float f = 0.0f;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 3: {
                    f = txsOqDataBlockStruct.values.literals().floatValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 3) break;
                    f = txsOqDataUnion.floatValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return f;
    }

    final double _getCurrentDouble(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentDouble(txsOqDataBlockStruct, n);
    }

    final double _getCurrentDouble(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        double d = 0.0;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 4: {
                    d = txsOqDataBlockStruct.values.literals().doubleValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 4) break;
                    d = txsOqDataUnion.doubleValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return d;
    }

    final Date _getCurrentDate(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentDate(txsOqDataBlockStruct, n);
    }

    final Date _getCurrentDate(TxsOqDataBlockStruct txsOqDataBlockStruct, int n) {
        boolean bl = false;
        Date date = null;
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            switch (txsOqDataBlockStruct.values.literals().discriminator()) {
                case 7: {
                    date = txsOqDataBlockStruct.values.literals().dateValues()[n];
                    bl = true;
                    break;
                }
                case 9: {
                    TxsOqDataUnion txsOqDataUnion = txsOqDataBlockStruct.values.literals().dataUnionValues()[n];
                    if (txsOqDataUnion.discriminator() != 7) break;
                    date = txsOqDataUnion.dateValue();
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IncorrectDataTypeException();
        }
        return date;
    }

    final SourceIdentifier _getCurrentSource(CursorTreeManager cursorTreeManager) {
        TxsOqDataBlockStruct txsOqDataBlockStruct = this._getDataBlock(cursorTreeManager);
        int n = this._getCursorDataIndex(cursorTreeManager);
        return this._getCurrentSource(txsOqDataBlockStruct, n, cursorTreeManager);
    }

    final SourceIdentifier _getCurrentSource(TxsOqDataBlockStruct txsOqDataBlockStruct, int n, CursorTreeManager cursorTreeManager) {
        if (txsOqDataBlockStruct.values.discriminator() == 0) {
            throw new IncorrectDataTypeException();
        }
        SourceIdentifierProvider sourceIdentifierProvider = cursorTreeManager.getCursorBlockManager()._getSourceIdentifierProvider();
        SourceIdentifier sourceIdentifier = null;
        switch (txsOqDataBlockStruct.values.discriminator()) {
            case 1: {
                String string = txsOqDataBlockStruct.values.transientSourceIds()[n];
                sourceIdentifier = sourceIdentifierProvider.getSourceIdentifier(string);
                break;
            }
            case 2: {
                PersistentSourceIdStruct persistentSourceIdStruct = txsOqDataBlockStruct.values.persistentSourceIds()[n];
                sourceIdentifier = sourceIdentifierProvider.getSourceIdentifier(persistentSourceIdStruct.metadataProviderId, persistentSourceIdStruct.persistentId);
            }
        }
        return sourceIdentifier;
    }

    @Override
    final Object _acceptVisitor(CursorStructureVisitor cursorStructureVisitor, Object object) {
        return cursorStructureVisitor.visitValueCursorStructure(this, object);
    }
}

