/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public final class CustomerLoggerFactory {
    private static final ClassLoader MAIN_LOADER = Thread.currentThread().getContextClassLoader();
    private final HashMap<String, Logger> loggerCache = new HashMap();
    private String[] severeLoggers;
    private String[] warningLoggers;
    private String[] infoLoggers;
    private String[] configLoggers;
    private String[] fineLoggers;
    private String[] finerLoggers;
    private String[] finestLoggers;
    private String[] m_knownLoggerNames;
    private String m_propertyPrefix;

    void clearCaches() {
        this.loggerCache.clear();
        this.fineLoggers = null;
    }

    public CustomerLoggerFactory(String[] knownLoggerNames, String propertyPrefix) {
        this.m_knownLoggerNames = knownLoggerNames;
        this.m_propertyPrefix = propertyPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String loggerName, String resourceBundleName) {
        Logger result = this.loggerCache.get(loggerName);
        if (result == null) {
            block11: {
                Thread thread = Thread.currentThread();
                ClassLoader originalTCL = thread.getContextClassLoader();
                boolean tclWasNotMain = originalTCL != MAIN_LOADER;
                try {
                    if (tclWasNotMain) {
                        this.setContextClassLoader(thread, MAIN_LOADER);
                    }
                    result = Logger.getLogger(loggerName, resourceBundleName);
                }
                catch (MissingResourceException ex) {
                    if (tclWasNotMain) {
                        tclWasNotMain = false;
                        this.setContextClassLoader(thread, originalTCL);
                        result = Logger.getLogger(loggerName, resourceBundleName);
                        break block11;
                    }
                    throw ex;
                }
                finally {
                    if (tclWasNotMain) {
                        this.setContextClassLoader(thread, originalTCL);
                    }
                }
            }
            this.loggerCache.put(loggerName, result);
            Level level = this.getDynamicLevel(result.getName());
            if (level != null) {
                result.setLevel(level);
                Handler handler = this.getCompatibleHandler(result);
                if (level.intValue() < handler.getLevel().intValue()) {
                    handler.setLevel(level);
                }
            }
        }
        return result;
    }

    private Handler getCompatibleHandler(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        if (handlers.length != 0) {
            for (Handler handler : handlers) {
                if (handler.getClass().equals(ConsoleHandler.class)) {
                    return handler;
                }
                if (!handler.getClass().equals(TraceLogger.TraceLoggerHandler.class)) continue;
                return handler;
            }
        }
        TraceLogger.TraceLoggerHandler handler = new TraceLogger.TraceLoggerHandler();
        logger.addHandler(handler);
        return handler;
    }

    private Level getDynamicLevel(String loggerName) {
        if (this.fineLoggers == null) {
            this.severeLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".severe");
            this.warningLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".warning");
            this.infoLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".info");
            this.configLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".config");
            this.fineLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".fine");
            this.finerLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".finer");
            this.finestLoggers = this.getEnabledLoggers(this.m_propertyPrefix + ".finest");
        }
        if (this.isDynamicallyEnabled(this.finestLoggers, loggerName)) {
            return Level.FINEST;
        }
        if (this.isDynamicallyEnabled(this.finerLoggers, loggerName)) {
            return Level.FINER;
        }
        if (this.isDynamicallyEnabled(this.fineLoggers, loggerName)) {
            return Level.FINE;
        }
        if (this.isDynamicallyEnabled(this.configLoggers, loggerName)) {
            return Level.CONFIG;
        }
        if (this.isDynamicallyEnabled(this.infoLoggers, loggerName)) {
            return Level.INFO;
        }
        if (this.isDynamicallyEnabled(this.warningLoggers, loggerName)) {
            return Level.WARNING;
        }
        if (this.isDynamicallyEnabled(this.severeLoggers, loggerName)) {
            return Level.SEVERE;
        }
        return null;
    }

    private boolean isDynamicallyEnabled(String[] loggerNames, String loggerName) {
        for (String name : loggerNames) {
            if (name.equals(loggerName)) {
                return true;
            }
            if (!loggerName.startsWith(name + '.')) continue;
            return true;
        }
        return false;
    }

    private String[] getEnabledLoggers(final String propertyName) {
        ArrayList<String> enable = new ArrayList<String>();
        String propertyVal = null == System.getSecurityManager() ? System.getProperty(propertyName, "") : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, "");
            }
        });
        StringTokenizer st = new StringTokenizer(propertyVal, ",");
        while (st.hasMoreTokens()) {
            String loggerName = st.nextToken();
            if (loggerName.length() <= 0) continue;
            if (!loggerName.startsWith("oracle")) {
                loggerName = this.selectKnownLoggerName(loggerName);
            }
            enable.add(loggerName);
        }
        return enable.toArray(new String[enable.size()]);
    }

    private String selectKnownLoggerName(String suffix) {
        for (String candidate : this.m_knownLoggerNames) {
            if (!candidate.endsWith(suffix)) continue;
            return candidate;
        }
        return suffix;
    }

    private void setContextClassLoader(final Thread thread, final ClassLoader loader) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                thread.setContextClassLoader(loader);
                return null;
            }
        });
    }
}

