/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.patch;

import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.patch.PatchAssistance;

class DefaultPatchAssistance
extends PatchAssistance {
    private static Pattern pattern1 = Pattern.compile("(---|\\+\\+\\+) ([^\\t]+)\\t([[^\\t]$]+)(\\t[^\\t]+)?.*");
    private Date _toModificationTime;
    private Date _fromModificationTime;
    private String _toFile;
    private String _fromFile;
    private String _toRevision;
    private String _fromRevision;

    DefaultPatchAssistance() {
    }

    public boolean isRecognised(byte[] source) {
        return true;
    }

    public Date getFromModificationTime() {
        return this._fromModificationTime;
    }

    public String getFromRevision() {
        return this._fromRevision;
    }

    public Date getToModificationTime() {
        return this._toModificationTime;
    }

    public String getToRevision() {
        return this._toRevision;
    }

    public String toFile() {
        return this._toFile;
    }

    public String fromFile() {
        return this._fromFile;
    }

    public void process(String line) {
        Matcher matcher = pattern1.matcher(line);
        if (matcher.matches()) {
            String revision;
            String fileName = matcher.group(2);
            fileName = fileName.equals("nul") || fileName.equals("/dev/null") ? null : fileName;
            Date modificationTime = this.parseModificationTime(matcher.group(3));
            String string = revision = matcher.group(4) != null ? matcher.group(4).trim() : null;
            if (matcher.group(1).startsWith("-")) {
                this._fromFile = fileName;
                this._fromModificationTime = modificationTime;
                this._fromRevision = revision;
            } else {
                this._toFile = fileName;
                this._toModificationTime = modificationTime;
                this._toRevision = revision;
            }
        }
    }

    public boolean isNew() {
        return false;
    }

    public void fixUpFilenames() {
    }

    public void updated(URL[] urls) {
    }
}

