/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;

final class PatchComponents {
    private PatchComponents() {
    }

    public static final JList createFileListerComponent(Collection<?> nodes) {
        DefaultListModel model = new DefaultListModel();
        Iterator<?> itr = nodes.iterator();
        while (itr.hasNext()) {
            model.addElement(itr.next());
        }
        JList<Object> list = new JList<Object>(model);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(null);
                URL url = null;
                if (value instanceof Locatable) {
                    url = ((Locatable)value).getURL();
                }
                if (url != null && URLFileSystem.isDirectoryPath((URL)url)) {
                    this.setIcon(OracleIcons.getIcon((String)"folder.png"));
                } else if (value instanceof Displayable) {
                    this.setIcon(((Displayable)value).getIcon());
                }
                if (this.getIcon() == null) {
                    this.setIcon(OracleIcons.getIcon((String)"file.png"));
                }
                if (url != null) {
                    this.setText(URLFileSystem.getPlatformPathName((URL)url));
                    this.setToolTipText(url.toString());
                } else if (value instanceof Displayable) {
                    Displayable displayable = (Displayable)value;
                    this.setText(displayable.getShortLabel());
                    this.setToolTipText(displayable.getToolTipText());
                }
                return this;
            }
        });
        list.setVisibleRowCount(5);
        return list;
    }
}

