/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.awt.EventQueue;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.vcs.VCSRegistry;
import oracle.ideimpl.patch.BasePatchCommand;
import oracle.ideimpl.patch.res.Bundle;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.compare.CompareConstants;

public class BasePatchController
implements Controller {
    public static final String COMMAND_RESULT = "BasePatchController.COMMAND_RESULT";
    public static final String THREAD_AUTHORIZED = "BasePatchController.THREAD_AUTHORIZED";
    private final Package m_commandPackage;

    public BasePatchController(Package commandPackage) {
        this.m_commandPackage = commandPackage;
    }

    protected boolean isHandledAction(IdeAction action) {
        this.initializeDeclarativeActionCommands(action);
        return action.getCommand() != null && action.getCommand().startsWith(this.m_commandPackage.getName());
    }

    private final void initializeDeclarativeActionCommands(IdeAction action) {
        if (action.getCommand() == null) {
            if (action.getCommandId() == CompareConstants.CREATE_PATCH_CMD_ID) {
                action.setCommand(new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.patch"), "oracle.ideimpl.patch.CreatePatchCommand"));
            } else if (action.getCommandId() == Ide.findCmdID((String)"ApplyPatch").intValue()) {
                action.setCommand(new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.patch"), "oracle.ideimpl.patch.ApplyPatchCommand"));
            }
        }
    }

    protected Command createCommand(IdeAction action, Context context) {
        return CommandProcessor.createCommandFromMeta((MetaClass)action.getCommandMetaClass(), (Context)context);
    }

    public boolean handleEvent(final IdeAction action, final Context context) {
        if (this.isHandledAction(action)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasePatchController.this.handleEventImpl(action, context);
                }
            });
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.isHandledAction(action)) {
            this.updateImpl(action, context);
            return true;
        }
        return false;
    }

    protected void updateImpl(IdeAction action, Context context) {
        BasePatchCommand clientCommand;
        if (!this.isSystemActive()) {
            action.setEnabled(false);
            return;
        }
        Command command = this.createCommand(action, context);
        this.prepareContext(context);
        this.preUpdate(action, command);
        BasePatchCommand basePatchCommand = clientCommand = command instanceof BasePatchCommand ? (BasePatchCommand)command : null;
        if (clientCommand != null) {
            action.setEnabled(clientCommand.isAvailable());
        }
    }

    protected void preUpdate(IdeAction action, Command command) {
    }

    protected void handleEventImpl(IdeAction action, Context context) {
        Command command = this.createCommand(action, context);
        this.prepareContext(context);
        BasePatchCommand clientCommand = command instanceof BasePatchCommand ? (BasePatchCommand)command : null;
        this.preInvoke(action, command);
        try {
            int result = this.invokeCommand(action, command);
            if (result == 9 && clientCommand != null) {
                clientCommand.noOp();
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Component)VersioningCoreUtil.getCurrentWindow(), (Throwable)e, (String)Bundle.get("ERROR_TITLE"), (String)e.getMessage(), null);
            return;
        }
    }

    protected void preInvoke(IdeAction action, Command command) {
    }

    protected boolean isSystemActive() {
        return !VCSRegistry.keySet().isEmpty();
    }

    protected int invokeCommand(IdeAction action, Command command) throws Exception {
        return CommandProcessor.getInstance().invoke(command);
    }

    private void prepareContext(Context context) {
        context.setBoolean(THREAD_AUTHORIZED, true);
    }
}

