/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.JDevTopComponent;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import com.oracle.jdeveloper.nbwindowsystem.NbStructuredPropertyAccess;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorState;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorUtil;
import com.oracle.jdeveloper.nbwindowsystem.editor.NbAcceleratorsActions;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitEditorAction;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import com.oracle.jdeveloper.nbwindowsystem.editor.UnSplitEditorAction;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuCustomizationsHelper;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.RecentFile;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ApplicationChangeNotifier;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.editor.LazyIconsCacheUtil;
import oracle.ideimpl.editor.RecentFilesLRU;
import oracle.javatools.util.MultiMap;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.xml.sax.SAXException;

public class NbEditorContainer
extends JDevTopComponent {
    private static boolean LAZY_LOADING_DISABLED = Boolean.getBoolean("lazy.loading.editors.disabled");
    private boolean initialized = false;
    private TabGroup tabGroup = null;
    private boolean noFocusOnActivation;
    private static final AtomicInteger cloneCounter = new AtomicInteger();
    private int cloneId = -1;
    private String layout;
    private NbStructuredPropertyAccess props;
    private boolean forceFocusWhenFirstOpen;
    private boolean closing;
    private static final TopComponent.SubComponent[] EMPTY_SUB_COMP_ARRAY = new TopComponent.SubComponent[0];
    private static final String UNDO_CLOSE_EDITOR_ACTION_NAME = IdeArb.getString((int)548);
    private static final boolean MIGRATION_STARTED = Boolean.getBoolean("window.manager.not.migration.started");
    private final NodeListener nodeListener = new NodeListener(){

        public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
            NbEditorContainer.this.updateEditorTab(NbEditorContainer.this.getEditor());
        }
    };
    private final Observer observer = new Observer(){

        public void update(Object observed, UpdateMessage change) {
            int messageID = change.getMessageID();
            if (messageID == UpdateMessage.OBJECT_RENAMED || messageID == UpdateMessage.ATTRIBUTE_CHANGED) {
                NbEditorContainer.this.updateEditorTab(NbEditorContainer.this.getEditor());
            }
        }
    };
    private boolean isCloseLast = false;

    public NbEditorContainer() {
    }

    public NbEditorContainer(TabGroupState tabGroupState) {
        this();
        this.tabGroup = tabGroupState.getParentTabGroup();
    }

    public int getPersistenceType() {
        return 1;
    }

    public TopComponent.SubComponent[] getSubComponents() {
        if (this.tabGroup == null || this.tabGroup.getTabGroupState(0) == null) {
            return EMPTY_SUB_COMP_ARRAY;
        }
        final SplitPaneState sps = this.tabGroup.getTabGroupState(0).getSplitPaneState(0);
        DefaultListModel editors = sps.getEditorsModel();
        if (editors.getSize() < 2) {
            return new TopComponent.SubComponent[0];
        }
        TopComponent.SubComponent[] res = new TopComponent.SubComponent[editors.getSize()];
        EditorState activeEditor = sps.getCurrentEditorState();
        for (int i = 0; i < res.length; ++i) {
            DefaultCustomTabPage e = (DefaultCustomTabPage)editors.getElementAt(i);
            final int editorPos = i;
            res[i] = new TopComponent.SubComponent(e.getLabel(), e.getTooltip(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    sps.getSplitPane().getEditorTabs().setSelectedPage(editorPos);
                }
            }, i == sps.getCurrentEditorStatePos());
        }
        return res;
    }

    public void componentOpened() {
        if (this.isClosing()) {
            return;
        }
        this.findClone();
        super.componentOpened();
        Editor editor = this.getEditor();
        if (editor == null) {
            Image imageIcon = ImageUtilities.icon2Image((Icon)LazyIconsCacheUtil.loadIcon((URL)this.getURL()));
            if (imageIcon != null) {
                this.setIcon(imageIcon);
            }
            return;
        }
        Node node = null;
        if (null != editor) {
            node = editor.getContext().getNode();
        }
        if (null != node) {
            node.addNodeListener(this.nodeListener);
            node.attach(this.observer);
        }
        if (!this.initialized) {
            this.initialized = true;
            if (null != this.tabGroup) {
                this.updateEditorTitle(node);
            }
        }
        NbEditorContainer.notifyEditorManager(NbEditorManager.EditorEvent.Opened, editor);
        NbEditorManager.getInstance().addNodeCloseListener(node);
        if (Ide.getMainWindow() instanceof NbMainWindow) {
            NbMainWindow mainWindow = (NbMainWindow)Ide.getMainWindow();
            mainWindow.addControllerProvider((Component)((Object)this), NbEditorManager.getInstance());
        }
    }

    public void componentClosed() {
        Dockable dockable;
        Editor editor;
        if (Ide.isRunning()) {
            LazyIconsCacheUtil.removeIcon((URL)this.getURL());
        }
        if ((editor = this.getEditor()) == null) {
            return;
        }
        super.componentClosed();
        NbEditorContainer.notifyEditorManager(NbEditorManager.EditorEvent.Deactivated, editor);
        NbEditorContainer.notifyEditorManager(NbEditorManager.EditorEvent.Closed, editor);
        Context context = editor.getContext();
        if (context != null && context.getNode() != null) {
            Node node = context.getNode();
            node.removeNodeListener(this.nodeListener);
            node.detach(this.observer);
        }
        if (this.tabGroup != null) {
            this.closeEditors(this.isCloseLast);
        }
        if (Ide.getMainWindow() instanceof NbMainWindow) {
            NbMainWindow mainWindow = (NbMainWindow)Ide.getMainWindow();
            mainWindow.removeControllerProvider((Component)((Object)this));
        }
        this.cleanUp();
        if (EditorManager.getEditorManager().getAllEditors().size() == 0 && (dockable = DockStation.getDockStation().getDockable(new ViewId("ApplicationNavigatorWindow.ApplicationNavigatorName"))) instanceof ApplicationChangeNotifier) {
            ApplicationChangeNotifier acn = (ApplicationChangeNotifier)dockable;
            Workspace workspace = acn.currentApplication();
            Ide.setActiveWorkspace((Workspace)workspace);
            Project project = workspace != null ? workspace.getActiveProject() : null;
            Ide.setActiveProject((Project)project);
        }
    }

    private void closeEditors(boolean isLast) {
        Editor editor = this.getEditor();
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null && editor.getContext().getNode().isOpen()) {
            NbEditorManager.getInstance().setEditorForRecentFile(editor);
        }
        MultiMap contextsAndDocs = new MultiMap();
        int tabGroupStateCount = this.tabGroup.getTabGroupStateCount();
        for (int j = 0; j < tabGroupStateCount; ++j) {
            TabGroupState tabGroupState = this.tabGroup.getTabGroupState(j);
            Context context = new Context(tabGroupState.getContext());
            contextsAndDocs.addAll((Object)context, this.collectEditorNodes(tabGroupState));
        }
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        Command closeNodeCommandObject = CommandProcessor.createCommandFromMeta((MetaClass)closeNodeAction.getCommandMetaClass(), (Context)new Context());
        CloseNodeCommand cmd = closeNodeCommandObject instanceof CloseNodeCommand ? (CloseNodeCommand)closeNodeCommandObject : new CloseNodeCommand();
        this.tabGroup.closeEditors();
        if (!isLast) {
            return;
        }
        for (Map.Entry entry : contextsAndDocs.entrySet()) {
            Context context = (Context)entry.getKey();
            Collection lstDocs = (Collection)entry.getValue();
            cmd.setContext(context);
            cmd.clearAffectedNodes();
            assert (lstDocs != null) : "Bug 6157300 occurred with context " + context;
            HashSet<Node> openedNodes = new HashSet<Node>();
            for (Node node : lstDocs) {
                if (node == null || !node.isOpen()) continue;
                openedNodes.add(node);
            }
            cmd.close(openedNodes.iterator(), context, false, true);
        }
    }

    private Collection<Node> collectEditorNodes(TabGroupState tabGroupState) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashSet<Node> nodeSet = new HashSet<Node>();
        Node node = tabGroupState.getContext().getNode();
        if (node != null) {
            nodes.add(node);
            nodeSet.add(node);
        }
        int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
        for (int k = 0; k < splitPaneStateCount; ++k) {
            SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(k);
            int nbrEditorStates = splitPaneState.getEditorStateCount();
            for (int l = 0; l < nbrEditorStates; ++l) {
                Node[] dependentNodes;
                EditorState editorState = splitPaneState.getEditorState(l);
                Editor editor = editorState.getEditor();
                if (editor == null || (dependentNodes = editor.getDependentNodes()) == null) continue;
                for (int m = 0; m < dependentNodes.length; ++m) {
                    Node depNode = dependentNodes[m];
                    if (depNode == null || nodeSet.contains(depNode)) continue;
                    nodes.add(depNode);
                    nodeSet.add(depNode);
                }
            }
        }
        return nodes;
    }

    public StructuredPropertyAccess saveLayout(StructuredPropertyAccess res, boolean forceSave) {
        if (res == null) {
            res = new NbStructuredPropertyAccess("root");
        }
        if (null != this.tabGroup) {
            this.tabGroup.saveLayout((StructuredPropertyAccess)res, forceSave);
        }
        return res;
    }

    protected String preferredID() {
        return "EditorContainer";
    }

    @Override
    protected void componentActivated() {
        super.componentActivated();
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue();
        AWTEvent event = EventQueue.getCurrentEvent();
        if (event != null && event.getSource() instanceof CustomTab) {
            return;
        }
        if (editor != null) {
            NbEditorContainer.notifyEditorManager(NbEditorManager.EditorEvent.Activated, editor);
            if (!this.noFocusOnActivation && !Ide.isStarting()) {
                this.getTabGroup().focusCurrentEditor();
            }
        }
        this.noFocusOnActivation = false;
    }

    protected CloneableTopComponent createClonedObject() {
        NbEditorContainer clone = NbEditorManager.getInstance().cloneEditor(this);
        if (this.cloneId < 0) {
            this.cloneId = NbEditorContainer.getNextCloneId();
        }
        clone.cloneId = this.cloneId;
        return clone;
    }

    public void requestActive() {
        super.requestActive();
    }

    public void requestActiveWithoutFocus() {
        this.noFocusOnActivation = true;
    }

    @Override
    protected void componentDeactivated() {
        super.componentDeactivated();
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        NbEditorContainer.notifyEditorManager(NbEditorManager.EditorEvent.Deactivated, editor);
    }

    protected void componentHidden() {
        super.componentHidden();
        Editor e = this.getEditor();
        SplitPane splitPane = this.getTabGroup().getCurrentSplitPane();
        if (null != e && splitPane != null) {
            splitPane.riseEditorHidden(e);
        }
        if (null != this.tabGroup) {
            this.contentPanel.remove(this.tabGroup);
        }
    }

    protected void componentShowing() {
        if (this.isClosing()) {
            return;
        }
        super.componentShowing();
        if (this.getEditor() == null && this.layout != null || !this.initialized) {
            this.loadTabGroup();
            this.componentOpened();
            this.forceFocusWhenFirstOpen = true;
            this.componentActivated();
        }
        if (null != this.tabGroup) {
            this.contentPanel.add((Component)this.tabGroup, "Center");
        }
        this.getEditor().getGUI();
        SplitPane splitPane = this.getTabGroup().getCurrentSplitPane();
        if (splitPane != null) {
            splitPane.riseEditorShown(this.getEditor());
        }
        this.updateEditorTab(this.getEditor());
    }

    private static void notifyEditorManager(NbEditorManager.EditorEvent evt, Editor editor) {
        EditorManager em = EditorManager.getEditorManager();
        if (!(em instanceof NbEditorManager)) {
            Logger.getLogger(NbEditorContainer.class.getName()).log(Level.CONFIG, "NbEditorManager impl not found");
            return;
        }
        ((NbEditorManager)em).handleEditorEvent(evt, editor);
    }

    public Editor getEditor() {
        Editor res = null;
        if (null != this.tabGroup) {
            res = this.tabGroup.getCurrentEditor();
        }
        return res;
    }

    public TabGroup getTabGroup() {
        return this.tabGroup;
    }

    public Action[] getActions() {
        Action[] defaultActions = super.getActions();
        Action[] res = new Action[defaultActions.length + 5];
        int cloneIndex = -1;
        Action nbCloneAction = null;
        for (Action a : defaultActions) {
            ++cloneIndex;
            if (null == a || !"clone".equals(a.getValue("_nb_action_id_"))) continue;
            nbCloneAction = a;
            break;
        }
        if (cloneIndex > 0) {
            System.arraycopy(defaultActions, 0, res, 0, cloneIndex + 1);
        }
        if (nbCloneAction != null) {
            res[cloneIndex] = new CloneActionDelegate(nbCloneAction);
        }
        res[cloneIndex + 1] = new SplitEditorAction(this, true);
        res[cloneIndex + 2] = new SplitEditorAction(this, false);
        res[cloneIndex + 3] = new UnSplitEditorAction(this);
        if (cloneIndex < defaultActions.length - 1) {
            System.arraycopy(defaultActions, cloneIndex + 1, res, cloneIndex + 4, defaultActions.length - cloneIndex - 1);
        }
        res[res.length - 2] = null;
        if (!MenuCustomizationsHelper.isHidden((String)"working-set-add-to-working-set")) {
            res[res.length - 1] = this.createAddToWorkingSetAction();
        }
        ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(res));
        UndoCloseEditorAction reopenAction = new UndoCloseEditorAction();
        actions.add(3, reopenAction);
        res = actions.toArray(new Action[actions.size()]);
        return res;
    }

    public boolean canClose() {
        this.isCloseLast = false;
        if (Boolean.TRUE.equals(this.getClientProperty("NoCanCloseCheck"))) {
            return true;
        }
        return super.canClose();
    }

    protected boolean closeLast() {
        this.isCloseLast = true;
        if (Boolean.TRUE.equals(this.getClientProperty("NoCanCloseCheck"))) {
            return true;
        }
        Editor editor = this.getEditor();
        if (editor == null) {
            return true;
        }
        editor.prepareForSaving(true);
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        Command closeNodeCommandObject = CommandProcessor.createCommandFromMeta((MetaClass)closeNodeAction.getCommandMetaClass(), (Context)new Context());
        CloseNodeCommand cmd = closeNodeCommandObject instanceof CloseNodeCommand ? (CloseNodeCommand)closeNodeCommandObject : new CloseNodeCommand();
        return cmd.checkSave(this.collectEditorNodes(this.tabGroup.getTabGroupState(0)).iterator()) != 1;
    }

    void updateEditorTab(final Editor e) {
        if (null == e || e.getContext() == null) {
            return;
        }
        final Node n = e.getContext().getNode();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (null != n && n.isDirty()) {
                    NbEditorContainer.this.setHtmlDisplayName("<html><i>" + n.getShortLabel());
                } else {
                    NbEditorContainer.this.setHtmlDisplayName(e.getTabLabel());
                }
                NbEditorContainer.this.setDisplayName(e.getTabLabel());
                NbEditorContainer.this.updateIcon(n, e);
                if (NbEditorContainer.this.getIcon() != null) {
                    NbAcceleratorsActions.updateAcceleratorIcon(NbEditorContainer.this);
                }
                NbEditorContainer.this.setToolTipText(NbEditorContainer.this.getToolTip(e));
                NbEditorContainer.this.updateLayoutBackup();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void updateEditorTab(final Node node) {
        if (null == node) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (null != node && node.isDirty()) {
                    NbEditorContainer.this.setHtmlDisplayName("<html><i>" + node.getShortLabel());
                } else {
                    NbEditorContainer.this.setHtmlDisplayName("<html>" + node.getShortLabel());
                }
                NbEditorContainer.this.setDisplayName(node.getShortLabel());
                NbEditorContainer.this.updateIcon(node, NbEditorContainer.this.getEditor());
                if (NbEditorContainer.this.getIcon() != null) {
                    NbAcceleratorsActions.updateAcceleratorIcon(NbEditorContainer.this);
                }
                NbEditorContainer.this.setToolTipText(node.getURL().getPath());
                NbEditorContainer.this.updateLayoutBackup();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private Action createAddToWorkingSetAction() {
        int addToWorkingSetId = Ide.findOrCreateCmdID((String)"working-set-add-to-working-set");
        IdeAction addToWorkingSetAction = null;
        if (null != this.getEditor() && null != (addToWorkingSetAction = IdeAction.newLocalAction((int)addToWorkingSetId, (View)this.getEditor()))) {
            addToWorkingSetAction.updateAction(this.getEditor().getContext());
            String modifiedName = this.createMnemonicForJdevAction((Integer)addToWorkingSetAction.getValue("MnemonicKey"), (String)addToWorkingSetAction.getValue("Name"));
            if (modifiedName != null) {
                addToWorkingSetAction.putValue("Name", (Object)modifiedName);
            }
        }
        return addToWorkingSetAction;
    }

    synchronized void activateEditor(Class editorClass) {
        if (null == this.tabGroup) {
            return;
        }
        SplitPane sp = this.tabGroup.getTabGroupState(0).getSplitPaneState(0).getSplitPane();
        int editorPos = sp.searchEditorClassPos(editorClass);
        if (editorPos >= 0) {
            sp.setCurrentEditorStatePos(editorPos);
        }
    }

    private String getToolTip(Editor editor) {
        TabGroupState tgs = this.tabGroup.getTabGroupState(0);
        if (tgs == null || tgs.getLongLabel() == null || tgs.getLongLabel().length() == 0) {
            return editor.getTabDescription();
        }
        return tgs.getLongLabel();
    }

    private void updateIcon(Node node, Editor editor) {
        Icon icon = null;
        if (node != null && node.getIcon() != null) {
            icon = node.getIcon();
        }
        if (icon == null && editor != null) {
            icon = editor.getTabIcon();
        }
        if (icon != null) {
            this.setIcon(ImageUtilities.icon2Image((Icon)icon));
        }
        LazyIconsCacheUtil.addIcon((URL)this.getURL(), (Icon)icon, (boolean)false);
    }

    private String createMnemonicForJdevAction(Integer mnemonic, String actionName) {
        if (mnemonic == null || actionName == null || actionName.contains("&")) {
            return actionName;
        }
        String mnemonicKey = KeyEvent.getKeyText(mnemonic);
        if (mnemonicKey == null || !actionName.contains(mnemonicKey)) {
            return actionName;
        }
        String modifiedName = actionName.replace(mnemonicKey, "&" + mnemonicKey);
        return modifiedName;
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        NbDockStation dockStation = (NbDockStation)NbDockStation.getDockStation();
        if (Ide.getIdeArgs().hasArg("-noreopen") && Ide.isStarting() || dockStation.isPreferencesBroken()) {
            this.close();
            return;
        }
        super.readExternal(oi);
        this.cloneId = oi.readInt();
        NbEditorContainer.updateCloneCounter(this.cloneId);
        if (this.cloneId > cloneCounter.get()) {
            cloneCounter.set(this.cloneId + 1);
        }
        String layout_ = null;
        try {
            layout_ = (String)oi.readObject();
        }
        catch (Exception ex) {
            layout_ = this.getName();
        }
        if (layout_ == null) {
            return;
        }
        this.layout = layout_;
        if (this.props == null) {
            this.loadProps();
        }
        Iterator childNodes = this.props.getChildNodes("state");
        int acceleratorNumber = -1;
        if (childNodes.hasNext()) {
            StructuredPropertyAccess element = (StructuredPropertyAccess)childNodes.next();
            acceleratorNumber = element.getIntegerProperty("accelerator", -1);
        }
        if (!LAZY_LOADING_DISABLED && acceleratorNumber < 0 && !MIGRATION_STARTED) {
            this.tabGroup = new TabGroup();
        } else {
            this.loadTabGroup();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (null == this.tabGroup) {
            return new TopComponentWhichDoesNotOpen();
        }
        return this;
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeInt(this.cloneId);
        if (this.getEditor() != null && this.tabGroup.getCurrentTabGroupState().isRestorableAtStartup()) {
            StructuredPropertyAccess props = this.saveLayout(null, false);
            this.layout = NbStructuredPropertyAccess.toString(props);
            if (Ide.isQuitting()) {
                if (NbAcceleratorsActions.getEditorHasAccelerator(this) < 0) {
                    Icon icon = null;
                    if (this.getEditor().getContext() != null && this.getEditor().getContext().getNode() != null) {
                        icon = this.getEditor().getContext().getNode().getIcon();
                    }
                    if (icon == null) {
                        icon = ImageUtilities.image2Icon((Image)this.getIcon());
                    }
                    LazyIconsCacheUtil.addIcon((URL)this.getURL(), (Icon)icon, (boolean)true);
                }
            } else {
                this.layout = null;
            }
        } else if (this.getEditor() == null && this.props != null && !this.initialized) {
            this.layout = NbStructuredPropertyAccess.toString((StructuredPropertyAccess)this.props);
        }
        try {
            if (this.layout != null) {
                oo.writeObject(this.layout);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextCloneId() {
        AtomicInteger atomicInteger = cloneCounter;
        synchronized (atomicInteger) {
            return cloneCounter.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCloneCounter(int existingCloneId) {
        if (existingCloneId < 0) {
            return;
        }
        AtomicInteger atomicInteger = cloneCounter;
        synchronized (atomicInteger) {
            if (cloneCounter.get() <= existingCloneId) {
                cloneCounter.set(existingCloneId + 1);
            }
        }
    }

    private void findClone() {
        if (this.cloneId < 0) {
            return;
        }
        for (TopComponent tc : NbEditorContainer.getRegistry().getOpened()) {
            if (tc == this || !(tc instanceof NbEditorContainer)) continue;
            NbEditorContainer ec = (NbEditorContainer)tc;
            if (ec.cloneId != this.cloneId) continue;
            this.setReference(ec.getReference());
            return;
        }
    }

    boolean match(URL url) {
        URL currentEditorURL;
        if (this.getEditor() != null && EditorUtil.isSameURL(currentEditorURL = this.getEditor().getContext().getNode().getURL(), url)) {
            this.updateURL(url);
            return true;
        }
        this.loadProps();
        if (this.props == null) {
            return false;
        }
        Iterator childNodes = this.props.getChildNodes("state");
        URL propsURL = null;
        if (childNodes.hasNext()) {
            StructuredPropertyAccess element = (StructuredPropertyAccess)childNodes.next();
            propsURL = EditorUtil.getURL("document", element);
        }
        if (EditorUtil.isSameURL(propsURL, url)) {
            this.updateURL(url);
            return true;
        }
        return false;
    }

    public void loadTabGroup() {
        if (this.getEditor() == null) {
            if (this.props == null) {
                this.loadProps();
            }
            if (this.props != null) {
                this.tabGroup = TabGroup.loadLayout((StructuredPropertyAccess)this.props);
                if (this.getEditor() == null) {
                    this.close();
                } else {
                    this.updateEditorTab(this.getEditor());
                }
            }
        }
    }

    private void loadProps() {
        if (this.props != null || this.layout == null) {
            return;
        }
        try {
            this.props = NbStructuredPropertyAccess.fromString(this.layout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    void updateURL(URL newURL) {
        if (this.props == null) {
            this.loadProps();
        }
        EditorUtil.updateURL(newURL, this.props);
    }

    void updateProject(Project project, Editor editor) {
        if (this.props == null) {
            this.loadProps();
        }
        EditorUtil.updateProject(project, this.props);
        if (editor == null) {
            return;
        }
        Context editorContext = editor.getContext();
        if (editorContext == null) {
            return;
        }
        editorContext.setProject(project);
        editor.setContext(editorContext);
        int count = this.getTabGroup().getTabGroupStateCount();
        for (int i = 0; i < count; ++i) {
            Context stateContext;
            TabGroupState state = this.getTabGroup().getTabGroupState(i);
            if (state == null || (stateContext = state.getContext()) == null) continue;
            stateContext.setProject(project);
            state.setContext(stateContext);
        }
    }

    void updateEditorTitle(Node node) {
        if (this.getEditor() != null) {
            this.updateEditorTab(this.getEditor());
        } else {
            this.updateEditorTab(node);
        }
    }

    Project getProject() {
        if (this.props == null) {
            this.loadProps();
        }
        return EditorUtil.getProject(this.props);
    }

    public boolean forceFocusWhenFirstOpen() {
        boolean forceFocus = !this.noFocusOnActivation && this.forceFocusWhenFirstOpen;
        this.forceFocusWhenFirstOpen = false;
        return forceFocus;
    }

    void setClosing(boolean closing) {
        this.closing = closing;
    }

    private boolean isClosing() {
        return this.closing;
    }

    URL getURL() {
        Editor editor = this.getEditor();
        if (editor != null) {
            Context context = editor.getContext();
            return context != null && context.getNode() != null ? context.getNode().getURL() : null;
        }
        Iterator childNodes = this.props.getChildNodes("state");
        URL propsURL = null;
        if (childNodes.hasNext()) {
            StructuredPropertyAccess element = (StructuredPropertyAccess)childNodes.next();
            propsURL = EditorUtil.getURL("document", element);
        }
        return propsURL;
    }

    private void updateLayoutBackup() {
        if (this.getEditor() != null && this.tabGroup.getCurrentTabGroupState().isRestorableAtStartup() || this.getEditor() == null && this.props != null && !this.initialized) {
            this.setName(this.layout);
        }
    }

    private class UndoCloseEditorAction
    extends AbstractAction {
        private UndoCloseEditorAction() {
            this.putValue("Name", UNDO_CLOSE_EDITOR_ACTION_NAME);
        }

        @Override
        public boolean isEnabled() {
            RecentFilesLRU recentFilesLRU = NbEditorManager.getInstance().getRecentFilesLRU();
            RecentFile recentFile = this.getRecentFile(recentFilesLRU);
            if (recentFile == null) {
                return false;
            }
            Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
            if (recentFile.getNodeURL() != null && currentEditor != null && EditorUtil.isSameURL(currentEditor.getContext().getNode().getURL(), recentFile.getNodeURL())) {
                return false;
            }
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RecentFilesLRU recentFilesLRU = NbEditorManager.getInstance().getRecentFilesLRU();
            RecentFile recentFile = this.getRecentFile(recentFilesLRU);
            recentFilesLRU.openRecentFile(recentFile);
        }

        private RecentFile getRecentFile(RecentFilesLRU recentFilesLRU) {
            if (recentFilesLRU == null) {
                return null;
            }
            RecentFile[] recentFiles = recentFilesLRU.getRecentFiles(false);
            if (recentFiles == null || recentFiles.length == 0) {
                return null;
            }
            return recentFiles[0];
        }
    }

    private class CloneActionDelegate
    implements Action {
        private Action nbCloneAction;

        public CloneActionDelegate(Action nbCloneAction) {
            this.nbCloneAction = nbCloneAction;
        }

        @Override
        public Object getValue(String key) {
            return this.nbCloneAction.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.nbCloneAction.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this.nbCloneAction.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            Editor editor = NbEditorContainer.this.getEditor();
            Context editorContext = null;
            if (editor != null) {
                editorContext = editor.getContext();
            }
            if (editorContext != null) {
                return NbEditorManager.getInstance().isDocumentCloneable(editorContext);
            }
            return this.nbCloneAction.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.nbCloneAction.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.nbCloneAction.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.nbCloneAction.actionPerformed(e);
        }
    }

    private static class TopComponentWhichDoesNotOpen
    extends TopComponent {
        private TopComponentWhichDoesNotOpen() {
        }

        public void componentOpened() {
            this.close();
        }

        public void open() {
            this.close();
        }

        public int getPersistenceType() {
            return 2;
        }
    }
}

