/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.util.RDFXMLContentHandler;
import oracle.spatial.rdf.util.XMLInputStream;
import oracle.sql.CLOB;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class RDFXMLParser {
    private static void log(String string, int n) {
        if ((n & 0x80) == 128) {
            System.out.print("\n");
            System.out.print(string);
        }
    }

    private static void parseRDFXMLStream(InputStream inputStream, String string, int n, int n2, ArrayList<String> arrayList, String string2, String string3) throws IOException, SAXException, SQLException {
        RDFXMLContentHandler rDFXMLContentHandler = (n2 & 2) == 2 ? new RDFXMLContentHandler(arrayList, string, n, n2, string2, string3) : new RDFXMLContentHandler(null, string, n, n2, string2, string3);
        InputStream inputStream2 = (n2 & 1) == 1 ? new XMLInputStream(inputStream) : inputStream;
        ParserAdapter parserAdapter = new ParserAdapter((Parser)new SAXParser());
        parserAdapter.setContentHandler(rDFXMLContentHandler);
        parserAdapter.parse(new InputSource(inputStream2));
    }

    public static void parseRDFXML(CLOB cLOB, String string, int n, int n2, String string2, String string3) throws RDFException {
        RDFXMLParser.log("parseRDFXML: docid=" + string + " modelid=" + n + " options=" + n2 + "\n", n2);
        RDFXMLParser.log("parseRDFXML: staging_table=" + string2 + " part_name=" + string3 + "\n", n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            RDFXMLParser.log("parseRDFXML: calling Stream: docid=" + string + " modelid=" + n + " options=" + n2 + "\n", n2);
            RDFXMLParser.parseRDFXMLStream(cLOB.getAsciiStream(), string, n, n2, arrayList, string2, string3);
            RDFXMLParser.log("parseRDFXML: ...DONE Stream: docid=" + string + " modelid=" + n + " options=" + n2 + "\n", n2);
        }
        catch (SQLException sQLException) {
            throw new RDFException("Error extracting RDFXML content from CLOB :" + sQLException.getMessage());
        }
        catch (IOException iOException) {
            throw new RDFException("IOException: Error reading data from the stream: " + iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new RDFException("RDFXML Parse Exception :" + sAXException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws IOException, SAXException, SQLException {
        String string = "&lt;rdf:RDF xmlns:rdf=&quot;http://www.w3.org/1999/02/22-rdf-syntax-ns#&quot; xmlns:c=&quot;http://s.opencalais.com/1/pred/&quot;&gt;&lt;rdf:Description c:calaisRequestID=&quot;ef312504-b7d9-4e52-bae1-4fb61bc2ae91&quot; c:id=&quot;http://id.opencalais.com/uOdph0AJVwTrkw4MjJ4nUw&quot; rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/DocInfo&quot;/&gt;&lt;c:document&gt;&lt;![CDATA[The strongest rain ever recorded in India shut down the financial hub of Mumbai, snapped communication lines, closed airports and forced thousands of people to sleep in their offices or walk home during the night, officials said today.]]&gt;&lt;/c:document&gt;&lt;c:docTitle/&gt;&lt;c:docDate&gt;2009-02-13&lt;/c:docDate&gt;&lt;/rdf:Description&gt;&lt;rdf:Description c:contentType=&quot;TEXT/raw&quot; c:emVer=&quot;UnifiedIM-DJ&quot; c:langIdVer=&quot;DefaultLangId&quot; c:language=&quot;English&quot; c:processingVer=&quot;CalaisJob01&quot; c:submissionDate=&quot;2009-02-13 16:18:13.060&quot; rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/meta&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/DocInfoMeta&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:submitterCode&gt;08485e29-a9fa-e6d7-65c5-12a54cae74db&lt;/c:submitterCode&gt;&lt;c:signature&gt;digestalg-1|lCgyO7FZ9TIZN38Zy8gIqpeGInw=|L0JbAIhoW/YgmV9MfPUWn0njq9A4+oj8OCv/5E3L6MIQmKOFz9JS1w==&lt;/c:signature&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/lid/DefaultLangId&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/lid/DefaultLangId&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:lang rdf:resource=&quot;http://d.opencalais.com/lid/DefaultLangId/English&quot;/&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/cat/1&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/cat/DocCat&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:category rdf:resource=&quot;http://d.opencalais.com/cat/Calais/BusinessFinance&quot;/&gt;&lt;c:classifierName&gt;Calais&lt;/c:classifierName&gt;&lt;c:categoryName&gt;Business_Finance&lt;/c:categoryName&gt;&lt;c:score&gt;0.483&lt;/c:score&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/genericHasher-1/6293fd3d-7bd5-3a94-a823-6abc6fdf2232&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/em/r/CompanyReorganization&quot;/&gt;&lt;c:status&gt;announced&lt;/c:status&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/Instance/1&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/InstanceInfo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/6293fd3d-7bd5-3a94-a823-6abc6fdf2232&quot;/&gt;&lt;!--CompanyReorganization: status: announced; --&gt;&lt;c:detection&gt;[]The strongest rain ever recorded in India shut down the financial hub of Mumbai, snapped communication lines, closed airports and forced thousands of people to sleep in their offices or walk home during the night, officials said today.[]&lt;/c:detection&gt;&lt;c:prefix/&gt;&lt;c:exact&gt;The strongest rain ever recorded in India shut down the financial hub of Mumbai, snapped communication lines, closed airports and forced thousands of people to sleep in their offices or walk home during the night, officials said today.&lt;/c:exact&gt;&lt;c:suffix/&gt;&lt;c:offset&gt;0&lt;/c:offset&gt;&lt;c:length&gt;235&lt;/c:length&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/genericHasher-1/06a99ff2-3761-34b7-8f2a-0a76ccf6794d&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/em/e/City&quot;/&gt;&lt;c:name&gt;Mumbai&lt;/c:name&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/Instance/2&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/InstanceInfo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/06a99ff2-3761-34b7-8f2a-0a76ccf6794d&quot;/&gt;&lt;!--City: Mumbai; --&gt;&lt;c:detection&gt;[ recorded in India shut down the financial hub of ]Mumbai[, snapped communication lines, closed airports]&lt;/c:detection&gt;&lt;c:prefix&gt; recorded in India shut down the financial hub of &lt;/c:prefix&gt;&lt;c:exact&gt;Mumbai&lt;/c:exact&gt;&lt;c:suffix&gt;, snapped communication lines, closed airports&lt;/c:suffix&gt;&lt;c:offset&gt;73&lt;/c:offset&gt;&lt;c:length&gt;6&lt;/c:length&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/Relevance/1&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/RelevanceInfo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/06a99ff2-3761-34b7-8f2a-0a76ccf6794d&quot;/&gt;&lt;c:relevance&gt;0.571&lt;/c:relevance&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/er/geo/ralg-geo1/ac6f4ab8-e3fd-d98d-2e36-0fd7abfc4c53&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/er/Geo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;!--Mumbai--&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/06a99ff2-3761-34b7-8f2a-0a76ccf6794d&quot;/&gt;&lt;c:name&gt;Mumbai,Maharashtra,India&lt;/c:name&gt;&lt;c:latitude&gt;18.964722&lt;/c:latitude&gt;&lt;c:longitude&gt;72.825836&lt;/c:longitude&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/er/geo/ralg-geo1/11a98374-ebec-8e0c-7a54-751d2161804d&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/er/Geo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;!--India--&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/69b2e356-c1e7-3f3b-bab3-676f21d08e4d&quot;/&gt;&lt;c:name&gt;India&lt;/c:name&gt;&lt;c:latitude&gt;21.767889&lt;/c:latitude&gt;&lt;c:longitude&gt;78.87176&lt;/c:longitude&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/genericHasher-1/69b2e356-c1e7-3f3b-bab3-676f21d08e4d&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/em/e/Country&quot;/&gt;&lt;c:name&gt;India&lt;/c:name&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/Instance/3&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/InstanceInfo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/69b2e356-c1e7-3f3b-bab3-676f21d08e4d&quot;/&gt;&lt;!--Country: India; --&gt;&lt;c:detection&gt;[strongest rain ever recorded in ]India[ shut down the financial hub of Mumbai, snapped]&lt;/c:detection&gt;&lt;c:prefix&gt;strongest rain ever recorded in &lt;/c:prefix&gt;&lt;c:exact&gt;India&lt;/c:exact&gt;&lt;c:suffix&gt; shut down the financial hub of Mumbai, snapped&lt;/c:suffix&gt;&lt;c:offset&gt;36&lt;/c:offset&gt;&lt;c:length&gt;5&lt;/c:length&gt;&lt;/rdf:Description&gt;&lt;rdf:Description rdf:about=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b/Relevance/2&quot;&gt;&lt;rdf:type rdf:resource=&quot;http://s.opencalais.com/1/type/sys/RelevanceInfo&quot;/&gt;&lt;c:docId rdf:resource=&quot;http://d.opencalais.com/dochash-1/7779af58-8432-3f91-9747-fade44c5884b&quot;/&gt;&lt;c:subject rdf:resource=&quot;http://d.opencalais.com/genericHasher-1/69b2e356-c1e7-3f3b-bab3-676f21d08e4d&quot;/&gt;&lt;c:relevance&gt;0.571&lt;/c:relevance&gt;&lt;/rdf:Description&gt;&lt;/rdf:RDF&gt;";
        String string2 = "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><rdf:Description rdf:about=\"http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine\">    <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Ontology\"/>    <rdfs:label>Wine Ontology</rdfs:label>    <rdfs:comment>Derived from the DAML Wine ontology at       http://ontolingua.stanford.edu/doc/chimaera/ontologies/wines.daml      Substantially changed, in particular the Region based relations.    </rdfs:comment>    <owl:imports rdf:resource=\"http://www.w3.org/TR/2003/PR-owl-guide-20031209/food\"/>    <owl:priorVersion rdf:resource=\"http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine\"/>    <rdfs:comment>An example OWL ontology</rdfs:comment>  </rdf:Description></rdf:RDF>";
        ArrayList<String> arrayList = new ArrayList<String>();
        RDFXMLParser.parseRDFXMLStream(new ByteArrayInputStream(string2.getBytes()), "dummy-docid", 1, 2, arrayList, "mdsys.transient_rdf_triple$", null);
        for (int i = 0; i < arrayList.size(); i += 3) {
            System.out.println("Triple :" + (i / 3 + 1));
            System.out.println("  Subject : " + arrayList.get(i));
            System.out.println("    Property : " + arrayList.get(i + 1));
            System.out.println("       Object : " + arrayList.get(i + 2));
        }
        System.out.println("Triples processed");
    }
}

