/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import oracle.spatial.rdf.server.LiteralSet;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFRuntimeException;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.parser.sparql.ASTInput;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.sparqlIdent;
import oracle.spatial.rdf.server.sparqlPredicate;
import oracle.spatial.rdf.server.sparqlVPDConstraint;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class sparqlSemAnalyzer {
    public static final boolean TRACE = false;
    String policyRid = null;
    String contextName = null;
    int defEnb = 1;
    URIset uriSet = null;
    LiteralSet litSet = null;
    Hashtable<String, sparqlIdent> qryIdents;
    Hashtable<String, sparqlPredicate> qryPreds;
    ArrayList<SimpleNode> groupGraphNodes;
    Connection conn;
    static final int INSTR_CODE_TRIPLEP = 1;
    static final int INSTR_CODE_OBJVAR = 16;
    static final int INSTR_CODE_OBJFNC = 32;
    static final int INSTR_CODE_PRDVAR = 64;
    static final int INSTR_CODE_PRDFNC = 128;
    static final int INSTR_CODE_SUBVAR = 256;
    static final int INSTR_CODE_SUBFNC = 512;
    static final String pq_stmt = new String(" select vpd_polrid, context_name, decode(context_name, null, 0, (select count(*) from session_context where namespace = context_name and  not(attribute like 'RDFVPD$%') and value = '1')) anygrp, decode(context_name, null, 0, sys_context(context_name, 'RDFVPD$FULLACCESS')) fullacc  from (select distinct vm.vpd_polrid from (select model_id from mdsys.rdf_model_internal$ rmi, table(cast(:1 as sys.ODCIVarchar2List)) ill where rmi.model_name = ill.column_value) mls left outer join   mdsys.rdfvpd_models$ vm on mls.model_id = vm.model_id and bitand(vm.operation,1) > 0) apl  left outer join mdsys.rdfvpd_policies$ vp on vp.rowid = apl.vpd_polrid order by 1 nulls last ");

    public sparqlSemAnalyzer(String[] stringArray, boolean bl, Connection connection, URIset uRIset, LiteralSet literalSet) throws RDFException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        int n = 0;
        this.conn = connection;
        this.qryIdents = new Hashtable();
        this.qryPreds = new Hashtable();
        this.groupGraphNodes = new ArrayList();
        this.uriSet = uRIset;
        this.litSet = literalSet;
        if (bl) {
            try {
                preparedStatement = connection.prepareStatement(pq_stmt);
                preparedStatement.setArray(1, (Array)this.makeSQLArray(stringArray, "SYS.ODCIVARCHAR2LIST"));
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    this.policyRid = null;
                    this.contextName = null;
                } else {
                    this.policyRid = resultSet.getString(1);
                    this.contextName = resultSet.getString(2);
                    this.defEnb = this.contextName != null ? ((n = resultSet.getInt(3)) > 0 ? 0 : 1) : 1;
                    string = resultSet.getString(4);
                    if (string != null && string.equals("1")) {
                        this.policyRid = null;
                        this.contextName = null;
                        while (resultSet.next()) {
                            string = resultSet.getString(4);
                            if (resultSet.getString(1) == null || string != null && string.equals("1")) continue;
                            throw new RDFException("model set may only use a single VPD policy");
                        }
                    } else if (resultSet.next()) {
                        throw new RDFException("model set may only use a single VPD policy");
                    }
                }
                resultSet.close();
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw new RDFException("error fetching VPD policy: " + sQLException.getMessage());
            }
        }
    }

    public void validateForVPD() throws RDFException {
        for (String string : this.qryIdents.keySet()) {
            sparqlIdent sparqlIdent2 = this.qryIdents.get(string);
            if (!sparqlIdent2.hasFlags(33)) continue;
            throw new RDFException("invalid use of variable in predicate position with VPD");
        }
    }

    private SimpleNode getTailTriplesBlock(SimpleNode simpleNode) throws RDFException {
        for (SimpleNode simpleNode2 = simpleNode; simpleNode2 != null; simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(3)) {
            if (simpleNode2.jjtGetNumChildren() == 3) {
                return simpleNode2;
            }
            if (simpleNode2.jjtGetNumChildren() == 4 && ((SimpleNode)simpleNode2.jjtGetChild((int)3)).id == 47) {
                continue;
            }
            throw new RDFException("[Internal Error] could not find tail end of the triples block ");
        }
        throw new RDFException("[Internal Error] could not find tail end of the triples block 2 ");
    }

    public void applyVPDPolicy(SimpleNode simpleNode) throws RDFException {
        if (this.policyRid == null) {
            return;
        }
        this.collectMetadata(simpleNode);
        sparqlIdent.glbVarIdx = 1;
        for (int i = 0; i < this.groupGraphNodes.size(); ++i) {
            SimpleNode simpleNode2 = null;
            SimpleNode simpleNode3 = null;
            SimpleNode simpleNode4 = null;
            for (sparqlIdent sparqlIdent2 : this.qryIdents.values()) {
                simpleNode2 = sparqlIdent2.getConstraintNode(i);
                if (simpleNode3 == null) {
                    simpleNode3 = simpleNode2;
                    continue;
                }
                if (simpleNode2 == null) continue;
                simpleNode4 = this.getTailTriplesBlock(simpleNode3);
                simpleNode2.jjtSetParent(simpleNode4);
                simpleNode4.jjtAddChild(simpleNode2, simpleNode4.jjtGetNumChildren());
            }
            for (sparqlPredicate sparqlPredicate2 : this.qryPreds.values()) {
                simpleNode2 = sparqlPredicate2.getConstraintNode(i);
                if (simpleNode3 == null) {
                    simpleNode3 = simpleNode2;
                    continue;
                }
                if (simpleNode2 == null) continue;
                simpleNode4 = this.getTailTriplesBlock(simpleNode3);
                simpleNode2.jjtSetParent(simpleNode4);
                simpleNode4.jjtAddChild(simpleNode2, simpleNode4.jjtGetNumChildren());
            }
            if (simpleNode3 == null) continue;
            SimpleNode simpleNode5 = this.groupGraphNodes.get(i);
            Object var7_10 = null;
            if (simpleNode5.id != 48) {
                throw new RDFException("[Internal Error] applyVPDConstract : JJTGROUPGRAPHPATTERN not found");
            }
            if (simpleNode5.jjtGetNumChildren() == 0) {
                throw new RDFException("[Internal Error] applyVPDConstract : GGP has no children");
            }
            SimpleNode simpleNode6 = (SimpleNode)simpleNode5.jjtGetChild(0);
            if (simpleNode6.id != 47) {
                throw new RDFException("[Internal Error] applyVPDConstract : No triples block in GGP");
            }
            simpleNode4 = this.getTailTriplesBlock(simpleNode6);
            simpleNode3.jjtSetParent(simpleNode4);
            simpleNode4.jjtAddChild(simpleNode3, simpleNode4.jjtGetNumChildren());
        }
    }

    private void applyVPDConstraint(sparqlVPDConstraint sparqlVPDConstraint2) throws RDFException {
        if (sparqlVPDConstraint2.constraintType.equals("C")) {
            for (sparqlIdent sparqlIdent2 : this.qryIdents.values()) {
                sparqlIdent2.setVPDConstraint(sparqlVPDConstraint2);
            }
        } else {
            for (sparqlPredicate sparqlPredicate2 : this.qryPreds.values()) {
                sparqlPredicate2.setVPDConstraint(sparqlVPDConstraint2);
            }
        }
    }

    protected ARRAY makeSQLArray(ArrayList<String> arrayList, String string) throws SQLException {
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)this.conn);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, this.conn, (Object)stringArray);
        return aRRAY;
    }

    protected ARRAY makeSQLArray(String[] stringArray, String string) throws SQLException {
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)this.conn);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, this.conn, (Object)stringArray);
        return aRRAY;
    }

    private void collectMetadata(SimpleNode simpleNode) throws RDFException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.collect(simpleNode, 0, 0);
        try {
            Object object;
            preparedStatement = this.conn.prepareStatement("select predicate, hasdomain, hasrange from mdsys.rdfvpd_predicate_mdata$ pm,   table(cast(:1 as sys.odcivarchar2list)) pl where policy_rid = :2 and  pm.predicate = pl.column_value");
            for (String string : this.qryPreds.keySet()) {
                if (this.qryIdents.get(string).hasFlags(2)) {
                    if (string.equals("834132227519661324")) {
                        this.qryPreds.get(string).setRDFTypeForSubject(arrayList2);
                    }
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                    continue;
                }
                throw new RDFException("invalid use of variable in predicate position with VPD");
            }
            if (arrayList.size() > 0) {
                preparedStatement.setArray(1, (Array)this.makeSQLArray(arrayList, "SYS.ODCIVARCHAR2LIST"));
                preparedStatement.setString(2, this.policyRid);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string;
                    object = this.qryPreds.get(new String(resultSet.getString(1)));
                    string = resultSet.getString(2);
                    if (string != null && !arrayList2.contains(string)) {
                        arrayList2.add(string);
                    }
                    ((sparqlPredicate)object).setDomainType(string);
                    string = resultSet.getString(3);
                    if (string != null && !arrayList2.contains(string)) {
                        arrayList2.add(string);
                    }
                    ((sparqlPredicate)object).setRangeType(string);
                    ((sparqlPredicate)object).collectVariableTypes();
                }
                resultSet.close();
                preparedStatement.close();
            }
            arrayList.addAll(arrayList2);
            if (arrayList.size() > 0) {
                if (this.contextName == null) {
                    preparedStatement = this.conn.prepareStatement("select resource_id, constraint_name, constr_type, instr_set  from mdsys.rdfvpd_policy_compl_constr$ pcc,  table(cast(:1 as sys.odcivarchar2list)) pl where policy_rid = :2   and pcc.resource_id = pl.column_value ");
                    preparedStatement.setArray(1, (Array)this.makeSQLArray(arrayList, "SYS.ODCIVARCHAR2LIST"));
                    preparedStatement.setString(2, this.policyRid);
                } else {
                    preparedStatement = this.conn.prepareStatement("select resource_id, constraint_name, constr_type, instr_set  from mdsys.rdfvpd_policy_compl_constr$ pcc,  table(cast(:1 as sys.odcivarchar2list)) pl where policy_rid = :2   and pcc.resource_id = pl.column_value and (constr_group is null  or nvl(sys_context(:3,constr_group)," + this.defEnb + ") = 1)");
                    preparedStatement.setArray(1, (Array)this.makeSQLArray(arrayList, "SYS.ODCIVARCHAR2LIST"));
                    preparedStatement.setString(2, this.policyRid);
                    preparedStatement.setString(3, this.contextName);
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    object = new sparqlVPDConstraint(resultSet.getString(1), resultSet.getString(3), resultSet.getString(2), resultSet.getArray(4));
                    this.applyVPDConstraint((sparqlVPDConstraint)object);
                }
                resultSet.close();
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new RDFException("error collecting metadata: " + sQLException.getMessage());
        }
        this.validateForVPD();
    }

    private void collect(SimpleNode simpleNode, int n, int n2) {
        int n3 = n;
        if (simpleNode.id == 48) {
            this.groupGraphNodes.add(simpleNode);
            n3 = this.groupGraphNodes.size() - 1;
        }
        if (simpleNode.id == 47) {
            int n4;
            sparqlIdent[] sparqlIdentArray = new sparqlIdent[3];
            assert (simpleNode.jjtGetNumChildren() >= 3) : new RDFRuntimeException("RDFVPD: Violated minimum atoms in a triple");
            for (n4 = 0; n4 < 3; ++n4) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(n4);
                String string = null;
                int n5 = n4 == 0 ? 16 : (n4 == 1 ? 32 : 64);
                sparqlIdentArray[n4] = null;
                if (aSTTripleAtom.type == 0) {
                    ++n5;
                    string = aSTTripleAtom.name;
                } else if (aSTTripleAtom.type == 1) {
                    n5 += 2;
                    string = this.uriSet.get(aSTTripleAtom.name);
                    if (string == null) {
                        sparqlIdentArray[1] = null;
                        break;
                    }
                } else if (aSTTripleAtom.type == 7) {
                    n5 += 8;
                    string = aSTTripleAtom.name;
                } else {
                    n5 += 4;
                    string = this.litSet.get(aSTTripleAtom);
                }
                if (!this.qryIdents.containsKey(string)) {
                    sparqlIdentArray[n4] = new sparqlIdent(string, n5);
                    this.qryIdents.put(string, sparqlIdentArray[n4]);
                    continue;
                }
                sparqlIdentArray[n4] = this.qryIdents.get(string);
                sparqlIdentArray[n4].setFlag(n5);
            }
            if (sparqlIdentArray[1] != null) {
                sparqlPredicate sparqlPredicate2 = this.qryPreds.get(sparqlIdentArray[1].getIdentifier());
                if (sparqlPredicate2 == null) {
                    sparqlPredicate2 = new sparqlPredicate(sparqlIdentArray[1].getIdentifier());
                    sparqlPredicate2.addSubjectObjects(sparqlIdentArray[0], sparqlIdentArray[2], n3);
                    this.qryPreds.put(sparqlIdentArray[1].getIdentifier(), sparqlPredicate2);
                } else {
                    sparqlPredicate2.addSubjectObjects(sparqlIdentArray[0], sparqlIdentArray[2], n3);
                }
            }
            for (n4 = 3; n4 < simpleNode.jjtGetNumChildren(); ++n4) {
                this.collect((SimpleNode)simpleNode.jjtGetChild(n4), n3, n2 + 1);
            }
        } else {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                this.collect((SimpleNode)simpleNode.jjtGetChild(i), n3, n2 + 1);
            }
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<rdfquery> \n");
        stringBuffer.append("  <predicates> \n");
        for (String string : this.qryPreds.keySet()) {
            object = this.qryPreds.get(string);
            if (this.qryIdents.get(string).hasFlags(2)) {
                stringBuffer.append("    <predicate type=\"URI\" ident=\"" + string + "\"> \n");
                if (((sparqlPredicate)object).getDomainType() != null) {
                    stringBuffer.append("      <domain class=\"" + ((sparqlPredicate)object).getDomainType() + "\"/> \n");
                }
                if (((sparqlPredicate)object).getRangeType() != null) {
                    stringBuffer.append("      <range class=\"" + ((sparqlPredicate)object).getRangeType() + "\"/> \n");
                }
                stringBuffer.append("      <identifiers> \n");
                ((sparqlPredicate)object).append2StringBuffer(stringBuffer, "        ");
                stringBuffer.append("      </identifiers> \n");
                stringBuffer.append("    </predicate> \n");
                continue;
            }
            stringBuffer.append("    <predicate type=\"VAR\" ident=\"" + string + "\"> \n");
            stringBuffer.append("      <identifiers>\n");
            ((sparqlPredicate)object).append2StringBuffer(stringBuffer, "        ");
            stringBuffer.append("      </identifiers>\n");
            stringBuffer.append("    </predicate>\n");
        }
        stringBuffer.append("  </predicates>\n");
        stringBuffer.append("  <identifiers>\n");
        for (String string : this.qryIdents.keySet()) {
            object = this.qryIdents.get(string);
            ((sparqlIdent)object).append2StringBuffer(stringBuffer, "    ");
        }
        stringBuffer.append("  </identifiers>\n");
        stringBuffer.append("<rdfquery/>");
        return stringBuffer.toString();
    }

    public static String toString(SimpleNode simpleNode, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (simpleNode.id) {
            case 0: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTINPUT\">\n");
                break;
            }
            case 2: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTCURLYBRACEQUERY\">\n");
                break;
            }
            case 1: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTVOID\">\n");
                break;
            }
            case 48: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTGROUPGRAPHPATTERN\">\n");
                break;
            }
            case 47: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTTRIPLESBLOCK\">\n");
                break;
            }
            case 49: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTGRAPHPATTERNNOTTRIPLES\">\n");
                break;
            }
            case 50: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTOPTIONALGRAPHPATTERN\">\n");
                break;
            }
            case 4: {
                stringBuffer.append(string + "<SimpleNode type=\"JJTTRIPLEPATTERN\">\n");
                break;
            }
            case 73: {
                String string2 = ((ASTTripleAtom)simpleNode).type == 0 ? "VAR" : (((ASTTripleAtom)simpleNode).type == 1 ? "URI" : "LIT/FNC");
                stringBuffer.append(string + "<SimpleNode type=\"JJTTRIPLEATOM\" name=\"" + ((ASTTripleAtom)simpleNode).name + "\" kind=\"" + string2 + "\"/>\n");
            }
        }
        if (simpleNode.id != 73) {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                stringBuffer.append(sparqlSemAnalyzer.toString((SimpleNode)simpleNode.jjtGetChild(i), string + "   "));
            }
            stringBuffer.append(string + "</SimpleNode>\n");
        }
        return stringBuffer.toString();
    }

    public static void processVPDConstraint(Set set, ASTInput aSTInput, ASTInput aSTInput2, URIset uRIset, LiteralSet literalSet, ArrayList<String> arrayList) throws RDFException {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n2 = 0;
        Object[] objectArray = set.toArray();
        SimpleNode simpleNode = aSTInput;
        if (simpleNode.id != 0 || simpleNode.jjtGetNumChildren() != 1) {
            throw new RDFException("unsupported VPD match pattern - I");
        }
        simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode.id != 2 || simpleNode.jjtGetNumChildren() != 1) {
            throw new RDFException("unsupported VPD match pattern - C");
        }
        simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode.id != 48 || simpleNode.jjtGetNumChildren() != 1) {
            throw new RDFException("unsupported VPD match pattern - G");
        }
        simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode.id != 47 || simpleNode.jjtGetNumChildren() != 3) {
            throw new RDFException("unsupported VPD match pattern - T");
        }
        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(0);
        ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)simpleNode.jjtGetChild(1);
        ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)simpleNode.jjtGetChild(2);
        if (aSTTripleAtom.type != 0) {
            throw new RDFException("missing variable in the subject postion of match pattern");
        }
        hashtable.put(aSTTripleAtom.name, ":1");
        if (aSTTripleAtom2.type != 1) {
            throw new RDFException("invalid use of variable in the match pattern's predicate position");
        }
        if (aSTTripleAtom3.type == 1) {
            if (!aSTTripleAtom2.name.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                throw new RDFException("invalid predicate type in the match pattern");
            }
            n2 = 1;
            arrayList.add("C");
            arrayList.add(uRIset.get(aSTTripleAtom3.name));
        } else if (aSTTripleAtom3.type == 0) {
            n2 = 2;
            hashtable.put(aSTTripleAtom3.name, ":2");
            arrayList.add("P");
            arrayList.add(uRIset.get(aSTTripleAtom2.name));
        } else {
            throw new RDFException("invalid object in match pattern - O");
        }
        arrayList.add("" + objectArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            hashtable.put((String)objectArray[n], ":" + (n + 3));
        }
        simpleNode = aSTInput2;
        if (simpleNode.id != 0 || simpleNode.jjtGetNumChildren() != 1) {
            throw new RDFException("unsupported VPD apply pattern - I");
        }
        simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode.id != 2 || simpleNode.jjtGetNumChildren() != 1) {
            throw new RDFException("unsupported VPD apply pattern - C");
        }
        simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode.id != 48 || simpleNode.jjtGetNumChildren() != 1) {
            throw new RDFException("unsupported VPD apply pattern - G");
        }
        simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        if (simpleNode.id != 47) {
            throw new RDFException("unsupported VPD apply pattern - T");
        }
        while (simpleNode != null && simpleNode.id == 47) {
            n = 1;
            int n3 = arrayList.size();
            assert (simpleNode.jjtGetNumChildren() >= 3) : new RDFRuntimeException("apply pattern violated minimum atoms in a triple");
            arrayList.add("" + n);
            for (int i = 0; i < 3; ++i) {
                ASTTripleAtom aSTTripleAtom4 = (ASTTripleAtom)simpleNode.jjtGetChild(i);
                if (aSTTripleAtom4.type == 0) {
                    n += i == 0 ? 256 : (i == 1 ? 64 : 16);
                    arrayList.add((String)hashtable.get(aSTTripleAtom4.name));
                    continue;
                }
                if (aSTTripleAtom4.type == 7) {
                    n += i == 0 ? 512 : (i == 1 ? 128 : 32);
                    arrayList.add(aSTTripleAtom4.name);
                    continue;
                }
                if (aSTTripleAtom4.type == 1) {
                    arrayList.add(uRIset.get(aSTTripleAtom4.name));
                    continue;
                }
                arrayList.add(literalSet.get(aSTTripleAtom4));
            }
            arrayList.set(n3, "" + n);
            n3 = simpleNode.jjtGetNumChildren();
            if (n3 > 4) {
                throw new RDFException("unsupported VPD apply pattern - NBGP");
            }
            if (n3 == 4) {
                simpleNode = (SimpleNode)simpleNode.jjtGetChild(3);
                continue;
            }
            simpleNode = null;
        }
        if (simpleNode != null) {
            throw new RDFException("unsupported VPD apply pattern - TPB" + simpleNode.id);
        }
    }

    public static String unparseSparql(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = simpleNode;
        StringBuffer stringBuffer = new StringBuffer(" { ");
        assert (simpleNode2.id == 0 && simpleNode2.jjtGetNumChildren() == 1);
        simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
        assert (simpleNode2.id == 2 && simpleNode2.jjtGetNumChildren() == 1);
        simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
        assert (simpleNode2.id == 48 && simpleNode2.jjtGetNumChildren() == 1);
        simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(0);
        assert (simpleNode2.id == 47 && simpleNode2.jjtGetNumChildren() >= 3);
        while (simpleNode2 != null && simpleNode2.id == 47) {
            for (int i = 0; i < 3; ++i) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode2.jjtGetChild(i);
                switch (aSTTripleAtom.type) {
                    case 0: {
                        stringBuffer.append("?" + aSTTripleAtom.name);
                        break;
                    }
                    case 1: {
                        stringBuffer.append("<" + aSTTripleAtom.name + ">");
                        break;
                    }
                    case 2: {
                        stringBuffer.append(aSTTripleAtom.name);
                        break;
                    }
                    case 3: {
                        stringBuffer.append("\"" + aSTTripleAtom.name + "\"");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("\"" + aSTTripleAtom.name + "\"@" + aSTTripleAtom.litLang);
                        break;
                    }
                    case 5: 
                    case 6: {
                        stringBuffer.append("\"" + aSTTripleAtom.name + "\"^^<" + aSTTripleAtom.litType + ">");
                    }
                }
                stringBuffer.append(" ");
            }
            assert (simpleNode2.jjtGetNumChildren() <= 4);
            if (simpleNode2.jjtGetNumChildren() == 4) {
                simpleNode2 = (SimpleNode)simpleNode2.jjtGetChild(3);
                stringBuffer.append(" . ");
                continue;
            }
            simpleNode2 = null;
        }
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }
}

