/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.spatial.rdf.server.RDFRuntimeException;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.sparqlVPDConstraint;

class sparqlIdent {
    static int glbVarIdx = 1;
    String ident;
    ArrayList<ArrayList<String>> identClss;
    ArrayList<Hashtable<String, sparqlVPDConstraint>> constrApplied;
    int identFlags;
    static final int IDENT_TYPE_VAR = 1;
    static final int IDENT_TYPE_URI = 2;
    static final int IDENT_TYPE_LIT = 4;
    static final int IDENT_TYPE_FNC = 8;
    static final int IDENT_IN_SUB_POS = 16;
    static final int IDENT_IN_PRED_POS = 32;
    static final int IDENT_IN_OBJ_POS = 64;

    sparqlIdent(String string, int n) {
        this.ident = string;
        this.identFlags = n;
        this.identClss = new ArrayList();
        this.constrApplied = new ArrayList();
    }

    String getIdentifier() {
        return this.ident;
    }

    void setClass(int n, String string) {
        ArrayList<String> arrayList = null;
        if (this.identClss.size() > n) {
            arrayList = this.identClss.get(n);
        } else {
            for (int i = n + 1 - this.identClss.size(); i > 0; --i) {
                this.identClss.add(null);
            }
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(string);
            this.identClss.set(n, arrayList);
        } else if (!arrayList.contains(string)) {
            arrayList.add(string);
        }
    }

    void setVPDConstraint(sparqlVPDConstraint sparqlVPDConstraint2) {
        if (sparqlVPDConstraint2.constraintType.equals("P") && this.hasFlags(32)) {
            return;
        }
        for (int i = 0; i < this.identClss.size(); ++i) {
            if (this.identClss.get(i) == null || !this.identClss.get(i).contains(sparqlVPDConstraint2.resourceId)) continue;
            Hashtable<String, sparqlVPDConstraint> hashtable = null;
            if (this.constrApplied.size() > i) {
                hashtable = this.constrApplied.get(i);
            } else {
                for (int j = i + 1 - this.constrApplied.size(); j > 0; --j) {
                    this.constrApplied.add(null);
                }
            }
            if (hashtable == null) {
                hashtable = new Hashtable();
                hashtable.put(sparqlVPDConstraint2.constraintName, sparqlVPDConstraint2);
                this.constrApplied.set(i, hashtable);
                continue;
            }
            if (hashtable.containsKey(sparqlVPDConstraint2.constraintName)) continue;
            hashtable.put(sparqlVPDConstraint2.constraintName, sparqlVPDConstraint2);
        }
    }

    private ASTTripleAtom getTripleAtom(int n, int n2, String string, Hashtable<String, String> hashtable) {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.flags = 1;
        if (n2 == 1 && (n & 0x100) > 0 || n2 == 2 && (n & 0x40) > 0 || n2 == 3 && (n & 0x10) > 0) {
            if (string.equals(":1")) {
                aSTTripleAtom.type = this.hasFlags(2) ? 1 : (this.hasFlags(4) ? 1 : (this.hasFlags(8) ? 7 : 0));
                aSTTripleAtom.name = this.ident;
            } else if (hashtable.containsKey(string)) {
                aSTTripleAtom.type = 0;
                aSTTripleAtom.name = hashtable.get(string);
                aSTTripleAtom.flags += 2;
            } else {
                aSTTripleAtom.type = 0;
                aSTTripleAtom.name = "RDF$VPDPSDO_" + glbVarIdx;
                ++glbVarIdx;
                hashtable.put(string, aSTTripleAtom.name);
                aSTTripleAtom.flags += 2;
            }
        } else if (n2 == 1 && (n & 0x200) > 0 || n2 == 2 && (n & 0x80) > 0 || n2 == 3 && (n & 0x20) > 0) {
            aSTTripleAtom.type = 7;
            aSTTripleAtom.name = string;
        } else {
            aSTTripleAtom.type = 1;
            aSTTripleAtom.name = string;
        }
        return aSTTripleAtom;
    }

    SimpleNode getConstraintNode(int n) {
        ASTTriplesBlock aSTTriplesBlock = null;
        ASTTriplesBlock aSTTriplesBlock2 = null;
        if (this.constrApplied.size() <= n) {
            return null;
        }
        Hashtable<String, sparqlVPDConstraint> hashtable = this.constrApplied.get(n);
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        block2: for (sparqlVPDConstraint sparqlVPDConstraint2 : hashtable.values()) {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            int n2 = 3;
            if (aSTTriplesBlock2 != null) {
                ASTTriplesBlock aSTTriplesBlock3 = aSTTriplesBlock2;
                aSTTriplesBlock2 = new ASTTriplesBlock(47);
                aSTTriplesBlock2.jjtSetParent(aSTTriplesBlock3);
                aSTTriplesBlock3.jjtAddChild(aSTTriplesBlock2, aSTTriplesBlock3.jjtGetNumChildren());
            } else {
                aSTTriplesBlock = aSTTriplesBlock2 = new ASTTriplesBlock(47);
            }
            while (n2 < sparqlVPDConstraint2.instrSet.length) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(sparqlVPDConstraint2.instrSet[n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RDFRuntimeException("Invalid instruction [" + n2 + "] [" + n3 + "]");
                }
                assert ((n3 & 1) > 0) : new RDFRuntimeException("Invalid instruction [" + n2 + "] [" + n3 + "]");
                ASTTripleAtom aSTTripleAtom = this.getTripleAtom(n3, 1, sparqlVPDConstraint2.instrSet[n2 + 1], hashtable2);
                aSTTripleAtom.jjtSetParent(aSTTriplesBlock2);
                aSTTriplesBlock2.jjtAddChild(aSTTripleAtom, 0);
                aSTTripleAtom = this.getTripleAtom(n3, 2, sparqlVPDConstraint2.instrSet[n2 + 2], hashtable2);
                aSTTripleAtom.jjtSetParent(aSTTriplesBlock2);
                aSTTriplesBlock2.jjtAddChild(aSTTripleAtom, 1);
                aSTTripleAtom = this.getTripleAtom(n3, 3, sparqlVPDConstraint2.instrSet[n2 + 3], hashtable2);
                aSTTripleAtom.jjtSetParent(aSTTriplesBlock2);
                aSTTriplesBlock2.jjtAddChild(aSTTripleAtom, 2);
                if ((n2 += 4) >= sparqlVPDConstraint2.instrSet.length) continue block2;
                ASTTriplesBlock aSTTriplesBlock4 = aSTTriplesBlock2;
                aSTTriplesBlock2 = new ASTTriplesBlock(47);
                aSTTriplesBlock2.jjtSetParent(aSTTriplesBlock4);
                aSTTriplesBlock4.jjtAddChild(aSTTriplesBlock2, 3);
            }
        }
        return aSTTriplesBlock;
    }

    boolean hasFlags(int n) {
        return (this.identFlags & n) == n;
    }

    void setFlag(int n) {
        this.identFlags |= n;
    }

    void clearFlag(int n) {
        this.identFlags &= ~n;
    }

    void append2StringBuffer(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + "<identifier val=\"" + this.ident + "\" type=\"" + (this.hasFlags(2) ? "URI" : "VAR") + "\"> \n");
        for (int i = 0; i < this.identClss.size(); ++i) {
            if (this.identClss.get(i) == null) continue;
            stringBuffer.append(string + "  <graphpattern index=\"" + i + "\"> \n");
            for (String string2 : this.identClss.get(i)) {
                stringBuffer.append(string + "    <class refid=\"" + string2 + "\"/> \n");
            }
            stringBuffer.append(string + "  </graphpattern> \n");
        }
        stringBuffer.append(string + "</identifier> \n");
    }
}

