/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectExpression;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class SparqlSelectDescriptor {
    public static final int NONE = 0;
    public static final int DISTINCT = 1;
    public static final int REDUCED = 2;
    private boolean selectSpecified = false;
    private List<String> selectList = new ArrayList<String>();
    private int selectModifier = 0;
    private boolean selectAll = false;
    private boolean hasExpression = false;
    private boolean isTopSelect = false;
    private boolean hasAggregate = false;
    private boolean fromConstruct = false;
    private boolean describeAll;
    private List<SelectExpression> projections = new ArrayList<SelectExpression>();
    private Map<String, String> varComments = new HashMap<String, String>();

    protected Object clone() throws CloneNotSupportedException {
        SparqlSelectDescriptor sparqlSelectDescriptor = new SparqlSelectDescriptor();
        for (String object : this.selectList) {
            sparqlSelectDescriptor.addVar(object);
        }
        for (SelectExpression selectExpression : this.projections) {
            sparqlSelectDescriptor.addSelection(selectExpression.getVar(), selectExpression.getExprTree(), selectExpression.getComment());
        }
        if (this.containsExpression()) {
            sparqlSelectDescriptor.setHasExpression();
        }
        sparqlSelectDescriptor.setSelectModifier(this.selectModifier);
        sparqlSelectDescriptor.setSelectAll(this.selectAll);
        sparqlSelectDescriptor.setIsTopSelect(this.isTopSelect);
        sparqlSelectDescriptor.setFromConstruct(this.fromConstruct);
        sparqlSelectDescriptor.setDescribeAll(this.describeAll);
        for (String string : this.varComments.keySet()) {
            sparqlSelectDescriptor.addVarComment(string, this.varComments.get(string));
        }
        return sparqlSelectDescriptor;
    }

    public void populateSelDesc(Node node, boolean bl) {
        SimpleNode simpleNode = (SimpleNode)node;
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            if (simpleNode2.id != 8) continue;
            this.processSelections((ASTSelectClause)simpleNode2, bl);
            break;
        }
    }

    private void processSelections(ASTSelectClause aSTSelectClause, boolean bl) {
        if (aSTSelectClause.jjtGetNumChildren() > 0) {
            for (int i = 0; i < aSTSelectClause.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTSelectClause.jjtGetChild(i);
                if (simpleNode.id == 73) {
                    this.addSelection((ASTTripleAtom)simpleNode, null);
                    continue;
                }
                if (simpleNode.id != 9) continue;
                Node node = null;
                if (!bl) {
                    node = simpleNode.jjtGetChild(0);
                }
                this.addSelection((ASTTripleAtom)simpleNode.jjtGetChild(1), node, ((ASTSelectExpression)simpleNode).getComment());
            }
        } else {
            for (String string : this.selectList) {
                ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
                aSTTripleAtom.type = 0;
                aSTTripleAtom.name = string;
                this.addSelection(aSTTripleAtom, null);
            }
        }
    }

    public void addSelection(ASTTripleAtom aSTTripleAtom, Node node) {
        this.addSelection(aSTTripleAtom, node, null);
    }

    public void addSelection(ASTTripleAtom aSTTripleAtom, Node node, String string) {
        SelectExpression selectExpression = new SelectExpression();
        selectExpression.setVar(aSTTripleAtom);
        if (node != null) {
            selectExpression.setExprTree(node);
            if (!this.hasAggregate && selectExpression.containsAggregate()) {
                this.hasAggregate = true;
            }
        }
        selectExpression.setComment(string);
        this.projections.add(selectExpression);
        this.addVar(aSTTripleAtom.name);
    }

    public void addVar(String string) {
        if (!this.selectList.contains(string)) {
            this.selectList.add(string);
        }
        this.selectSpecified = true;
    }

    public void addVarComment(String string, String string2) {
        if (!this.varComments.containsKey(string)) {
            this.varComments.put(string, string2);
        }
    }

    public boolean containsVar(String string) {
        return this.selectList.contains(string);
    }

    public void addVarCollection(Collection<String> collection) {
        this.selectList.addAll(collection);
        this.selectSpecified = true;
    }

    public String[] returnPGSignature() {
        String[] stringArray = new String[this.selectList.size() * 2 + 2];
        int n = 0;
        for (String string : this.selectList) {
            stringArray[n] = "VC";
            stringArray[++n] = string + "";
            ++n;
        }
        stringArray[n] = "NU";
        stringArray[++n] = "PG$ROWNUM";
        return stringArray;
    }

    public String[] returnSignature(boolean bl) {
        if (this.isFromConstruct()) {
            return this.returnConstructSignature();
        }
        String[] stringArray = new String[this.selectList.size() * 2 * 2 + 2];
        int n = 0;
        String string = "CL";
        if (bl) {
            string = "VC";
        }
        for (String string2 : this.selectList) {
            stringArray[n] = "NU";
            stringArray[++n] = string2 + "$RDFVID";
            stringArray[++n] = string;
            stringArray[++n] = string2 + "$RDFTERM";
            ++n;
        }
        stringArray[n] = "NU";
        stringArray[++n] = "SEM$ROWNUM";
        return stringArray;
    }

    public String[] returnVDollarSignature(boolean bl, boolean bl2) {
        if (this.isFromConstruct()) {
            return this.returnConstructSignature();
        }
        int n = 8;
        if (bl) {
            n = 9;
        }
        String[] stringArray = new String[this.selectList.size() * 2 * n + 2];
        int n2 = 0;
        String string = "CL";
        if (bl2) {
            string = "VC";
        }
        for (String string2 : this.selectList) {
            stringArray[n2++] = "VC";
            stringArray[n2++] = string2;
            stringArray[n2++] = "NU";
            stringArray[n2++] = string2 + "$RDFVID";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string2 + "$_PREFIX";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string2 + "$_SUFFIX";
            stringArray[n2++] = "VC3";
            stringArray[n2++] = string2 + "$RDFVTYP";
            stringArray[n2++] = "CL";
            stringArray[n2++] = string2 + "$RDFCLOB";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string2 + "$RDFLTYP";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string2 + "$RDFLANG";
            if (!bl) continue;
            stringArray[n2++] = string;
            stringArray[n2++] = string2 + "$RDFTERM";
        }
        stringArray[n2++] = "NU";
        stringArray[n2++] = "SEM$ROWNUM";
        return stringArray;
    }

    public String[] returnConstructSignature() {
        int n = 10;
        String[] stringArray = new String[this.selectList.size() * 2 * n + 2];
        int n2 = 0;
        for (String string : this.selectList) {
            stringArray[n2++] = "VC";
            stringArray[n2++] = string;
            stringArray[n2++] = "NU";
            stringArray[n2++] = string + "$RDFVID";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string + "$_PREFIX";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string + "$_SUFFIX";
            stringArray[n2++] = "VC3";
            stringArray[n2++] = string + "$RDFVTYP";
            stringArray[n2++] = "CL";
            stringArray[n2++] = string + "$RDFCLOB";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string + "$RDFLTYP";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string + "$RDFLANG";
            stringArray[n2++] = "VC";
            stringArray[n2++] = string + "$RDFTERM";
            stringArray[n2++] = "CL";
            stringArray[n2++] = string + "$RDFCLBT";
        }
        stringArray[n2++] = "NU";
        stringArray[n2++] = "SEM$ROWNUM";
        return stringArray;
    }

    public void validateFilters() throws RDFException {
        try {
            for (SelectExpression selectExpression : this.projections) {
                selectExpression.validateFilter();
            }
        }
        catch (TypeException typeException) {
            throw new RDFException(typeException.getMessage());
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
    }

    public void prepareExpressions() throws RDFException {
        for (SelectExpression selectExpression : this.projections) {
            selectExpression.prepareExpression();
        }
    }

    public void processUnDefVars(Set<String> set) throws RDFException {
        for (SelectExpression selectExpression : this.projections) {
            selectExpression.processUnDefVars(set);
        }
    }

    public void setIsTopSelect(boolean bl) {
        this.isTopSelect = bl;
    }

    public boolean getIsTopSelect() {
        return this.isTopSelect;
    }

    public List<String> getSelectList() {
        return this.selectList;
    }

    public Map<String, String> getVarComments() {
        return this.varComments;
    }

    public boolean isSelectSpecified() {
        return this.selectSpecified;
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean bl) {
        this.selectAll = bl;
        this.selectSpecified = true;
    }

    public boolean selectAllVars() {
        return this.selectAll;
    }

    public void setSelectModifier(int n) {
        this.selectModifier = n;
        this.selectSpecified = true;
    }

    public int getSelectModifier() {
        return this.selectModifier;
    }

    public List<SelectExpression> getSelectExpressions() {
        return this.projections;
    }

    public void setHasExpression() {
        this.hasExpression = true;
    }

    public boolean containsExpression() {
        return this.hasExpression;
    }

    public boolean containsAggregate() {
        return this.hasAggregate;
    }

    public void setHasAggregate(boolean bl) {
        this.hasAggregate = bl;
    }

    public Set<String> getJoinVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SelectExpression selectExpression : this.projections) {
            hashSet.addAll(selectExpression.getJoinVars());
        }
        return hashSet;
    }

    public void setLexVars(Set<String> set) {
        for (SelectExpression selectExpression : this.projections) {
            selectExpression.setLexVars(set);
        }
    }

    public void initExpressions(SQLGenContext sQLGenContext) {
        for (SelectExpression selectExpression : this.projections) {
            selectExpression.initExpression(sQLGenContext);
        }
    }

    public void setFromConstruct(boolean bl) {
        this.fromConstruct = bl;
    }

    public boolean isFromConstruct() {
        return this.fromConstruct;
    }

    public void setDescribeAll(boolean bl) {
        this.describeAll = bl;
    }

    public boolean isDescribeAll() {
        return this.describeAll;
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "======== SELECT LIST =========\n";
        string2 = string2 + string + "isTopSelect [" + this.isTopSelect + "]\n";
        string2 = string2 + string + "selectModifier [" + this.selectModifier + "]\n";
        string2 = string2 + string + "selectAll [" + this.selectAll + "]\n";
        string2 = string2 + string + "SELECT Vars [";
        for (String object : this.selectList) {
            string2 = string2 + " " + object;
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Has SELECT Expression [" + this.containsExpression() + "]\n";
        string2 = string2 + string + "SELECT Expressions [\n";
        for (SelectExpression selectExpression : this.projections) {
            string2 = string2 + " " + selectExpression.toString(string);
        }
        string2 = string2 + string + "]\n";
        string2 = string2 + string + "===============================\n";
        return string2;
    }

    public String printSPARQLText() throws ParseException {
        StringBuffer stringBuffer;
        block10: {
            block9: {
                stringBuffer = new StringBuffer();
                if (!this.fromConstruct) break block9;
                if (!this.isTopSelect) break block10;
                stringBuffer.append("CONSTRUCT ");
                break block10;
            }
            stringBuffer.append("SELECT ");
            if (this.selectModifier == 1) {
                stringBuffer.append("DISTINCT ");
            } else if (this.selectModifier == 2) {
                stringBuffer.append("REDUCED ");
            }
            if (this.selectAll) {
                stringBuffer.append("* ");
            } else if (this.hasExpression) {
                for (SelectExpression selectExpression : this.projections) {
                    stringBuffer.append(selectExpression.printSPARQLText());
                }
            } else {
                for (String string : this.selectList) {
                    stringBuffer.append("?");
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
        }
        return stringBuffer.toString();
    }
}

