/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedURI {
    public String scheme;
    public String user;
    public String host;
    public String port;
    public String path;
    public String query;
    public String segment;
    static final Pattern patt = Pattern.compile("(([^:/?#]*):)?(//((([^/?#@]*)@)?(\\[[^/?#]*\\]|([^/?#:]*))?(:([^/?#]*))?))?([^#?]*)?(\\?([^#]*))?(#(.*))?", 32);
    private Matcher match;
    static final int SCHEME = 2;
    static final int USER = 6;
    static final int HOST = 7;
    static final int PORT = 10;
    static final int PATH = 11;
    static final int QUERY = 13;
    static final int SEGMENT = 15;
    static final int AUTHORITY = 4;
    static final int[] URIElements = new int[]{2, 6, 7, 10, 11, 13, 15};

    ParsedURI(String string) {
        this.setURI(string);
    }

    ParsedURI() {
    }

    public void setURI(String string) {
        this.scheme = "";
        this.user = "";
        this.host = "";
        this.port = "";
        this.path = "";
        this.query = "";
        this.segment = "";
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        this.match = patt.matcher(string2);
        if (!this.match.matches()) {
            throw new RuntimeException("Not maches for " + string2 + "!!!");
        }
        for (int i = 0; i < URIElements.length; ++i) {
            this.setSection(URIElements[i]);
        }
    }

    public boolean isDefined(int n) {
        return this.match.start(n) != -1;
    }

    void setSection(int n) {
        if (this.match.start(n) != -1) {
            String string = this.match.group(n);
            switch (n) {
                case 2: {
                    this.scheme = string;
                    break;
                }
                case 6: {
                    this.user = string;
                    break;
                }
                case 7: {
                    this.host = string;
                    break;
                }
                case 10: {
                    this.port = string;
                    break;
                }
                case 11: {
                    this.path = string;
                    break;
                }
                case 13: {
                    this.query = string;
                    break;
                }
                case 15: {
                    this.segment = string;
                }
            }
        }
    }

    public String getFormedURI() {
        String string = "";
        if (this.scheme != "") {
            string = string + this.scheme + ":";
        }
        if (this.host != "") {
            string = string + "//" + this.user + this.host + this.port;
        }
        string = string + this.path;
        if (this.query != "") {
            string = string + "?" + this.query;
        }
        if (this.segment != "") {
            string = string + "#" + this.segment;
        }
        return string;
    }
}

