/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.sparql;

import java.util.List;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;

public class ASTServiceGraphPattern
extends SimpleNode {
    private boolean silent = false;
    private String comment = "";

    public ASTServiceGraphPattern(int n) {
        super(n);
    }

    public ASTServiceGraphPattern(sparqlParse sparqlParse2, int n) {
        super(sparqlParse2, n);
    }

    @Override
    public Node cloneNode() {
        ASTServiceGraphPattern aSTServiceGraphPattern = new ASTServiceGraphPattern(this.parser, this.id);
        aSTServiceGraphPattern.children = null;
        aSTServiceGraphPattern.parent = null;
        aSTServiceGraphPattern.silent = this.silent;
        aSTServiceGraphPattern.comment = this.comment;
        return aSTServiceGraphPattern;
    }

    @Override
    public String printSPARQLText() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer("SERVICE ");
        if (this.silent) {
            stringBuffer.append("SILENT ");
        }
        stringBuffer.append(super.printSPARQLText());
        return stringBuffer.toString();
    }

    public String getEndpoint() throws ParseException {
        String string = "";
        if (this.children != null && this.children[0] != null) {
            string = ((ASTTripleAtom)this.children[0]).name;
            if (((ASTTripleAtom)this.children[0]).type == 0) {
                throw new ParseException("Variable used as SERVICE endpoint");
            }
        }
        return string;
    }

    public String getGraphPattern() throws ParseException {
        String string = "";
        if (this.children != null && this.children[1] != null) {
            string = this.children[1].printSPARQLText();
        }
        return string;
    }

    public void validateGraphPattern() throws ParseException {
        if (this.children != null && this.children[1] != null) {
            List<SimpleNode> list = OptimizerUtils.collectNodesOfType(this.children[1], new int[]{73});
            for (SimpleNode simpleNode : list) {
                switch (((ASTTripleAtom)simpleNode).type) {
                    case 7: {
                        throw new ParseException("sys context functions not allowed inside SERVICE");
                    }
                    case 9: 
                    case 10: {
                        throw new ParseException("Bind variables not allowed inside SERVICE");
                    }
                }
            }
        }
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public boolean getSilent() {
        return this.silent;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }
}

