/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;

public class UnionSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    private SortedSet<String> sortedVars;

    public UnionSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2) {
        super(n, sQLGenContext, n2);
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        if (this.myDefBoundVars == null) {
            this.myDefBoundVars = new HashSet();
            this.myDefBoundVars.addAll(this.getCumulativeVars());
            for (int i = 0; i < this.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
                this.myDefBoundVars = QueryUtils.getCommonVars(this.myDefBoundVars, sPARQLTreeNode.getDefiniteBoundVars());
            }
            this.myDefBoundVars = Collections.unmodifiableSet(this.myDefBoundVars);
        }
        return this.myDefBoundVars;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        if (this.myDefBoundAndPushedVars == null) {
            this.myDefBoundAndPushedVars = new HashSet();
            this.myDefBoundAndPushedVars.addAll(this.getCumulativeAndPushedVars());
            for (int i = 0; i < this.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
                this.myDefBoundAndPushedVars = QueryUtils.getCommonVars(this.myDefBoundAndPushedVars, sPARQLTreeNode.getDefiniteBoundAndPushedVars());
            }
            this.myDefBoundAndPushedVars = Collections.unmodifiableSet(this.myDefBoundAndPushedVars);
        }
        return this.myDefBoundAndPushedVars;
    }

    @Override
    public Set<String> getVcVars() {
        if (this.myVcVars == null) {
            if ((this.ctx.contextFlags & 8) > 0) {
                this.myVcVars = this.getCumulativeVars();
            } else {
                this.myVcVars = new HashSet();
                boolean bl = false;
                for (int i = 0; i < this.getNumChildren(); ++i) {
                    SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
                    if (sPARQLTreeNode.getType() != 0) continue;
                    if (!bl) {
                        this.myVcVars.addAll(sPARQLTreeNode.getVcVars());
                        bl = true;
                        continue;
                    }
                    this.myVcVars = QueryUtils.getCommonVars(this.myVcVars, sPARQLTreeNode.getVcVars());
                }
            }
            this.myVcVars = Collections.unmodifiableSet(this.myVcVars);
        }
        return this.myVcVars;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsEmptyBGP() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pushJoinVarsForHint() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getBGPAndPushedVars());
        hashSet.addAll(this.myBGP.getJoinVarsForHint());
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            sPARQLTreeNode.addJoinVarsForHint(hashSet);
            sPARQLTreeNode.pushJoinVarsForHint();
        }
    }

    @Override
    public void setProjections() throws RDFException {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getProjectVars());
        int n2 = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        Set<String> set = null;
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            set = QueryUtils.getCommonVars(hashSet, sPARQLTreeNode.getCumulativeVars());
            sPARQLTreeNode.addProjectVars(set);
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setProjections();
        }
    }

    @Override
    public int setGlobalSelectivity(int n) {
        int n2 = n;
        int n3 = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        for (int i = 0; i < n3; ++i) {
            sPARQLTreeNode = this.getChild(i);
            int n4 = sPARQLTreeNode.setGlobalSelectivity(n);
            if (n4 != 0) continue;
            n2 = 0;
        }
        this.nodeSelectivity = n2;
        return n2;
    }

    @Override
    public String toSQL() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        this.sortedVars = new TreeSet<String>();
        this.sortedVars.addAll(this.getCumulativeAndPushedVars());
        String string = "";
        String string2 = "";
        String string3 = "";
        SPARQLTreeNode sPARQLTreeNode = null;
        int n = this.getNumChildren();
        if (n > 0) {
            sPARQLTreeNode = this.getChild(0);
            try {
                string2 = this.buildSelectForUnion(sPARQLTreeNode.getCumulativeAndPushedVars());
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            string3 = string = "(" + string2 + "\nFROM (" + sPARQLTreeNode.toSQL() + ") " + "R" + ")";
        }
        for (int i = 1; i < n; ++i) {
            sPARQLTreeNode = this.getChild(i);
            try {
                string2 = this.buildSelectForUnion(sPARQLTreeNode.getCumulativeAndPushedVars());
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            string3 = string = string3 + "\nUNION ALL\n(" + string2 + "\nFROM (" + sPARQLTreeNode.toSQL() + ") " + "R" + ")";
        }
        if (string.equals("")) {
            string = "SELECT 1 FROM DUAL";
        }
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            string4 = this.buildSelectForUnion(this.getCumulativeAndPushedVars());
        }
        catch (SQLException sQLException) {
            throw new RDFException(sQLException.getMessage(), sQLException);
        }
        string5 = "FROM (" + string + ") " + "R";
        string6 = "WHERE (1=1)";
        stringBuffer.append(string4);
        stringBuffer.append("\n");
        stringBuffer.append(string5);
        stringBuffer.append("\n");
        stringBuffer.append(string6);
        return stringBuffer.toString();
    }

    private String buildSelectForUnion(Set<String> set) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "";
        Set<String> set2 = this.getAllLexVars();
        Set<String> set3 = this.getProjectVars();
        Set<String> set4 = Collections.emptySet();
        for (String string2 : this.sortedVars) {
            if (set.contains(string2)) {
                string = this.buildSelectForVar("R", string2, set3, set2, set4);
                QueryUtils.appendToList(stringBuffer, string, ",\n", "");
                continue;
            }
            string = this.buildNullSelectForVar("R", string2, set3, set2);
            QueryUtils.appendToList(stringBuffer, string, ",\n", "");
        }
        if ((this.ctx.contextFlags & 1) > 0 || (this.ctx.contextFlags & 2) > 0) {
            QueryUtils.appendToList(stringBuffer, " R.T0_CTXT2 as T0_CTXT2 ", ",\n ", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("1\n");
        }
        return "SELECT " + stringBuffer.toString();
    }

    private String buildNullSelectForVar(String string, String string2, Set<String> set, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        if (set.contains(string2)) {
            n = 8;
            if (set2.contains(string2)) {
                n = 9;
            }
        } else {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            QueryUtils.appendToList(stringBuffer, "NULL AS " + string2 + this.varProjColumns[i], ", ", "");
        }
        return stringBuffer.toString();
    }
}

