/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.spatial.rdf.server.BindRewriteOptimizer;
import oracle.spatial.rdf.server.BindingsRewriteOptimizer;
import oracle.spatial.rdf.server.ConstructExpandOptimizer;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.GGPReduceOptimizer;
import oracle.spatial.rdf.server.GenerateQuery;
import oracle.spatial.rdf.server.GroupByAliasRewriteOptimizer;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SPMComponents;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.TurtleExpandOptimizer;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.ValuesRewriteOptimizer;
import oracle.spatial.rdf.server.VariableSet;
import oracle.spatial.rdf.server.parser.sparql.ASTInput;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;
import oracle.spatial.rdf.server.sparqlSemAnalyzer;
import oracle.sql.CLOB;

public class TranslateEngine {
    sparqlParse parser = new sparqlParse((Reader)null);
    Connection conn;
    int flag;
    public static final String RDF_TERMS_ONLY = "RDFT_ONLY=T";
    public static final String PLUS_RDF_TERMS = "PLUS_RDFT=T";
    public static final String VC_TERMS_ONLY = "RDFT_ONLY=VC";
    public static final String PLUS_VC_TERMS = "PLUS_RDFT=VC";
    public static final String TOP_DOWN_TRANS = "TOP_DOWN_TRANS=T";
    public static final String PG_MATCH = "PG_MATCH=T";
    public static final String NO_SRID_MSG = "Unable to retrieve SRID value for semantic network";
    public static final String NO_DIM_MSG = "Unable to retrieve Dimension value for semantic network";
    public static final int FLAG_PROJECTALL = 1;
    public static final int FLAG_ENFORCEVPD = 2;
    public static final int FLAG_FROM_START = 4;
    public static final int FLAG_CTX_SPEC_SPARQL = 8;
    public static final int FLAG_CTX_PLUS_SPARQL = 16;
    public static final int FLAG_NG_ALL_UNNAMED = 32;
    public static final int FLAG_USE_ENT_UNNAMED = 64;
    public static final int FLAG_MATCH_UNNAMED = 128;
    public static final int FLAG_NONEMPTY_NAMED = 256;
    public static final int FLAG_STRICT_DEFAULT = 512;
    public static final int FLAG_CONS_STRICT = 1024;
    public static final int FLAG_CONS_UNIQUE = 2048;
    public static final int FLAG_CONS_NO_CONST_PROJ = 4096;
    public static final int FLAG_PROJ_CANON = 8192;
    public static final int FLAG_BAD_FILTER = 1;
    public static final int FLAG_LONG_QUERY = 2;
    public static final int FLAG_UNION_QUERY = 4;
    public static final int FLAG_ORDER_BY_QUERY = 8;
    public static final int FLAG_DISTICT_QUERY = 16;
    public static final int MAX_REWRITE_LENGTH = 64536;
    public static final int MAX_VC_LEN = 4000;
    public static final int CLOB_CHUNK_SIZE = 3500;
    public static final int DEFAULT_MIN_SVP_CLUSTER_SIZE = 1;
    public static final String MDSYS_RDFVTAB = "\"MDSYS\".RDF_VALUE$";
    public static String DEFAULT_Q_HINT = "NO_MERGE(R)";
    public static String NO_SWAP_HINT = "NO_SWAP_JOIN_INPUTS(R)";
    private String m_szOptions = " ";

    public String getOptions() {
        return this.m_szOptions;
    }

    public void setJenaOptions(HashMap hashMap, SQLGenContext sQLGenContext) throws RDFException {
        sQLGenContext.jenaHTHint = "";
        sQLGenContext.jenaFSHint = "";
        if (this.m_szOptions.contains("USE_JENA_HINTS=T")) {
            String string;
            sQLGenContext.jenaHTHint = " ALLOW_DUP=T ";
            String string2 = "http://oracle.com/semtech#";
            if (hashMap.containsKey("ORACLE_SEM_HT_NS") && (string = (String)hashMap.get("ORACLE_SEM_HT_NS")).startsWith(string2)) {
                string = string.substring(string2.length());
                sQLGenContext.jenaHTHint = "HINT0 = { " + string + " }";
            }
            if (hashMap.containsKey("ORACLE_SEM_FS_NS") && (string = (String)hashMap.get("ORACLE_SEM_FS_NS")).startsWith(string2)) {
                string = string.substring(string2.length()).toUpperCase();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("INF_ONLY", "INF_ONLY=T");
                hashMap2.put("STRICT_DEFAULT=T", "STRICT_DEFAULT=T");
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                hashMap3.put("ALLOW_DUP=F", "ALLOW_DUP=T");
                HashMap<String, String> hashMap4 = new HashMap<String, String>();
                hashMap4.put("DEGREE", "PARALLEL");
                hashMap4.put("DOP", "PARALLEL");
                hashMap4.put("ODS", "DYNAMIC_SAMPLING");
                HashMap<String, String> hashMap5 = new HashMap<String, String>();
                hashMap5.put("RESULT_CACHE", "RESULT_CACHE");
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3;
                    String string4 = stringArray[i];
                    if (hashMap2.containsKey(string4)) {
                        sQLGenContext.jenaHTHint = sQLGenContext.jenaHTHint + " " + (String)hashMap2.get(string4);
                        continue;
                    }
                    if (hashMap3.containsKey(string4)) {
                        sQLGenContext.jenaHTHint = sQLGenContext.jenaHTHint.replaceAll((String)hashMap3.get(string4), "");
                        continue;
                    }
                    if (hashMap5.containsKey(string4)) {
                        sQLGenContext.jenaFSHint = sQLGenContext.jenaFSHint + " " + (String)hashMap5.get(string4);
                        continue;
                    }
                    int n = string4.indexOf("=");
                    if (n <= 0 || !hashMap4.containsKey(string3 = string4.substring(0, n))) continue;
                    int n2 = Integer.parseInt(QueryUtils.extractPlainOption(string4, string3));
                    sQLGenContext.jenaFSHint = sQLGenContext.jenaFSHint + " " + (String)hashMap4.get(string3) + "(" + n2 + ")";
                }
            }
            sQLGenContext.queryOptions = sQLGenContext.queryOptions + sQLGenContext.jenaHTHint;
        }
    }

    public void setOptions(String string) {
        if (string == null) {
            this.m_szOptions = " ";
        } else {
            if (string.indexOf("ENF_VPD=T") > 0) {
                this.flag |= 2;
            }
            this.m_szOptions = string;
        }
    }

    public TranslateEngine(int n, Connection connection) {
        this.conn = connection;
        this.flag = n;
    }

    TranslateEngine(Connection connection) {
        this.conn = connection;
    }

    public String parseAndUnparse(String string, String string2, String string3) throws ParseException, RDFException, SQLException {
        HashMap hashMap = SPARQLEngine.setupNamespaceMap();
        String string4 = QueryUtils.getNetworkStorageForm(this.conn, QueryUtils.getPfxForRdfObjName(QueryUtils.getNetworkOwnerOrMdsys(string2), QueryUtils.getNetworkNameOrEmptyString(string3)));
        Node node = this.parser.parse(string, hashMap, this.getOptions() + (string4.equals("UNESC") ? " STORAGE_FORM=UNESC " : ""));
        GroupByAliasRewriteOptimizer groupByAliasRewriteOptimizer = new GroupByAliasRewriteOptimizer();
        BindRewriteOptimizer bindRewriteOptimizer = new BindRewriteOptimizer();
        TurtleExpandOptimizer turtleExpandOptimizer = new TurtleExpandOptimizer();
        ConstructExpandOptimizer constructExpandOptimizer = new ConstructExpandOptimizer();
        BindingsRewriteOptimizer bindingsRewriteOptimizer = new BindingsRewriteOptimizer();
        ValuesRewriteOptimizer valuesRewriteOptimizer = new ValuesRewriteOptimizer();
        GGPReduceOptimizer gGPReduceOptimizer = new GGPReduceOptimizer();
        ArrayList<SparqlQueryOptimizer> arrayList = new ArrayList<SparqlQueryOptimizer>();
        arrayList.add(groupByAliasRewriteOptimizer);
        arrayList.add(bindRewriteOptimizer);
        arrayList.add(turtleExpandOptimizer);
        arrayList.add(constructExpandOptimizer);
        arrayList.add(bindingsRewriteOptimizer);
        arrayList.add(valuesRewriteOptimizer);
        arrayList.add(gGPReduceOptimizer);
        try {
            for (SparqlQueryOptimizer sparqlQueryOptimizer : arrayList) {
                node = sparqlQueryOptimizer.optimizeQuery(node);
            }
        }
        catch (ParseException parseException) {
            throw new RDFException(parseException.getMessage());
        }
        return node.printSPARQLText();
    }

    public String[] getPatternVariables(String string, String string2) throws ParseException, SQLException, RDFException {
        return this.getPatternVariables(string, string2, true);
    }

    public String[] getPatternVariables(String string, String string2, boolean bl) throws ParseException, SQLException, RDFException {
        Node node;
        String[] stringArray = null;
        if (bl) {
            this.parser.reset();
            node = this.parser.parse(string, null, this.getOptions() + string2);
        }
        if (this.parser.hasTopLevelQueryNode()) {
            node = this.parser.getTopLevelQueryNode();
            String string3 = "";
            if (string2 != null) {
                string3 = string2.toUpperCase();
            }
            stringArray = string3.indexOf(PG_MATCH) >= 0 ? node.getselDesc().returnPGSignature() : (string3.indexOf(RDF_TERMS_ONLY) >= 0 ? node.getselDesc().returnSignature(false) : (string3.indexOf(PLUS_RDF_TERMS) >= 0 ? node.getselDesc().returnVDollarSignature(true, false) : (string3.indexOf(VC_TERMS_ONLY) >= 0 ? node.getselDesc().returnSignature(true) : (string3.indexOf(PLUS_VC_TERMS) >= 0 ? node.getselDesc().returnVDollarSignature(true, true) : node.getselDesc().returnVDollarSignature(false, false)))));
        } else {
            stringArray = this.parser.variables.returnSignature();
        }
        return stringArray;
    }

    public void getSources(String string, HashMap hashMap, Collection<String> collection, Collection<String> collection2) throws ParseException, SQLException, RDFException {
        this.getSources(string, hashMap, collection, collection2, "");
    }

    public void getSources(String string, HashMap hashMap, Collection<String> collection, Collection<String> collection2, String string2) throws ParseException, SQLException, RDFException {
        this.parser.reset();
        ASTInput aSTInput = this.parser.parse(string, hashMap, true, this.getOptions() + string2);
        if (this.parser.hasTopLevelQueryNode()) {
            ASTTopLevelQueryNode aSTTopLevelQueryNode = this.parser.getTopLevelQueryNode();
            collection.addAll(aSTTopLevelQueryNode.getsourceDesc().getDefaultGraphs());
            collection2.addAll(aSTTopLevelQueryNode.getsourceDesc().getNamedGraphs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getPlanCost(String string) throws SQLException, RDFException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long l = 0L;
        CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
        try {
            String string2 = "SELECT sem_apis.get_plan_cost( ? ) from dual";
            preparedStatement = this.conn.prepareStatement(string2);
            cLOB.setString(1L, string);
            preparedStatement.setClob(1, (Clob)cLOB);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                l = resultSet.getLong(1);
            }
        }
        catch (SQLException sQLException) {
            long l2 = Long.MAX_VALUE;
            return l2;
        }
        finally {
            if (cLOB != null) {
                cLOB.free();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return l;
    }

    public String translateQueryPattern(int[] nArray, String string, String[] stringArray, String string2, long l, String string3, long[] lArray, long[] lArray2, long[] lArray3, String[] stringArray2, HashMap hashMap, String string4, String[][] stringArray3, int[] nArray2, List<Integer> list, String[] stringArray4, int[] nArray3, int n, String string5, String string6) throws SQLException, ParseException, RDFException, TypeException, FilterException {
        return this.translateQueryPattern(nArray, string, stringArray, string2, l, string3, lArray, lArray2, lArray3, stringArray2, hashMap, string4, stringArray3, nArray2, list, stringArray4, nArray3, n, null, null, null, string5, string6);
    }

    public String translateQueryPattern(int[] nArray, String string, String[] stringArray, String string2, long l, String string3, long[] lArray, long[] lArray2, long[] lArray3, String[] stringArray2, HashMap hashMap, String string4, String[][] stringArray3, int[] nArray2, List<Integer> list, String[] stringArray4, int[] nArray3, int n, Map<String, String> map, String string5, String string6) throws SQLException, ParseException, RDFException, TypeException, FilterException {
        return this.translateQueryPattern(nArray, string, stringArray, string2, l, string3, lArray, lArray2, lArray3, stringArray2, hashMap, string4, stringArray3, nArray2, list, stringArray4, nArray3, n, map, null, null, string5, string6);
    }

    public String translateQueryPattern(int[] nArray, String string, String[] stringArray, String string2, long l, String string3, long[] lArray, long[] lArray2, long[] lArray3, String[] stringArray2, HashMap hashMap, String string4, String[][] stringArray3, int[] nArray2, List<Integer> list, String[] stringArray4, int[] nArray3, int n, Map<String, String> map, SPMComponents sPMComponents, SQLGenContext sQLGenContext, String string5, String string6) throws SQLException, ParseException, RDFException, TypeException, FilterException {
        String string7;
        boolean bl;
        Object object;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        sparqlSemAnalyzer sparqlSemAnalyzer2 = null;
        String string8 = null;
        SQLGenContext sQLGenContext2 = null;
        sQLGenContext2 = sQLGenContext == null ? new SQLGenContext() : sQLGenContext;
        sQLGenContext2.conn = this.conn;
        sQLGenContext2.dbVersion = QueryUtils.getDatabaseVersion(this.conn);
        if (!sQLGenContext2.dbVersion.isCompatible(OracleDatabaseVersion.V_12_2)) {
            throw new RDFException("Database versions older than 12.2 are not supported");
        }
        sQLGenContext2.clnNetworkOwner = QueryUtils.getNetworkOwnerOrMdsys(string5);
        sQLGenContext2.clnNetworkName = QueryUtils.getNetworkNameOrEmptyString(string6);
        sQLGenContext2.clnPfxForRdfObjName = QueryUtils.getPfxForRdfObjName(sQLGenContext2.clnNetworkOwner, sQLGenContext2.clnNetworkName);
        if (!sQLGenContext2.isModelMetadataInited()) {
            sQLGenContext2.networkStorageForm = QueryUtils.getNetworkStorageForm(this.conn, sQLGenContext2.clnPfxForRdfObjName);
        }
        this.parser.reset();
        ASTInput aSTInput = this.parser.parse(string, hashMap, this.getOptions() + (sQLGenContext2.networkStorageForm.equals("UNESC") ? " STORAGE_FORM=UNESC " : ""));
        if (map != null) {
            map.putAll(this.parser.getOrigVarMap());
        }
        sQLGenContext2.queryOptions = this.getOptions();
        this.setJenaOptions(hashMap, sQLGenContext2);
        SPARQLEngine.setOptimizerHints(hashMap, sQLGenContext2);
        if ((this.flag & 1) != 0) {
            object = this.getPatternVariables(string, sQLGenContext2.queryOptions, false);
            nArray = new int[((String[])object).length / 2];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        }
        if (aSTInput.id == 0) {
            SimpleNode simpleNode = (SimpleNode)aSTInput.jjtGetChild(0);
            if (simpleNode.id == 3) {
                bl4 = true;
                sQLGenContext2.syntaxType = 3;
            } else if (simpleNode.id == 5) {
                bl2 = true;
                sQLGenContext2.syntaxType = 5;
            } else if (simpleNode.id == 2) {
                bl3 = true;
                sQLGenContext2.syntaxType = 2;
            } else {
                System.out.println("Unexpected AST firstChild id: " + simpleNode.id + "\n");
            }
        } else {
            System.out.println("Unexpected AST root id: " + aSTInput.id + "\n");
        }
        if (!(bl2 || bl4 || bl3)) {
            return "Unrecognized RDF Query format!";
        }
        object = QueryUtils.getLocalValueDollarName(sQLGenContext2.clnPfxForRdfObjName);
        String string9 = QueryUtils.extractBracketedOption(sQLGenContext2.queryOptions.toUpperCase(), "USE_LOCAL_VALUES");
        if (string9 != null && !QueryUtils.isSafeTabName((String)(object = string9))) {
            throw new RDFException("Invalid local values table name");
        }
        this.parser.URIs.resolve(this.conn, (String)object);
        if (sQLGenContext2.queryOptions.indexOf("OPT_SAMEAS=T") != -1) {
            this.parser.URIs.updateToCanonicalIDs(this.conn, string2, sQLGenContext2.clnPfxForRdfObjName);
        }
        this.parser.literals.resolve(this.conn, (String)object, sQLGenContext2.dbVersion);
        if ((this.flag & 2) > 0) {
            if (!bl3) {
                throw new ParseException("VPD: Unrecognized RDF Query format for VPD. Use Curly Brace Syntax");
            }
            sparqlSemAnalyzer2 = new sparqlSemAnalyzer(stringArray, true, this.conn, this.parser.URIs, this.parser.literals);
            if (aSTInput instanceof ASTInput) {
                sparqlSemAnalyzer2.applyVPDPolicy(aSTInput);
            } else {
                throw new RDFException("RDFVPD Internal Error [root node is not of ASTInput type]");
            }
        }
        sQLGenContext2.srcTabName = "BASIC_TRIPLES";
        sQLGenContext2.URImap = this.parser.URIs;
        sQLGenContext2.varMap = this.parser.variables;
        sQLGenContext2.litMap = this.parser.literals;
        sQLGenContext2.models = stringArray;
        sQLGenContext2.model_types = nArray3;
        sQLGenContext2.isRdfVWModel = n == 1;
        if ((this.flag & 0x98) > 0) {
            if (!bl3) {
                throw new ParseException("CTX: Unrecognized RDF Query format for Semantic Search. Use Curly Brace Syntax");
            }
            if ((this.flag & 0x80) > 0) {
                sQLGenContext2.contextFlags |= 4;
            }
            if ((this.flag & 8) > 0) {
                sQLGenContext2.contextFlags |= 1;
            }
            if ((this.flag & 0x10) > 0) {
                sQLGenContext2.contextFlags |= 2;
            }
        }
        if (this.parser.baseURISet) {
            sQLGenContext2.baseURI = this.parser.baseURI.getBaseURI();
            sQLGenContext2.baseURIset = 1;
        }
        boolean bl5 = bl = sQLGenContext2.queryOptions.indexOf(TOP_DOWN_TRANS) >= 0;
        if (!bl && (bl2 || bl3)) {
            if (sQLGenContext2.queryOptions.indexOf("__localBindQ=[") >= 0) {
                int n2 = sQLGenContext2.queryOptions.indexOf("__localBindQ=[");
                int n3 = sQLGenContext2.queryOptions.indexOf("]", n2);
                string8 = sQLGenContext2.queryOptions.substring(n2 + 14, n3);
                System.out.println("bindSQL=[" + string8 + "]");
            }
            SPARQLEngine.setQueryOptions(sQLGenContext2, this.flag);
            SPARQLEngine.setTripleRowSources(sQLGenContext2, stringArray, string2, l, string3, string4, lArray, lArray2, lArray3, stringArray2, this.flag);
            string7 = SPARQLEngine.translateSPARQL(sQLGenContext2, aSTInput, this.parser.getTopLevelQueryNode(), nArray, string8, sPMComponents);
        } else {
            sQLGenContext2.usingTopDownTrans = true;
            sQLGenContext2.filterFlags |= 4;
            GenerateQuery generateQuery = new GenerateQuery(string.endsWith(" "), sQLGenContext2.queryOptions);
            String string10 = generateQuery.resolveModels(sQLGenContext2, stringArray, string2, l, string3, string4, lArray, lArray2, lArray3, stringArray2, this.flag);
            generateQuery.addWithMap("BASIC_TRIPLES", string10);
            if (bl2 || bl3) {
                if (bl2 && bl) {
                    throw new ParseException("Top-down translation is not allowed with full SPARQL syntax");
                }
                string7 = generateQuery.buildSQLfromSPARQL(sQLGenContext2, aSTInput, this.parser.getTopLevelQueryNode(), nArray, this.flag, nArray2, list, stringArray4);
            } else {
                generateQuery.buildHint(sQLGenContext2, false);
                generateQuery.buildJoin_LINK(sQLGenContext2, aSTInput);
                if ((this.flag & 1) != 0) {
                    generateQuery.buildJoin_VALUE(sQLGenContext2, null);
                } else {
                    generateQuery.buildJoin_VALUE(sQLGenContext2, nArray);
                }
                generateQuery.buildHint(sQLGenContext2, true);
                if (generateQuery.hint0present) {
                    generateQuery.adjustWhereVec(sQLGenContext2);
                }
                string7 = generateQuery.buildSQLQuery(true);
            }
        }
        if (this.parser.hasTopLevelQueryNode()) {
            ASTTopLevelQueryNode aSTTopLevelQueryNode = this.parser.getTopLevelQueryNode();
            String string11 = "";
            if (this.getOptions() != null) {
                string11 = this.getOptions().toUpperCase();
            }
            stringArray3[0] = string11.indexOf(PG_MATCH) >= 0 ? aSTTopLevelQueryNode.getselDesc().returnPGSignature() : (string11.indexOf(RDF_TERMS_ONLY) >= 0 ? aSTTopLevelQueryNode.getselDesc().returnSignature(false) : (string11.indexOf(PLUS_RDF_TERMS) >= 0 ? aSTTopLevelQueryNode.getselDesc().returnVDollarSignature(true, false) : (string11.indexOf(VC_TERMS_ONLY) >= 0 ? aSTTopLevelQueryNode.getselDesc().returnSignature(true) : (string11.indexOf(PLUS_VC_TERMS) >= 0 ? aSTTopLevelQueryNode.getselDesc().returnVDollarSignature(true, true) : aSTTopLevelQueryNode.getselDesc().returnVDollarSignature(false, false)))));
        } else {
            stringArray3[0] = this.parser.variables.returnSignature();
        }
        if ((this.flag & 4) == 0 && string7.length() > 64536) {
            String string12 = "Query length [" + string7.length() + "] exceedes max query rewrite length [" + 64536 + "] ... falling back to start-fetch-close strategy\n";
            QueryUtils.log(string12);
            string7 = "";
            nArray2[0] = nArray2[0] | 2;
        }
        if (string7 != "" && sQLGenContext2.spmUsedInQuery && sQLGenContext2.spmCostBased && !sQLGenContext2.spmEnforced) {
            long l2 = 0L;
            long l3 = 0L;
            l2 = this.getPlanCost(string7);
            sQLGenContext2.spmEnabled = false;
            String string13 = SPARQLEngine.translateSPARQL(sQLGenContext2, aSTInput, this.parser.getTopLevelQueryNode(), nArray, string8, sPMComponents);
            if ((this.flag & 4) == 0 && string13.length() > 64536) {
                return string7;
            }
            l3 = this.getPlanCost(string13);
            if (l2 > l3) {
                return string13;
            }
        }
        return string7;
    }

    public String unparse(Vector vector, HashSet hashSet, URIset uRIset) {
        String string = "";
        for (ASTTripleAtom[] aSTTripleAtomArray : vector) {
            string = string + "(";
            block9: for (int i = 0; i < 3; ++i) {
                ASTTripleAtom aSTTripleAtom = aSTTripleAtomArray[i];
                if (i > 0) {
                    string = string + " ";
                }
                switch (aSTTripleAtom.type) {
                    case 0: {
                        string = string + "?" + aSTTripleAtom.name;
                        continue block9;
                    }
                    case 1: {
                        string = string + "<" + aSTTripleAtom.name + ">";
                        if (i != 1 || hashSet == null) continue block9;
                        hashSet.add(uRIset.get(aSTTripleAtom.name));
                        continue block9;
                    }
                    case 2: {
                        string = string + aSTTripleAtom.name;
                        continue block9;
                    }
                    case 3: {
                        string = string + "\"" + aSTTripleAtom.name + "\"";
                        continue block9;
                    }
                    case 4: {
                        string = string + "\"" + aSTTripleAtom.name + "\"@" + aSTTripleAtom.litLang;
                        continue block9;
                    }
                    case 5: 
                    case 6: {
                        string = string + "\"" + aSTTripleAtom.name + "\"^^<" + aSTTripleAtom.litType + ">";
                    }
                }
            }
            string = string + ")";
        }
        return string;
    }

    public long[] expandPattern(String[] stringArray, String[] stringArray2, HashMap hashMap, int[] nArray, int[] nArray2, String string, String string2) throws ParseException, SQLException, RDFException {
        Set set;
        VariableSet variableSet;
        ASTInput aSTInput;
        HashSet hashSet = new HashSet();
        String string3 = QueryUtils.getNetworkStorageForm(this.conn, QueryUtils.getPfxForRdfObjName(QueryUtils.getNetworkOwnerOrMdsys(string), QueryUtils.getNetworkNameOrEmptyString(string2)));
        String string4 = this.getOptions() + (string3.equals("UNESC") ? " STORAGE_FORM=UNESC " : "");
        this.parser.reset();
        if (stringArray[0].equals("")) {
            aSTInput = null;
            variableSet = null;
            set = null;
        } else {
            aSTInput = this.parser.parse(stringArray[0], hashMap, string4);
            variableSet = this.parser.variables;
            set = variableSet.set.keySet();
        }
        ASTInput aSTInput2 = this.parser.parse(stringArray2[0], hashMap, string4);
        VariableSet variableSet2 = this.parser.variables;
        Set set2 = variableSet2.set.keySet();
        if (set != null) {
            set2.removeAll(set);
        }
        if (!set2.isEmpty()) {
            throw new RDFException("Consequent variable '" + (String)set2.iterator().next() + "' is unbound in antecedent.");
        }
        String string5 = QueryUtils.getLocalValueDollarName(QueryUtils.getPfxForRdfObjName(QueryUtils.getNetworkOwnerOrMdsys(string), QueryUtils.getNetworkNameOrEmptyString(string2)));
        this.parser.URIs.resolve(this.conn, string5);
        this.parser.URIs.createUnresolved(this.conn);
        this.parser.literals.resolve(this.conn, string5);
        this.parser.literals.createUnresolved(this.conn);
        if (aSTInput != null) {
            aSTInput.collect();
            stringArray[0] = this.unparse(aSTInput.getTriples(), hashSet, this.parser.URIs);
        }
        aSTInput2.collect();
        stringArray2[0] = this.unparse(aSTInput2.getTriples(), hashSet, this.parser.URIs);
        nArray[0] = aSTInput2.getNTriples();
        nArray2[0] = aSTInput2.getNVars();
        if (hashSet.isEmpty()) {
            return null;
        }
        long[] lArray = new long[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            long l;
            String string6 = (String)iterator.next();
            lArray[n] = l = Long.parseLong(string6);
            ++n;
        }
        return lArray;
    }

    public ArrayList<String> processVPDPatterns(String[] stringArray, String[] stringArray2, HashMap hashMap) throws ParseException, RDFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.parser.reset();
        ASTInput aSTInput = this.parser.parse(stringArray[0], hashMap, this.getOptions());
        VariableSet variableSet = this.parser.variables;
        Set set = variableSet.set.keySet();
        ASTInput aSTInput2 = this.parser.parse(stringArray2[0], hashMap, this.getOptions());
        VariableSet variableSet2 = this.parser.variables;
        Set set2 = variableSet2.set.keySet();
        int n = set2.size();
        if (set != null) {
            set2.removeAll(set);
        }
        if (n == set2.size()) {
            throw new RDFException("invalid apply pattern with all unbound variables");
        }
        try {
            this.parser.URIs.resolve(this.conn);
            this.parser.URIs.createUnresolved(this.conn);
            this.parser.literals.resolve(this.conn);
            this.parser.literals.createUnresolved(this.conn);
        }
        catch (SQLException sQLException) {
            throw new RDFException("URI/Literal resolution error:" + sQLException.getMessage(), sQLException);
        }
        GGPReduceOptimizer gGPReduceOptimizer = new GGPReduceOptimizer();
        try {
            aSTInput = (ASTInput)gGPReduceOptimizer.optimizeQuery(aSTInput);
            aSTInput2 = (ASTInput)gGPReduceOptimizer.optimizeQuery(aSTInput2);
        }
        catch (Exception exception) {
            throw new RDFException(exception.getMessage(), exception);
        }
        sparqlSemAnalyzer.processVPDConstraint(set2, aSTInput, aSTInput2, this.parser.URIs, this.parser.literals, arrayList);
        stringArray[0] = sparqlSemAnalyzer.unparseSparql(aSTInput);
        stringArray2[0] = sparqlSemAnalyzer.unparseSparql(aSTInput2);
        return arrayList;
    }
}

