/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.parser.QuadHandler;
import oracle.sql.CLOB;

public class StgTabInsertRDFHandler
implements QuadHandler {
    private String stabOwner;
    private String vcStabName;
    private String clobStabName;
    private String destGraph;
    private static Connection sConn;
    private Connection conn;
    private PreparedStatement vcPs;
    private PreparedStatement clobPs;
    private List<Clob> clobs = null;
    private static final int DEFAULT_BATCH_SIZE = 10000;
    private int quadsInBatch;
    private int numVc;
    private int numClob;
    private String options;
    private boolean tripleOnly;
    private static final String TRIPLE_ONLY_FLAG = "TRIPLE_ONLY=T";
    private boolean debug;
    private static final String DEBUG_FLAG = "DEBUG=T";
    private static DateFormat dateFormat;

    public StgTabInsertRDFHandler(String string, String string2, String string3, String string4, Connection connection, String string5) throws SQLException {
        this.stabOwner = string;
        this.vcStabName = string2;
        this.clobStabName = string3;
        this.destGraph = string4;
        this.conn = connection == null ? this.getConnection() : connection;
        this.options = string5;
    }

    @Override
    public void init() throws RDFException {
        try {
            this.setOptions();
            String string = QueryUtils.enquoteNameSQLName(this.stabOwner);
            String string2 = QueryUtils.enquoteNameSQLName(this.vcStabName);
            String string3 = "";
            if (this.clobStabName != null) {
                string3 = QueryUtils.enquoteNameSQLName(this.clobStabName);
            }
            String string4 = "";
            string4 = this.tripleOnly ? "INSERT /*+ APPEND */ INTO " + string + "." + string2 + "(RDF$STC_SUB, RDF$STC_PRED, RDF$STC_OBJ) VALUES (?,?,?)" : "INSERT /*+ APPEND */ INTO " + string + "." + string2 + "(RDF$STC_SUB, RDF$STC_PRED, RDF$STC_OBJ, RDF$STC_GRAPH) VALUES (?,?,?,?)";
            StgTabInsertRDFHandler.log("VC insert statement:\n" + string4, this.debug);
            this.vcPs = this.conn.prepareStatement(string4);
            if (this.clobStabName != null) {
                String string5 = "";
                string5 = this.tripleOnly ? "INSERT /*+ APPEND */ INTO " + string + "." + string3 + "(RDF$STC_SUB, RDF$STC_PRED, RDF$STC_OBJ) VALUES (?,?,?)" : "INSERT /*+ APPEND */ INTO " + string + "." + string3 + "(RDF$STC_SUB, RDF$STC_PRED, RDF$STC_OBJ, RDF$STC_GRAPH) VALUES (?,?,?,?)";
                StgTabInsertRDFHandler.log("CLOB insert statement:\n" + string5, this.debug);
                this.clobPs = this.conn.prepareStatement(string5);
            } else {
                StgTabInsertRDFHandler.log("CLOB staging table is null ... skipping CLOB support", this.debug);
            }
            this.quadsInBatch = 0;
            this.numVc = 0;
            this.numClob = 0;
            this.clobs = new ArrayList<Clob>();
        }
        catch (SQLException sQLException) {
            throw new RDFException("Exception initializing quad handler:" + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void processQuad(String string, String string2, String string3, String string4) throws RDFException {
        try {
            if (string4 != null && this.tripleOnly) {
                throw new RDFException("Encountered quad GRAPH " + string4 + " { " + string + " " + string2 + " " + string3 + " . } in triple-only mode");
            }
            String string5 = "";
            string5 = this.destGraph != null ? this.destGraph : string4;
            if (this.debug) {
                StgTabInsertRDFHandler.log("Adding quad to batch:[" + string5 + "," + string + "," + string2 + "," + string3 + "]", this.debug);
            }
            if (string3.length() <= 4000) {
                this.vcPs.setString(1, string);
                this.vcPs.setString(2, string2);
                this.vcPs.setString(3, string3);
                if (!this.tripleOnly) {
                    this.vcPs.setString(4, string5);
                }
                this.vcPs.addBatch();
                ++this.quadsInBatch;
                ++this.numVc;
            } else {
                if (this.clobStabName == null) {
                    throw new RDFException("Triple object exceeds 4000 bytes");
                }
                this.clobPs.setString(1, string);
                this.clobPs.setString(2, string2);
                CLOB cLOB = CLOB.createTemporary((Connection)this.conn, (boolean)false, (int)10);
                cLOB.setString(1L, string3);
                this.clobPs.setClob(3, (Clob)cLOB);
                this.clobs.add((Clob)cLOB);
                if (!this.tripleOnly) {
                    this.clobPs.setString(4, string5);
                }
                this.clobPs.addBatch();
                ++this.quadsInBatch;
                ++this.numClob;
            }
            if (this.quadsInBatch >= 10000) {
                this.executeAndClean();
            }
        }
        catch (SQLException sQLException) {
            this.closePreparedStatement();
            throw new RDFException("Exception processing quad:" + sQLException.getMessage(), sQLException);
        }
        catch (RDFException rDFException) {
            this.closePreparedStatement();
            throw rDFException;
        }
    }

    @Override
    public void commit() throws RDFException {
        try {
            if (this.quadsInBatch > 0) {
                this.executeAndClean();
            }
            StgTabInsertRDFHandler.log("Committing inserts", this.debug);
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new RDFException("Exception during commit:" + sQLException.getMessage(), sQLException);
        }
        finally {
            this.closePreparedStatement();
        }
    }

    private void setOptions() {
        String[] stringArray = new String[]{""};
        if (this.options != null) {
            stringArray[0] = this.options.toUpperCase();
        }
        this.debug = false;
        if (stringArray[0].contains(DEBUG_FLAG)) {
            this.debug = true;
        }
        this.tripleOnly = false;
        if (stringArray[0].contains(TRIPLE_ONLY_FLAG)) {
            this.tripleOnly = true;
        }
    }

    private Connection getConnection() throws SQLException {
        if (sConn == null) {
            sConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return sConn;
    }

    private void executeAndClean() throws SQLException {
        try {
            StgTabInsertRDFHandler.log("Executing batch of size " + this.quadsInBatch, this.debug);
            StgTabInsertRDFHandler.log("Num VC=[" + this.numVc + "] Num Clob=[" + this.numClob + "]", this.debug);
            if (this.numVc > 0) {
                StgTabInsertRDFHandler.log("Executing VC batch of size " + this.numVc, this.debug);
                this.vcPs.executeBatch();
            }
            if (this.numClob > 0) {
                StgTabInsertRDFHandler.log("Executing Clob batch of size " + this.numClob, this.debug);
                this.clobPs.executeBatch();
            }
            StgTabInsertRDFHandler.log("Committing batch", this.debug);
            this.conn.commit();
        }
        finally {
            this.quadsInBatch = 0;
            this.numVc = 0;
            this.numClob = 0;
            this.cleanupClobs();
        }
    }

    private void cleanupClobs() {
        if (this.clobs != null) {
            for (Clob clob : this.clobs) {
                try {
                    if (clob == null) continue;
                    clob.free();
                }
                catch (SQLException sQLException) {
                    StgTabInsertRDFHandler.log("Exception found cleaning clob:" + sQLException.getMessage(), this.debug);
                }
            }
            this.clobs.clear();
        }
    }

    private void closePreparedStatement() {
        try {
            if (this.vcPs != null) {
                this.vcPs.close();
            }
        }
        catch (SQLException sQLException) {
            StgTabInsertRDFHandler.log("Exception found closing VC prepared statement:" + sQLException.getMessage(), this.debug);
        }
        try {
            if (this.clobPs != null) {
                this.clobPs.close();
            }
        }
        catch (SQLException sQLException) {
            StgTabInsertRDFHandler.log("Exception found closing Clob prepared statement:" + sQLException.getMessage(), this.debug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String string, boolean bl) {
        if (bl) {
            String string2;
            DateFormat dateFormat = StgTabInsertRDFHandler.dateFormat;
            synchronized (dateFormat) {
                string2 = StgTabInsertRDFHandler.dateFormat.format(Calendar.getInstance().getTime());
            }
            QueryUtils.log("LOAD_TTL [" + string2 + "]: " + string + "\n");
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    }
}

