/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectivityEstimator;
import oracle.spatial.rdf.server.SelectivityOptimizer;
import oracle.spatial.rdf.server.SimpleFilterEstimator;
import oracle.spatial.rdf.server.SimpleSelectivityEstimator;
import oracle.spatial.rdf.server.SimpleSelectivityOptimizer;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class SimpleStatsHintProvider
extends HintProvider {
    public static final String ALL_USE_STATS_HINT = "ALL_USE_RDF_STATS";
    public static final String USE_STATS_HINT = "USE_RDF_STATS";
    private static final String FIRST_ONLY_HINT = "FIRST_ONLY";
    private static final String AUTOMATIC_HINT = "AUTO";
    private static final String FULL_HINT = "*";
    private static final HintProvider.HintToken RDF_STATS_TOKEN = HintProvider.HintToken.createNoArgToken("USE_RDF_STATS");
    private static final HintProvider.HintToken RDF_STATS_ARG_TOKEN = HintProvider.HintToken.createToken("USE_RDF_STATS");
    private static final HintProvider.HintToken ALL_STATS_TOKEN = HintProvider.HintToken.createNoArgToken("ALL_USE_RDF_STATS");
    private static final HintProvider.HintToken ALL_STATS_ARG_TOKEN = HintProvider.HintToken.createToken("ALL_USE_RDF_STATS");
    private static final Pattern FIRST_ONLY_PATTERN = SimpleStatsHintProvider.compilePattern("FIRST_ONLY");
    private static final Pattern AUTOMATIC_PATTERN = SimpleStatsHintProvider.compilePattern("AUTO");
    private static final Pattern FULL_PATTERN = SimpleStatsHintProvider.compilePattern(Pattern.quote("*"));
    private static final Pattern EXACT_PATTERN = SimpleStatsHintProvider.compilePattern("[0-9]+");
    private static final String LOG_HINT = "LOG";
    private static final String HASH_LARGE_HINT = "HASH_LARGE";
    private static final long HASH_LARGE_THRESHOLD = 100000L;
    private static final String[] OPTIONAL_HINTS = new String[]{"LOG"};
    private static final Pattern OPTIONALS_PATTERN;
    private static final String LEADING_HINT = "LEADING";
    private static final Map<HintProvider.HintToken, Enum> TOKENS;
    private static final SimpleStatsHintProvider instance;
    private final SelectivityEstimator estimator = new SimpleFilterEstimator(SimpleSelectivityEstimator.getInstance());
    private final SelectivityOptimizer optimizer = new SimpleSelectivityOptimizer(this.estimator);

    private static Pattern compilePattern(String string) {
        return Pattern.compile("^\\s*(" + string + ")\\s*$", 2);
    }

    private SimpleStatsHintProvider() {
    }

    public static SimpleStatsHintProvider getInstance() {
        return instance;
    }

    @Override
    protected Map<HintProvider.HintToken, Enum> getParsableTokens() {
        return TOKENS;
    }

    @Override
    protected void parseToken(HintProvider.HintContext hintContext, HintProvider.HintToken hintToken, Enum enum_) throws ParseException {
        int n;
        SPARQLBGP sPARQLBGP = hintContext.getSPARQLBGP();
        SQLGenContext sQLGenContext = hintContext.getSQLGenContext();
        HintProvider.HintBuilder hintBuilder = hintContext.getHintBuilder();
        Type type = Type.valueOf(enum_.name());
        try {
            switch (type) {
                case ARGS: {
                    n = SimpleStatsHintProvider.processArgs(hintToken.getChildren(), sPARQLBGP);
                    break;
                }
                default: {
                    n = SimpleStatsHintProvider.processArgs(new LinkedList<HintProvider.HintToken>(), sPARQLBGP);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
        if (sPARQLBGP.getTriplesBlocks().isEmpty()) {
            return;
        }
        boolean bl = this.loggingEnabled(hintToken.getChildren());
        HintEngine.getSessionContext().setLogStats(bl);
        long l = 0L;
        boolean bl2 = this.hashLargeResultsEnabled(hintToken.getChildren());
        switch (Type.valueOf(enum_.name())) {
            case ARGS: 
            case DEFAULT: {
                try {
                    if (bl) {
                        l = System.currentTimeMillis();
                    }
                    SelectivityOptimizer.Plan plan = this.optimizer.optimize(sQLGenContext, sPARQLBGP);
                    if (bl) {
                        SimpleStatsHintProvider.logDuration("Optimized BGP", l);
                    }
                    if (plan == null) {
                        return;
                    }
                    if (bl) {
                        l = System.currentTimeMillis();
                    }
                    Hint.SQLHint sQLHint = this.generateLeadingHint(sPARQLBGP, sQLGenContext, plan, n);
                    if (bl) {
                        SimpleStatsHintProvider.logDuration("Generated LEADING hint", l);
                    }
                    if (bl) {
                        System.out.printf("[%5s] %7s: %s\n", "stats", "debug", sQLHint == null ? "no LEADING hint generated" : "hint generated: " + sQLHint);
                    }
                    if (sQLHint != null) {
                        hintBuilder.addSQLHint(sQLHint);
                    }
                    if (!bl2) break;
                    long l2 = this.getHashLargeThreshold(hintToken.getChildren());
                    if (bl) {
                        l = System.currentTimeMillis();
                    }
                    Hint.SQLHint sQLHint2 = this.generateUseHashHint(sPARQLBGP, sQLGenContext, plan, l2);
                    if (bl) {
                        SimpleStatsHintProvider.logDuration("Generated USE_HASH hint", l);
                    }
                    if (bl) {
                        System.out.printf("[%5s] %7s: %s\n", "stats", "debug", sQLHint2 == null ? "no USE_HASH hint generated" : "hint generated: " + sQLHint2);
                    }
                    if (sQLHint2 == null) break;
                    hintBuilder.addSQLHint(sQLHint2);
                }
                catch (SQLException sQLException) {
                    System.err.printf("[%5s] %7s: %s\n", "stats", "warning", String.format("unable to generate hint based on statistics: %s", sQLException.getMessage()));
                }
                break;
            }
            default: {
                System.err.printf("[%5s] %7s: %s\n", "stats", "warning", String.format("unrecognized hint token type '%s' found for token '%s'. Skipping hint.", enum_, hintToken.getValue()));
            }
        }
    }

    private boolean hintEnabled(List<HintProvider.HintToken> list, String string) {
        for (HintProvider.HintToken hintToken : list) {
            String string2 = hintToken.getValue();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean loggingEnabled(List<HintProvider.HintToken> list) {
        return this.hintEnabled(list, LOG_HINT);
    }

    private boolean hashLargeResultsEnabled(List<HintProvider.HintToken> list) {
        return this.hintEnabled(list, HASH_LARGE_HINT);
    }

    private long getHashLargeThreshold(List<HintProvider.HintToken> list) {
        for (HintProvider.HintToken hintToken : list) {
            String string = hintToken.getValue();
            if (!string.equalsIgnoreCase(HASH_LARGE_HINT)) continue;
            if (hintToken.getChildren().size() == 1) {
                HintProvider.HintToken hintToken2 = hintToken.getChildren().get(0);
                try {
                    long l = Long.parseLong(hintToken2.getValue());
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.printf("[%5s] %7s: %s\n", "stats", "error", String.format("invalid value found for %s, using default instead", HASH_LARGE_HINT));
                    break;
                }
            }
            if (hintToken.getChildren().size() <= 1) break;
            System.err.printf("[%5s] %7s: %s\n", "stats", "error", String.format("invalid number of arguments passed to %s, using default instead", HASH_LARGE_HINT));
            break;
        }
        return 100000L;
    }

    private static void logDuration(String string, long l) {
        System.out.printf("[%5s] %7s: %s\n", "stats", "debug", String.format("%2$6.2f s | %1$s", string, (double)(System.currentTimeMillis() - l) / 1000.0));
    }

    private Hint.SQLHint generateLeadingHint(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, SelectivityOptimizer.Plan plan, int n) {
        if (n == 0) {
            n = SimpleStatsHintProvider.estimateTableCount(sPARQLBGP, plan);
        }
        if (sPARQLBGP.getTriplesBlocks().size() != plan.getNumJoins() + 1) {
            throw new IllegalArgumentException("original and optimized BGPs must have same number of triples, found " + (plan.getNumJoins() + 1) + ", expected " + sPARQLBGP.getTriplesBlocks().size());
        }
        SQLHintVisitor sQLHintVisitor = new SQLHintVisitor(sPARQLBGP, sQLGenContext, n);
        plan.getExecutionRoot().accept(sQLHintVisitor);
        return sQLHintVisitor.getHint();
    }

    private Hint.SQLHint generateUseHashHint(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, SelectivityOptimizer.Plan plan, long l) {
        if (sPARQLBGP.getTriplesBlocks().size() != plan.getNumJoins() + 1) {
            throw new IllegalArgumentException("original and optimized BGPs must have same number of triples, found " + (plan.getNumJoins() + 1) + ", expected " + sPARQLBGP.getTriplesBlocks().size());
        }
        HashLargeResultsVisitor hashLargeResultsVisitor = new HashLargeResultsVisitor(sPARQLBGP, sQLGenContext, l);
        plan.getExecutionRoot().accept(hashLargeResultsVisitor);
        return hashLargeResultsVisitor.getHint();
    }

    private static int estimateTableCount(SPARQLBGP sPARQLBGP, SelectivityOptimizer.Plan plan) {
        List<Filter> list = sPARQLBGP.getFilters();
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter filter : list) {
            hashSet.addAll(filter.getVars());
        }
        TableCountVisitor tableCountVisitor = new TableCountVisitor(hashSet);
        plan.getExecutionRoot().accept(tableCountVisitor);
        return tableCountVisitor.getTableCount();
    }

    private static int processArgs(List<HintProvider.HintToken> list, SPARQLBGP sPARQLBGP) {
        for (HintProvider.HintToken hintToken : list) {
            int n;
            String string = hintToken.getValue();
            Matcher matcher = OPTIONALS_PATTERN.matcher(string);
            if (matcher.matches()) continue;
            matcher = FIRST_ONLY_PATTERN.matcher(string);
            if (matcher.matches()) {
                return 1;
            }
            matcher = AUTOMATIC_PATTERN.matcher(string);
            if (matcher.matches()) {
                return 0;
            }
            matcher = FULL_PATTERN.matcher(string);
            if (matcher.matches()) {
                return sPARQLBGP.getTriplesBlocks().size();
            }
            matcher = EXACT_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n <= 0) {
                System.err.printf("[%5s] %7s: %s\n", "stats", "error", "Invalid table count, " + string2 + ", for " + USE_STATS_HINT + ".  Table count must be a positive integer.");
                throw new IllegalArgumentException("USE_RDF_STATS argument '" + string2 + "' is out of range.  Must be positive.");
            }
            if (n > sPARQLBGP.getTriplesBlocks().size()) {
                n = sPARQLBGP.getTriplesBlocks().size();
            }
            return n;
        }
        return 0;
    }

    private static List<Hint.SQLHint.Arg> toTripleAliases(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, List<TriplesBlock> list) {
        BasicGraphPattern basicGraphPattern = new BasicGraphPattern();
        basicGraphPattern.addAll(sPARQLBGP.getTriplesBlocks(), sQLGenContext);
        List<TriplesBlock> list2 = basicGraphPattern.getTriplesList();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList<Hint.SQLHint.Arg> linkedList2 = new LinkedList<Hint.SQLHint.Arg>();
        block0: for (TriplesBlock triplesBlock : list) {
            int n = 0;
            for (TriplesBlock triplesBlock2 : list2) {
                if (!linkedList.contains(n) && triplesBlock2.equals(triplesBlock)) {
                    linkedList.add(n);
                    String string = String.format("t%d", n);
                    linkedList2.add(Hint.SQLHint.Arg.createStaticArgument(string));
                    continue block0;
                }
                ++n;
            }
            System.err.printf("[%5s] %7s: %s\n", "stats", "error", "unable to find alias for triple: ", triplesBlock);
            System.err.printf("[%5s] %7s: %s\n", "stats", "error", "skipping remaining table aliases to avoid bad hint");
            break;
        }
        return linkedList2;
    }

    static {
        Serializable serializable = new StringBuilder();
        for (int i = 0; i < OPTIONAL_HINTS.length; ++i) {
            ((StringBuilder)serializable).append(Pattern.quote(OPTIONAL_HINTS[i]));
            if (i == OPTIONAL_HINTS.length - 1) continue;
            ((StringBuilder)serializable).append("|");
        }
        OPTIONALS_PATTERN = SimpleStatsHintProvider.compilePattern(((StringBuilder)serializable).toString());
        serializable = new HashMap();
        serializable.put(RDF_STATS_TOKEN, Type.DEFAULT);
        serializable.put(RDF_STATS_ARG_TOKEN, Type.ARGS);
        serializable.put(ALL_STATS_TOKEN, Type.DEFAULT);
        serializable.put(ALL_STATS_ARG_TOKEN, Type.ARGS);
        TOKENS = Collections.unmodifiableMap(serializable);
        instance = new SimpleStatsHintProvider();
    }

    public static class HashLargeResultsVisitor
    implements SelectivityOptimizer.OpVisitor {
        private static final String USE_HASH = "USE_HASH";
        private static final int MAX_TABLES = 1;
        private final long threshold;
        private final List<TriplesBlock> largeResultTriples;
        private final SPARQLBGP original;
        private final SQLGenContext context;
        private int seenCount;

        public HashLargeResultsVisitor(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, long l) {
            this.threshold = l;
            this.original = sPARQLBGP;
            this.context = sQLGenContext;
            this.seenCount = 0;
            this.largeResultTriples = new LinkedList<TriplesBlock>();
        }

        public Hint.SQLHint getHint() {
            List list = SimpleStatsHintProvider.toTripleAliases(this.original, this.context, this.largeResultTriples);
            if (list.isEmpty()) {
                return null;
            }
            return Hint.SQLHint.createMultiArgHint(USE_HASH, list);
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Data data) {
            if (this.seenCount < 1 && data.getNumMatching() >= this.threshold) {
                this.largeResultTriples.add(data.getTriple());
            }
            ++this.seenCount;
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Access access) {
            access.getData().accept(this);
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Join join) {
            SelectivityOptimizer.Op op = join.getLeft();
            SelectivityOptimizer.Op op2 = join.getRight();
            op.accept(this);
            op2.accept(this);
        }
    }

    private static class TableCountVisitor
    implements SelectivityOptimizer.OpVisitor {
        private int tableCount;
        private boolean limitReached;
        private Set<String> filterVars;

        public TableCountVisitor(Set<String> set) {
            this.filterVars = set;
            this.tableCount = 0;
            this.limitReached = false;
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Data data) {
            if (this.limitReached) {
                return;
            }
            TriplesBlock triplesBlock = data.getTriple();
            TriplesBlock.Element[] elementArray = new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()};
            ++this.tableCount;
            for (TriplesBlock.Element element : elementArray) {
                if (!element.isVariable() || !this.filterVars.contains(element.getName())) continue;
                this.limitReached = true;
                return;
            }
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Access access) {
            access.getData().accept(this);
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Join join) {
            SelectivityOptimizer.Op op = join.getLeft();
            SelectivityOptimizer.Op op2 = join.getRight();
            op.accept(this);
            op2.accept(this);
        }

        public int getTableCount() {
            return this.tableCount;
        }
    }

    private static class SQLHintVisitor
    implements SelectivityOptimizer.OpVisitor {
        private static final String LEADING = "LEADING";
        private SPARQLBGP original;
        private SQLGenContext context;
        private Map<String, List<TriplesBlock>> hints;
        private Set<Integer> visited;
        private int tableCount;

        public SQLHintVisitor(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, int n) {
            this.tableCount = n;
            this.hints = new HashMap<String, List<TriplesBlock>>();
            this.visited = new HashSet<Integer>();
            this.original = sPARQLBGP;
            this.context = sQLGenContext;
            if (n <= 0 || n > this.original.getTriplesBlocks().size()) {
                throw new IllegalArgumentException("table count, " + n + ", is out of range");
            }
            this.hints.put("LEADING", new LinkedList());
        }

        public Hint.SQLHint getHint() {
            List list = SimpleStatsHintProvider.toTripleAliases(this.original, this.context, this.hints.get("LEADING"));
            if (list.isEmpty()) {
                return null;
            }
            return Hint.SQLHint.createMultiArgHint("LEADING", list);
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Data data) {
            if (this.tableCount == 0) {
                return;
            }
            this.hints.get("LEADING").add(data.getTriple());
            --this.tableCount;
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Access access) {
            access.getData().accept(this);
        }

        @Override
        public void visit(SelectivityOptimizer.Op.Join join) {
            SelectivityOptimizer.Op op = join.getLeft();
            SelectivityOptimizer.Op op2 = join.getRight();
            op.accept(this);
            op2.accept(this);
        }
    }

    private static enum Type {
        DEFAULT,
        ARGS;

    }
}

